/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.parser;

import java.util.Comparator;
import org.eclipse.jst.validation.sample.parser.PropertyLine;

public class PropertyLineComparator {
    private static PropertyLineComparator inst = new PropertyLineComparator();
    private static final Comparator _messagePrefixComparator = inst.new MessagePrefixComparator();
    private static final Comparator _messageIdComparator = inst.new MessageIdComparator();
    private static Comparator _stringLengthComparator = new StringLengthComparator();
    private static final Comparator _valueComparator = inst.new ValueComparator();
    private static final Comparator _lineNoComparator = inst.new LineNoComparator();

    private PropertyLineComparator() {
    }

    public static Comparator getMessagePrefixComparator() {
        return _messagePrefixComparator;
    }

    public static Comparator getMessageIdComparator() {
        return _messageIdComparator;
    }

    public static Comparator getStringLengthComparator(int length) {
        StringLengthComparator.length = length;
        return _stringLengthComparator;
    }

    public static Comparator getValueComparator() {
        return _valueComparator;
    }

    public static Comparator getLineNoComparator() {
        return _lineNoComparator;
    }

    private class MessagePrefixComparator
    implements Comparator {
        MessagePrefixComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            String aid = ((PropertyLine)a).getMessagePrefix();
            String bid = ((PropertyLine)b).getMessagePrefix();
            if (aid == null && bid == null) {
                return 0;
            }
            if (aid == null) {
                return -1;
            }
            if (bid == null) {
                return 1;
            }
            aid = aid.toUpperCase().trim();
            bid = bid.toUpperCase().trim();
            if (aid.equals("") && bid.equals("")) {
                return 0;
            }
            if (aid.equals("")) {
                return -1;
            }
            if (bid.equals("")) {
                return 1;
            }
            return ((PropertyLine)a).getShortMessagePrefix().toUpperCase().compareTo(((PropertyLine)b).getShortMessagePrefix().toUpperCase());
        }
    }

    private class MessageIdComparator
    implements Comparator {
        MessageIdComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            String aMessageId = null;
            String bMessageId = null;
            aMessageId = a instanceof PropertyLine ? ((PropertyLine)a).getMessageId() : (String)a;
            bMessageId = b instanceof PropertyLine ? ((PropertyLine)b).getMessageId() : (String)b;
            if (aMessageId == null && bMessageId == null) {
                return 0;
            }
            if (aMessageId == null) {
                return -1;
            }
            if (bMessageId == null) {
                return 1;
            }
            return aMessageId.compareTo(bMessageId);
        }
    }

    static class StringLengthComparator
    implements Comparator {
        public static int length = 0;

        StringLengthComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            int aLength = ((PropertyLine)a).getExpectedLength(length);
            int bLength = ((PropertyLine)b).getExpectedLength(length);
            return aLength - bLength;
        }
    }

    private class ValueComparator
    implements Comparator {
        ValueComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            String aMessage = ((PropertyLine)a).getMessage();
            String bMessage = ((PropertyLine)b).getMessage();
            if (aMessage == null && bMessage == null) {
                return 0;
            }
            if (aMessage == null) {
                return -1;
            }
            if (bMessage == null) {
                return 1;
            }
            return aMessage.compareTo(bMessage);
        }
    }

    private class LineNoComparator
    implements Comparator {
        LineNoComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            int aLineNo = ((PropertyLine)a).getLineNumber();
            int bLineNo = ((PropertyLine)b).getLineNumber();
            if (aLineNo < 0 && bLineNo < 0) {
                return 0;
            }
            if (aLineNo < 0) {
                return -1;
            }
            if (bLineNo < 0) {
                return 1;
            }
            return aLineNo - bLineNo;
        }
    }
}

