/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.fvtests;

import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.common.jdt.internal.integration.JavaProjectCreationDataModelProvider;
import org.eclipse.jst.common.jdt.internal.integration.JavaProjectMigrationDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.SimpleTestSuite;

public class ProjectMigrationTest
extends TestCase {
    public static String DEFAULT_PROJECT_NAME = "TestJavaProj";
    static /* synthetic */ Class class$0;

    public ProjectMigrationTest(String name) {
        super(name);
    }

    public ProjectMigrationTest() {
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.flexible.project.fvtests.ProjectMigrationTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SimpleTestSuite((Class)clazz);
    }

    public void testProjectMigration() throws Exception {
        this.runAll();
    }

    private void createJavaProject(IProgressMonitor monitor) throws CoreException {
        IProject project = ProjectUtilities.getProject((String)DEFAULT_PROJECT_NAME);
        if (project.exists()) {
            project.delete(true, true, null);
        }
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectCreationDataModelProvider());
        model.setProperty("IProjectCreationProperties.PROJECT_NAME", (Object)DEFAULT_PROJECT_NAME);
        String[] srcFolder = new String[]{new String("Src1"), new String("Src2")};
        model.setProperty("JavaProjectCreationDataModel.SOURCE_FOLDERS", (Object)srcFolder);
        try {
            model.getDefaultOperation().execute(monitor, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private IPath getOutputPath(IProject project) {
        String outputLocation = "bin";
        return project.getFullPath().append(outputLocation);
    }

    public void runAll() {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            this.createJavaProject((IProgressMonitor)monitor);
            this.migrateProject(DEFAULT_PROJECT_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void migrateProject(String projectName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectMigrationDataModelProvider());
        model.setProperty("IJavaProjectMigrationDataModelProperties.PROJECT_NAME", (Object)projectName);
        try {
            model.getDefaultOperation().execute(null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

