/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.tests.modulecore;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentType;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.ProjectComponents;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;

public class FlexibleProjectBuilderTest
extends TestCase {
    public static final String MODULE__RESOURCE_URI_PROTOCOL = "module:/resource/";
    private IProject project;
    private EMFWorkbenchContext emfContext;

    public FlexibleProjectBuilderTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new FlexibleProjectBuilderTest("testFlexibleProjectBuilderOutput"));
        return suite;
    }

    public void setUp() throws Exception {
        IWorkspaceDescription desc = ResourcesPlugin.getWorkspace().getDescription();
        desc.setAutoBuilding(false);
        ResourcesPlugin.getWorkspace().setDescription(desc);
        this.getProjectForWebModuleAndLocalWebLib().delete(true, null);
        this.getProjectForRemoteWebLib().delete(true, null);
        super.setUp();
    }

    public void testFlexibleProjectBuilderOutput() throws Exception {
        this.setupContent();
        this.checkForEmptyDeployables();
        this.buildProjects();
        this.checkForDeployablesOutput();
    }

    private void checkForDeployablesOutput() {
        try {
            IFolder lib;
            IFolder webInf;
            IFile manifest;
            IFolder metaFolder;
            IFolder[] localOutputFolders;
            IProject localWeb;
            IProject remoteWeb = this.getProjectForRemoteWebLib();
            IFolder[] remoteOutputFolders = StructureEdit.getOutputContainersForProject((IProject)remoteWeb);
            IFolder tempFolder = remoteWeb.getFolder(remoteOutputFolders[0].getName());
            if (!tempFolder.exists()) {
                FlexibleProjectBuilderTest.assertFalse((String)".deployables should exist, a build has been run", (boolean)true);
            }
            if (!tempFolder.getFolder(this.getRemoteWebLibraryDeployedName()).exists()) {
                FlexibleProjectBuilderTest.assertFalse((String)".deployables/RemoteWebLibProject.jar should exist, a build has been run", (boolean)true);
            }
            if (!(tempFolder = (localWeb = this.getProjectForWebModuleAndLocalWebLib()).getFolder((localOutputFolders = StructureEdit.getOutputContainersForProject((IProject)localWeb))[0].getName())).exists()) {
                FlexibleProjectBuilderTest.assertFalse((String)".deployables should exist, a build has been run", (boolean)true);
            }
            if (!(tempFolder = tempFolder.getFolder(this.getWebModuleDeployedName())).exists()) {
                FlexibleProjectBuilderTest.assertFalse((String)(String.valueOf(this.getWebModuleDeployedName()) + " should exist, a build has been run"), (boolean)true);
            }
            if (!(metaFolder = tempFolder.getFolder("META-INF")).exists()) {
                FlexibleProjectBuilderTest.assertFalse((String)(String.valueOf(this.getWebModuleDeployedName()) + "/META-INF should exist, a build has been run"), (boolean)true);
            }
            if (!(manifest = metaFolder.getFile("MANIFEST.MF")).exists()) {
                FlexibleProjectBuilderTest.assertFalse((String)(String.valueOf(this.getWebModuleDeployedName()) + "/META-INF/MANIFEST.MF should exist, a build has been run"), (boolean)true);
            }
            if (!(webInf = tempFolder.getFolder("WEB-INF")).exists()) {
                FlexibleProjectBuilderTest.assertFalse((String)(String.valueOf(this.getWebModuleDeployedName()) + "/WEB-INF should exist, a build has been run"), (boolean)true);
            }
            if (!webInf.getFolder("classes").exists()) {
                FlexibleProjectBuilderTest.assertFalse((String)(String.valueOf(this.getWebModuleDeployedName()) + "/WEB-INF/classes should exist, a build has been run"), (boolean)true);
            }
            if (!webInf.getFile("web.xml").exists()) {
                FlexibleProjectBuilderTest.assertFalse((String)(String.valueOf(this.getWebModuleDeployedName()) + "/WEB-INF/web.xml should exist, a build has been run"), (boolean)true);
            }
            if (!(lib = webInf.getFolder("lib")).getFile(this.getLocalWebLibraryDeployedName()).exists()) {
                FlexibleProjectBuilderTest.assertFalse((String)(String.valueOf(this.getWebModuleDeployedName()) + "/WEB-INF/lib/LocalWebLibrary.jar should exist, a build has been run"), (boolean)true);
            }
            if (!lib.getFile(this.getRemoteWebLibraryDeployedName()).exists()) {
                FlexibleProjectBuilderTest.assertFalse((String)(String.valueOf(this.getWebModuleDeployedName()) + "/WEB-INF/lib/RemoteWebLibProject.jar should exist, a build has been run"), (boolean)true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildProjects() {
        try {
            ResourcesPlugin.getWorkspace().build(6, null);
        }
        catch (Exception exception) {}
    }

    private void checkForEmptyDeployables() {
        try {
            IProject localWeb;
            IFolder[] localOutputFolders;
            IProject remoteWeb = this.getProjectForRemoteWebLib();
            IFolder[] remoteOutputFolders = StructureEdit.getOutputContainersForProject((IProject)remoteWeb);
            IFolder folder = remoteWeb.getFolder(remoteOutputFolders[0].getName());
            if (folder.exists()) {
                FlexibleProjectBuilderTest.assertFalse((String)".deployables should only exist if a build has been run", (boolean)true);
            }
            if ((folder = remoteWeb.getFolder((localOutputFolders = StructureEdit.getOutputContainersForProject((IProject)(localWeb = this.getProjectForWebModuleAndLocalWebLib())))[0].getName())).exists()) {
                FlexibleProjectBuilderTest.assertFalse((String)".deployables should only exist if a build has been run", (boolean)true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    public void setupContent() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 103->107)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IProject getProjectForWebModuleAndLocalWebLib() throws Exception {
        return this.getWebProject(this.getWebModuleAndLocalWebLibModuleProjectName());
    }

    public IProject getProjectForRemoteWebLib() throws Exception {
        return this.getJavaProject(this.getRemoteWebLibModuleProjectName());
    }

    public String getWebModuleAndLocalWebLibModuleProjectName() {
        return "MyModulesProject";
    }

    public String getRemoteWebLibModuleProjectName() {
        return "RemoteWebLibProject";
    }

    public IProject getWebProject(String aProjectName) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
        if (!project.exists()) {
            project = this.createWebProject(aProjectName);
        }
        return project;
    }

    public IProject getJavaProject(String aProjectName) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
        if (!project.exists()) {
            this.createJavaProject(aProjectName);
        }
        return project;
    }

    public IProject createWebProject(String aProjectName) throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
        if (!this.project.exists()) {
            IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentCreationDataModelProvider());
            dataModel.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)aProjectName);
            dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
    }

    /*
     * Exception decompiling
     */
    public IProject createJavaProject(String aProjectName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 280->283)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addResource(WorkbenchComponent aModule, IResource aSourceFile, String aDeployPath) {
        ComponentResource resource = ComponentcoreFactory.eINSTANCE.createComponentResource();
        resource.setSourcePath(aSourceFile.getFullPath());
        resource.setRuntimePath((IPath)new Path(aDeployPath));
        aModule.getResources().add((Object)resource);
    }

    public WorkbenchComponent addWorkbenchModule(ProjectComponents theModules, String aDeployedName, URI aHandle) {
        WorkbenchComponent module = ComponentcoreFactory.eINSTANCE.createWorkbenchComponent();
        module.setName(aDeployedName);
        theModules.getComponents().add((Object)module);
        return module;
    }

    public void addDependentModule(WorkbenchComponent aModule, IPath aDeployedPath, URI aHandle) {
        ReferencedComponent aClasspathDependentModule = ComponentcoreFactory.eINSTANCE.createReferencedComponent();
        aClasspathDependentModule.setRuntimePath(aDeployedPath);
        aClasspathDependentModule.setHandle(aHandle);
        aModule.getReferencedComponents().add((Object)aClasspathDependentModule);
    }

    public void createLocalModules(StructureEdit moduleCore) throws Exception {
        ProjectComponents projectModules = moduleCore.getComponentModelRoot();
        WorkbenchComponent webLibraryModule = this.addWorkbenchModule(projectModules, this.getLocalWebLibraryDeployedName(), this.getLocalWebLibraryModuleURI());
        IFolder localWebLibrary = this.getProjectForWebModuleAndLocalWebLib().getFolder(this.getLocalWebLibraryFolderName());
        if (!localWebLibrary.exists()) {
            localWebLibrary.create(true, true, null);
        }
        this.addResource(webLibraryModule, (IResource)localWebLibrary, "/");
        ComponentType webModuleType = ComponentcoreFactory.eINSTANCE.createComponentType();
        webModuleType.setComponentTypeId("jst.utility");
        webLibraryModule.setComponentType(webModuleType);
    }

    public URI getWebModuleURI() {
        return URI.createURI((String)(MODULE__RESOURCE_URI_PROTOCOL + this.getWebModuleAndLocalWebLibModuleProjectName() + '/' + this.getWebModuleDeployedName()));
    }

    public URI getLocalWebLibraryModuleURI() {
        return URI.createURI((String)(MODULE__RESOURCE_URI_PROTOCOL + this.getWebModuleAndLocalWebLibModuleProjectName() + '/' + this.getLocalWebLibraryDeployedName()));
    }

    public URI getRemoteWebLibraryModuleURI() {
        return URI.createURI((String)(MODULE__RESOURCE_URI_PROTOCOL + this.getRemoteWebLibModuleProjectName() + '/' + this.getRemoteWebLibraryDeployedName()));
    }

    public String getWebModuleDeployedName() {
        return String.valueOf(this.getWebModuleAndLocalWebLibModuleProjectName()) + ".war";
    }

    public String getLocalWebLibraryDeployedName() {
        return "LocalWebLibrary.jar";
    }

    public String getRemoteWebLibraryDeployedName() {
        return String.valueOf(this.getRemoteWebLibModuleProjectName()) + ".jar";
    }

    public String getModulesFolder() {
        return "MyWebModule";
    }

    public String getTestResourcePath() {
        return "WEB-INF/web.xml";
    }

    public String getLocalWebLibraryFolderName() {
        return "WebLibraryContents";
    }

    public static interface IModuleTypesConstants {
        public static final String MODULE_TYPE_WEB = "wst.web";
    }
}

