/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.ConfigurationConstants;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public abstract class ValidationConfiguration {
    private IResource _resource = null;
    private boolean _autoValidate = ValidationConfiguration.getAutoValidateDefault();
    private boolean _buildValidate = ValidationConfiguration.getBuildValidateDefault();
    private int _maxMessages = ValidationConfiguration.getMaximumNumberOfMessagesDefault();
    private String _version = null;
    private Map _validators = null;
    private boolean _runAsync = ValidationConfiguration.getAsyncDefault();

    public static String getEnabledElementsAsString(Set elements) {
        if (elements == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            buffer.append(((ValidatorMetaData)iterator.next()).getValidatorUniqueName());
            buffer.append(";");
        }
        return buffer.toString();
    }

    public static String getEnabledElementsAsString(Object[] elements) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            buffer.append(((ValidatorMetaData)elements[i]).getValidatorUniqueName());
            buffer.append(";");
            ++i;
        }
        return buffer.toString();
    }

    public static Set getStringAsEnabledElements(String elements) {
        if (elements == null) {
            return null;
        }
        HashSet<ValidatorMetaData> result = new HashSet<ValidatorMetaData>();
        StringTokenizer tokenizer = new StringTokenizer(elements, ";");
        while (tokenizer.hasMoreTokens()) {
            String elem = tokenizer.nextToken();
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(elem);
            if (vmd == null) continue;
            result.add(vmd);
        }
        return result;
    }

    public static ValidatorMetaData[] getStringAsEnabledElementsArray(String elements) {
        if (elements == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(elements, ";");
        ValidatorMetaData[] result = new ValidatorMetaData[tokenizer.countTokens()];
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            String elem = tokenizer.nextToken();
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(elem);
            if (vmd == null) continue;
            result[count++] = vmd;
        }
        if (count != result.length) {
            ValidatorMetaData[] trimResult = new ValidatorMetaData[count];
            System.arraycopy(result, 0, trimResult, 0, count);
            return trimResult;
        }
        return result;
    }

    public static IWorkspaceRoot getRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected ValidationConfiguration() throws InvocationTargetException {
        this._validators = new HashMap();
    }

    protected ValidationConfiguration(IResource resource, ValidatorMetaData[] validators) throws InvocationTargetException {
        this();
        if (resource == null) {
            throw new InvocationTargetException(null, ResourceHandler.getExternalizedMessage("VBF_EXC_NULLCREATE"));
        }
        this.setResource(resource);
        this.setValidators(validators);
    }

    private void setResource(IResource resource) {
        this._resource = resource;
    }

    public boolean isAutoValidate() throws InvocationTargetException {
        return this._autoValidate;
    }

    public void setAutoValidate(boolean auto) {
        this._autoValidate = auto;
    }

    public boolean isBuildValidate() throws InvocationTargetException {
        return this._buildValidate;
    }

    public void setBuildValidate(boolean build) {
        this._buildValidate = build;
    }

    public boolean runAsync() throws InvocationTargetException {
        return this._runAsync;
    }

    public void setAsync(boolean doRunInBackgroundThread) throws InvocationTargetException {
        this._runAsync = doRunInBackgroundThread;
    }

    public ValidatorMetaData[] getEnabledValidators() throws InvocationTargetException {
        return this.getValidators(true);
    }

    public ValidatorMetaData[] getEnabledIncrementalValidators(boolean incremental) throws InvocationTargetException {
        ValidatorMetaData[] temp = new ValidatorMetaData[this.numberOfValidators()];
        Iterator iterator = this.getValidatorMetaData().keySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            Boolean bvalue = (Boolean)this.getValidatorMetaData().get(vmd);
            if (!bvalue.booleanValue() || (!vmd.isIncremental() || !incremental) && (vmd.isIncremental() || incremental)) continue;
            temp[count++] = vmd;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public ValidatorMetaData[] getEnabledFullBuildValidators(boolean fullBuild) throws InvocationTargetException {
        return this.getEnabledFullBuildValidators(fullBuild, false);
    }

    public ValidatorMetaData[] getEnabledFullBuildValidators(boolean fullBuild, boolean onlyReferenced) throws InvocationTargetException {
        ValidatorMetaData[] temp = new ValidatorMetaData[this.numberOfValidators()];
        Iterator iterator = this.getValidatorMetaData().keySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            Boolean bvalue = (Boolean)this.getValidatorMetaData().get(vmd);
            if (!bvalue.booleanValue() || vmd == null || (!vmd.isFullBuild() || !fullBuild) && (vmd.isFullBuild() || fullBuild) || onlyReferenced && !vmd.isDependentValidator()) continue;
            temp[count++] = vmd;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public void setEnabledValidators(ValidatorMetaData[] vmds) {
        Map all = this.getValidatorMetaData();
        Iterator iterator = all.keySet().iterator();
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            all.put(vmd, Boolean.FALSE);
        }
        if (vmds == null || vmds.length == 0) {
            return;
        }
        int i = 0;
        while (i < vmds.length) {
            all.put(vmds[i], Boolean.TRUE);
            ++i;
        }
    }

    private Map getValidatorMetaData() {
        return this._validators;
    }

    public ValidatorMetaData[] getDisabledValidators() throws InvocationTargetException {
        return this.getValidators(false);
    }

    private ValidatorMetaData[] getValidators(boolean value) throws InvocationTargetException {
        ValidatorMetaData[] temp = new ValidatorMetaData[this.numberOfValidators()];
        Iterator iterator = this.getValidatorMetaData().keySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            Boolean bvalue = (Boolean)this.getValidatorMetaData().get(vmd);
            if (bvalue != value) continue;
            temp[count++] = vmd;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public ValidatorMetaData[] getIncrementalValidators() throws InvocationTargetException {
        ValidatorMetaData[] temp = new ValidatorMetaData[this.numberOfValidators()];
        Iterator iterator = this.getValidatorMetaData().keySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            Boolean bvalue = (Boolean)this.getValidatorMetaData().get(vmd);
            if (!bvalue.booleanValue() || !vmd.isIncremental()) continue;
            temp[count++] = vmd;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public ValidatorMetaData[] getValidators() throws InvocationTargetException {
        return ValidationConfiguration.convertToArray(this._validators.keySet());
    }

    public void setValidators(ValidatorMetaData[] vmds) {
        this._validators.clear();
        int i = 0;
        while (i < vmds.length) {
            if (vmds[i] != null) {
                this._validators.put(vmds[i], vmds[i].isEnabledByDefault() ? Boolean.TRUE : Boolean.FALSE);
            }
            ++i;
        }
    }

    public int numberOfValidators() throws InvocationTargetException {
        return this._validators.size();
    }

    public int numberOfEnabledIncrementalValidators() throws InvocationTargetException {
        return ValidationConfiguration.numberOfIncrementalValidators(this.getEnabledValidators());
    }

    public int numberOfIncrementalValidators() throws InvocationTargetException {
        return ValidationConfiguration.numberOfIncrementalValidators(this.getValidators());
    }

    private static int numberOfIncrementalValidators(ValidatorMetaData[] vmds) {
        int count = 0;
        int i = 0;
        while (i < vmds.length) {
            ValidatorMetaData vmd = vmds[i];
            if (vmd.isIncremental()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int numberOfEnabledValidators() throws InvocationTargetException {
        return this.getEnabledValidators().length;
    }

    public int numberOfDisabledValidators() throws InvocationTargetException {
        return this.getDisabledValidators().length;
    }

    public int getMaximumNumberOfMessages() throws InvocationTargetException {
        return this._maxMessages;
    }

    public void setMaximumNumberOfMessages(int max) {
        this._maxMessages = max;
    }

    public final String getVersion() throws InvocationTargetException {
        if (this._version == null) {
            this.loadVersion();
        }
        return this._version;
    }

    private void setVersion(String version) {
        this._version = version;
    }

    public void markVersionCurrent() {
        this.setVersion(ConfigurationConstants.CURRENT_VERSION);
    }

    public boolean isVersionCurrent() throws InvocationTargetException {
        return this.getVersion().equals(ConfigurationConstants.CURRENT_VERSION);
    }

    public IResource getResource() {
        return this._resource;
    }

    public boolean isEnabled(String validatorClassName) throws InvocationTargetException {
        if (validatorClassName == null) {
            return false;
        }
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorClassName);
        return this.isEnabled(vmd);
    }

    public boolean isEnabled(ValidatorMetaData vmd) throws InvocationTargetException {
        if (vmd == null) {
            return false;
        }
        Boolean value = (Boolean)this.getValidatorMetaData().get(vmd);
        if (value == null) {
            return false;
        }
        return value;
    }

    public final void passivate() throws InvocationTargetException {
        try {
            if (this.getResource() == null) {
                throw new InvocationTargetException(null, ResourceHandler.getExternalizedMessage("VBF_EXC_NULLSAVE"));
            }
            this.getResource().setSessionProperty(ConfigurationConstants.USER_PREFERENCE, (Object)this);
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_SAVE", new String[]{this.getResource().getName()}));
        }
    }

    public abstract void resetToDefault() throws InvocationTargetException;

    protected Boolean convertToBoolean(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Integer convertToInteger(int value) {
        return new Integer(value);
    }

    protected boolean convertToBoolean(String value) {
        Boolean b = Boolean.valueOf(value);
        return b;
    }

    protected int convertToInt(String value) {
        Integer t = Integer.valueOf(value);
        return t;
    }

    public static ValidatorMetaData[] convertToArray(Collection c) {
        int length = c == null ? 0 : c.size();
        ValidatorMetaData[] result = new ValidatorMetaData[length];
        if (length == 0) {
            return result;
        }
        Iterator iterator = c.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            result[count++] = vmd;
        }
        return result;
    }

    public static ValidatorMetaData[] convertToArray(Object[] c) {
        int length = c == null ? 0 : c.length;
        ValidatorMetaData[] result = new ValidatorMetaData[length];
        if (length == 0) {
            return result;
        }
        System.arraycopy(c, 0, result, 0, length);
        return result;
    }

    public void store() throws InvocationTargetException {
        if (this.getResource() == null) {
            throw new InvocationTargetException(null, ResourceHandler.getExternalizedMessage("VBF_EXC_NULLSAVE"));
        }
        try {
            this.getResource().setPersistentProperty(ConfigurationConstants.USER_PREFERENCE, this.serialize());
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_SAVE", new String[]{this.getResource().getName()}));
        }
    }

    protected final void loadVersion() throws InvocationTargetException {
        if (this.getResource() == null) {
            throw new InvocationTargetException(null, ResourceHandler.getExternalizedMessage("VBF_EXC_NULLRETRIEVE"));
        }
        IMarker[] marker = this.getMarker();
        String version = null;
        version = marker == null ? this.loadVersion(this.getResource()) : this.loadVersion(marker);
        this.setVersion(version);
    }

    protected final String loadVersion(IMarker[] marker) throws InvocationTargetException {
        String version = (String)this.getValue(marker[0], "version");
        if (version == null) {
            return "4.03";
        }
        return version;
    }

    protected final String loadVersion(IResource resource) throws InvocationTargetException {
        try {
            String storedConfiguration = resource.getPersistentProperty(ConfigurationConstants.USER_PREFERENCE);
            String version = null;
            if (storedConfiguration == null) {
                version = ValidationConfiguration.getVersionDefault();
            } else {
                int versionIndex = storedConfiguration.indexOf("version");
                if (versionIndex != -1) {
                    version = storedConfiguration.substring(versionIndex + "version".length());
                }
            }
            if (version == null) {
                return ValidationConfiguration.getVersionDefault();
            }
            return version;
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{this.getResource().getName()}));
        }
    }

    protected final void load() throws InvocationTargetException {
        try {
            if (this.getResource() == null) {
                throw new InvocationTargetException(null, ResourceHandler.getExternalizedMessage("VBF_EXC_NULLRETRIEVE"));
            }
            IMarker[] marker = this.getMarker();
            if (marker == null) {
                this.load(this.getResource());
            } else {
                this.load(marker);
            }
        }
        catch (InvocationTargetException exc) {
            throw exc;
        }
        catch (Throwable exc) {
            String resourceName = this.getResource() == null ? "null" : this.getResource().getName();
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{resourceName}));
        }
    }

    protected abstract IMarker[] getMarker();

    protected abstract void load(IMarker[] var1) throws InvocationTargetException;

    protected Object getValue(IMarker marker, String attribName) {
        if (marker == null) {
            return null;
        }
        try {
            return marker.getAttribute(attribName);
        }
        catch (CoreException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidationConfiguration::getValue(" + attribName + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return null;
        }
    }

    protected boolean getValue(IMarker marker, String attribName, boolean defaultValue) {
        Boolean bool = (Boolean)this.getValue(marker, attribName);
        if (bool == null) {
            return defaultValue;
        }
        return bool;
    }

    protected int getValue(IMarker marker, String attribName, int defaultValue) {
        Integer integer = (Integer)this.getValue(marker, attribName);
        if (integer == null) {
            return defaultValue;
        }
        return integer;
    }

    protected String getValue(IMarker marker, String attribName, String defaultValue) {
        String string = (String)this.getValue(marker, attribName);
        if (string == null) {
            return defaultValue;
        }
        return string;
    }

    protected final void load(IResource resource) throws InvocationTargetException {
        try {
            String storedConfiguration = resource.getPersistentProperty(ConfigurationConstants.USER_PREFERENCE);
            this.deserialize(storedConfiguration);
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{this.getResource().getName()}));
        }
    }

    protected void copyTo(ValidationConfiguration up) throws InvocationTargetException {
        up.setVersion(this.getVersion());
        up.setResource(this.getResource());
        up.setValidators(this.getValidators());
        up.setAutoValidate(this.isAutoValidate());
        up.setBuildValidate(this.isBuildValidate());
        up.setEnabledValidators(this.getEnabledValidators());
        up.setMaximumNumberOfMessages(this.getMaximumNumberOfMessages());
    }

    protected boolean hasEnabledValidatorsChanged(ValidatorMetaData[] oldEnabledVmd) throws InvocationTargetException {
        if (oldEnabledVmd == null) {
            return true;
        }
        int i = 0;
        while (i < oldEnabledVmd.length) {
            ValidatorMetaData vmd = oldEnabledVmd[i];
            if (!this.isEnabled(vmd)) {
                return true;
            }
            ++i;
        }
        return this.numberOfEnabledValidators() != oldEnabledVmd.length;
    }

    protected String serialize() throws InvocationTargetException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("autoValidate");
        buffer.append(String.valueOf(this.isAutoValidate()));
        buffer.append("runWhenBuild");
        buffer.append(String.valueOf(this.isBuildValidate()));
        buffer.append("maxNumMessages");
        buffer.append(String.valueOf(this.getMaximumNumberOfMessages()));
        buffer.append("runAsync");
        buffer.append(String.valueOf(this.runAsync()));
        buffer.append("enabledValidatorList");
        buffer.append(ValidationConfiguration.getEnabledElementsAsString(this.getEnabledValidators()));
        buffer.append("version");
        buffer.append(this.getVersion());
        return buffer.toString();
    }

    protected void deserialize(String storedConfiguration) throws InvocationTargetException {
        if (storedConfiguration == null || storedConfiguration.length() == 0) {
            this.resetToDefault();
            return;
        }
        int autoIndex = storedConfiguration.indexOf("autoValidate");
        int buildIndex = storedConfiguration.indexOf("runWhenBuild");
        int maxIndex = storedConfiguration.indexOf("maxNumMessages");
        int asyncIndex = storedConfiguration.indexOf("runAsync");
        int enabledIndex = storedConfiguration.indexOf("enabledValidatorList");
        int versionIndex = storedConfiguration.indexOf("version");
        String auto = storedConfiguration.substring(autoIndex + "autoValidate".length(), buildIndex);
        String build = storedConfiguration.substring(buildIndex + "runWhenBuild".length(), maxIndex);
        String max = storedConfiguration.substring(maxIndex + "maxNumMessages".length(), asyncIndex);
        String async = storedConfiguration.substring(asyncIndex + "runAsync".length(), enabledIndex);
        String enabled = storedConfiguration.substring(enabledIndex + "enabledValidatorList".length(), versionIndex);
        this.setAutoValidate(Boolean.valueOf(auto));
        this.setBuildValidate(Boolean.valueOf(build));
        this.setMaximumNumberOfMessages(Integer.valueOf(max));
        this.setAsync(Boolean.valueOf(async));
        this.setEnabledValidators(ValidationConfiguration.getStringAsEnabledElementsArray(enabled));
    }

    public static boolean getAutoValidateDefault() {
        return true;
    }

    public static boolean getBuildValidateDefault() {
        return true;
    }

    public static ValidatorMetaData[] getEnabledValidatorsDefault() {
        return ConfigurationConstants.DEFAULT_ENABLED_VALIDATORS;
    }

    public static int getMaximumNumberOfMessagesDefault() {
        return 50;
    }

    public static String getVersionDefault() {
        return ConfigurationConstants.CURRENT_VERSION;
    }

    public static boolean getAsyncDefault() {
        return true;
    }
}

