/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.tests.util.JUnitUtils;
import org.eclipse.wst.command.internal.env.context.PersistentResourceContext;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseEnvironment;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseProgressMonitor;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseStatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public abstract class WSWizardTest
extends TestCase {
    protected Environment env_;
    protected IRuntime serverRuntime_;
    protected IServer server_;
    protected IStructuredSelection initialSelection_;
    public String defaultURL_ = "http://localhost:8080/";

    protected void setUp() throws Exception {
        PersistentResourceContext resourceContext = PersistentResourceContext.getInstance();
        EclipseStatusHandler handler = new EclipseStatusHandler();
        EclipseProgressMonitor monitor = new EclipseProgressMonitor();
        EclipseEnvironment environment = new EclipseEnvironment(null, (ResourceContext)resourceContext, (ProgressMonitor)monitor, (StatusHandler)handler);
        this.env_ = environment;
        WSWizardTest.assertTrue((this.env_ != null ? 1 : 0) != 0);
        NullProgressMonitor npm = new NullProgressMonitor();
        monitor.setMonitor((IProgressMonitor)npm);
        this.server_ = null;
        JUnitUtils.hideActionDialogs();
        JUnitUtils.enableFlexProjectPreference();
        this.installServerRuntime();
        this.installServer();
        this.installInputData();
        this.initJ2EEWSRuntimeServerDefaults();
        this.initInitialSelection();
    }

    protected abstract void installServerRuntime() throws Exception;

    public void installInputData(Environment env, IRuntime serverRuntime, IServer server) throws Exception {
        this.env_ = env;
        this.serverRuntime_ = serverRuntime;
        this.server_ = server;
        this.installInputData();
    }

    protected abstract void installInputData() throws Exception;

    protected abstract void installServer() throws Exception;

    protected abstract void initJ2EEWSRuntimeServerDefaults() throws Exception;

    protected abstract void initInitialSelection() throws Exception;

    protected void tearDown() throws Exception {
        this.stopServer();
    }

    protected abstract void deleteInputData() throws Exception;

    protected void stopServer() throws Exception {
        if (this.server_ != null && this.server_.getServerState() == 2) {
            this.server_.stop(true);
        }
        WSWizardTest.assertTrue((this.server_.getServerState() == 4 ? 1 : 0) != 0);
    }

    protected void deleteServer() throws Exception {
        if (this.server_ != null) {
            this.server_.delete();
        }
    }

    protected void deleteServerRuntime() throws Exception {
        if (this.serverRuntime_ != null) {
            this.serverRuntime_.delete();
        }
    }

    protected String getDefaultURL(String path, String contextRoot) {
        StringBuffer url = new StringBuffer(this.defaultURL_);
        url.append(contextRoot);
        url.append('/');
        url.append(path);
        return url.toString();
    }
}

