/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests.unittest;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateModuleCommand;
import org.eclipse.jst.ws.tests.unittest.WSJUnitConstants;
import org.eclipse.jst.ws.tests.util.JUnitUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ComponentCreationTests
extends TestCase
implements WSJUnitConstants {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.ws.tests.unittest.ComponentCreationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testWebComponentCreation() {
        this.enableFlexProjectPreference();
        this.createServerRuntime();
        this.createWebModule("FlexProject", "webComponent", 14);
        this.createWebModule("FlexProject", "webComp2", 13);
        this.createWebModule("FlexProject2", "webComp3", 13);
        this.createWebModule("FlexProject2", "webComp4", 13);
    }

    public void enableFlexProjectPreference() {
        JUnitUtils.enableFlexProjectPreference();
    }

    public void createServerRuntime() {
        try {
            JUnitUtils.createServerRuntime("org.eclipse.jst.server.tomcat.runtime.50", SERVER_INSTALL_PATH);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createWebModule(String projectNm, String componentName, int j2eeVersion) {
        CreateModuleCommand cmc = new CreateModuleCommand();
        cmc.setJ2eeLevel(new Integer(j2eeVersion).toString());
        cmc.setModuleName(componentName);
        cmc.setModuleType(1);
        cmc.setProjectName(projectNm);
        cmc.setServerFactoryId("org.eclipse.jst.server.tomcat.50");
        cmc.execute(null);
        System.out.println("Done creating Web component..." + projectNm + "\"" + componentName);
        IProject p = ResourceUtils.getWorkspaceRoot().getProject(projectNm);
        IVirtualComponent vc = ComponentCore.createComponent((IProject)p, (String)componentName);
        ComponentCreationTests.assertTrue((boolean)vc.exists());
    }

    public void dtestCreateEJBModule() {
        CreateModuleCommand cmc = new CreateModuleCommand();
        cmc.setJ2eeLevel(new Integer(13).toString());
        cmc.setModuleName("ejbComponent");
        cmc.setModuleType(2);
        cmc.setProjectName("FlexEJBProject");
        cmc.setServerFactoryId("org.eclipse.jst.server.tomcat.50");
        cmc.execute(null);
        System.out.println("Done creating EJB component.");
        IProject p = ResourceUtils.getWorkspaceRoot().getProject("FlexEJBProject");
        IVirtualComponent vc = ComponentCore.createComponent((IProject)p, (String)"ejbComponent");
        ComponentCreationTests.assertTrue((boolean)vc.exists());
    }

    public void dtestCreateAppClientModule() {
        CreateModuleCommand cmc = new CreateModuleCommand();
        cmc.setJ2eeLevel(new Integer(13).toString());
        cmc.setModuleName("appClientComponent");
        cmc.setModuleType(4);
        cmc.setProjectName("FlexAppClientProject");
        cmc.setServerFactoryId("org.eclipse.jst.server.tomcat.50");
        cmc.execute(null);
        System.out.println("Done creating App client component.");
        IProject p = ResourceUtils.getWorkspaceRoot().getProject("FlexAppClientProject");
        IVirtualComponent vc = ComponentCore.createComponent((IProject)p, (String)"appClientComponent");
        ComponentCreationTests.assertTrue((boolean)vc.exists());
    }

    public void dtestCreateEARModule() {
        CreateModuleCommand cmc = new CreateModuleCommand();
        cmc.setJ2eeLevel(new Integer(13).toString());
        cmc.setModuleName("EARComponent");
        cmc.setModuleType(8);
        cmc.setProjectName("FlexProject");
        cmc.setServerFactoryId("org.eclipse.jst.server.tomcat.50");
        cmc.execute(null);
        System.out.println("Done creating EAR component.");
        IProject p = ResourceUtils.getWorkspaceRoot().getProject("FlexProject");
        IVirtualComponent vc = ComponentCore.createComponent((IProject)p, (String)"EARComponent");
        ComponentCreationTests.assertTrue((boolean)vc.exists());
    }
}

