/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorListener;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.provisional.MonitorCore;
import org.eclipse.wst.internet.monitor.core.tests.OrderedTestSuite;

public class MonitorListenerTestCase
extends TestCase {
    private static IMonitor monitor;
    protected static IMonitor addEvent;
    protected static IMonitor changeEvent;
    protected static IMonitor removeEvent;
    protected static int count;
    protected static IMonitorListener listener2;
    protected static IMonitorListener listener;
    static /* synthetic */ Class class$0;

    static {
        listener = new IMonitorListener(){

            public void monitorAdded(IMonitor monitor2) {
                addEvent = monitor2;
                ++count;
            }

            public void monitorChanged(IMonitor monitor2) {
                changeEvent = monitor2;
                ++count;
            }

            public void monitorRemoved(IMonitor monitor2) {
                removeEvent = monitor2;
                ++count;
            }
        };
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.internet.monitor.core.tests.MonitorListenerTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new OrderedTestSuite(clazz, "MonitorListenerTestCase");
    }

    public void test0AddListener() throws Exception {
        MonitorCore.addMonitorListener((IMonitorListener)listener);
    }

    public void test1AddListener() throws Exception {
        MonitorCore.addMonitorListener((IMonitorListener)listener);
    }

    public void test2AddListener() throws Exception {
        IMonitorWorkingCopy wc = MonitorCore.createMonitor();
        monitor = wc.save();
        MonitorListenerTestCase.assertTrue((addEvent == monitor ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((changeEvent == null ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((removeEvent == null ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((count == 1 ? 1 : 0) != 0);
        addEvent = null;
        count = 0;
    }

    public void test3ChangeListener() throws Exception {
        IMonitorWorkingCopy wc = monitor.createWorkingCopy();
        wc.setLocalPort(1);
        monitor = wc.save();
        MonitorListenerTestCase.assertTrue((addEvent == null ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((changeEvent == monitor ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((removeEvent == null ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((count == 1 ? 1 : 0) != 0);
        changeEvent = null;
        count = 0;
    }

    public void test4RemoveListener() throws Exception {
        monitor.delete();
        MonitorListenerTestCase.assertTrue((addEvent == null ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((changeEvent == null ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((removeEvent == monitor ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((count == 1 ? 1 : 0) != 0);
        removeEvent = null;
        count = 0;
    }

    public void test5RemoveListener() throws Exception {
        MonitorCore.removeMonitorListener((IMonitorListener)listener);
    }

    public void test6RemoveListener() throws Exception {
        MonitorCore.removeMonitorListener((IMonitorListener)listener);
    }

    public void test7CheckListener() throws Exception {
        listener2 = new IMonitorListener(){

            public void monitorAdded(IMonitor monitor2) {
            }

            public void monitorChanged(IMonitor monitor2) {
            }

            public void monitorRemoved(IMonitor monitor2) {
            }
        };
        listener2.monitorAdded(null);
        listener2.monitorChanged(null);
        listener2.monitorRemoved(null);
    }
}

