/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.classpath;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.componentcore.util.ComponentUtilities;
import org.eclipse.jst.common.frameworks.CommonFrameworksPlugin;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorations;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorationsManager;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IFlexibleProject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public abstract class FlexibleProjectContainer
implements IClasspathContainer {
    private static IWorkspace workspace = ResourcesPlugin.getWorkspace();
    private static ClasspathDecorationsManager decorations;
    protected final IPath path;
    protected final IJavaProject owner;
    protected final IProject project;
    protected final String component;
    private final IClasspathEntry[] cpentries;
    private final IPath[] watchlist;

    static {
        workspace.addResourceChangeListener((IResourceChangeListener)new Listener());
        decorations = new ClasspathDecorationsManager("org.eclipse.jst.common.frameworks");
    }

    public FlexibleProjectContainer(IPath path, IJavaProject owner, IProject project, String component, IPath[] paths, PathType[] types) {
        this.path = path;
        this.owner = owner;
        this.project = project;
        this.component = component;
        ArrayList<IClasspathEntry> cp = new ArrayList<IClasspathEntry>();
        ArrayList<IPath> w = new ArrayList<IPath>();
        if (!FlexibleProjectContainer.isFlexibleProject(this.project)) {
            this.cpentries = new IClasspathEntry[0];
            this.watchlist = new IPath[0];
            return;
        }
        this.path.toString();
        IFlexibleProject fp = ComponentCore.createFlexibleProject((IProject)this.project);
        IVirtualComponent vc = fp.getComponent(component);
        int i = 0;
        while (i < paths.length) {
            block11: {
                IVirtualFolder rootFolder = vc.getRootFolder();
                IVirtualFolder vf = rootFolder.getFolder(paths[i]);
                if (types[i] == PathType.LIB_DIRECTORY) {
                    IVirtualResource[] contents;
                    try {
                        contents = vf.members();
                    }
                    catch (CoreException e) {
                        CommonFrameworksPlugin.log((Exception)((Object)e));
                        break block11;
                    }
                    int j = 0;
                    while (j < contents.length) {
                        IResource r = contents[j].getUnderlyingResource();
                        IPath p = r.getFullPath();
                        File f = r.getLocation().toFile();
                        String fname = f.getName().toLowerCase();
                        if (f.isFile() && fname.endsWith(".jar")) {
                            cp.add(this.newLibraryEntry(p));
                        }
                        ++j;
                    }
                    IFolder[] folders = vf.getUnderlyingFolders();
                    int j2 = 0;
                    while (j2 < folders.length) {
                        w.add(folders[j2].getFullPath());
                        ++j2;
                    }
                } else {
                    IFolder[] uf = vf.getUnderlyingFolders();
                    int j = 0;
                    while (j < uf.length) {
                        IPath p = uf[j].getFullPath();
                        if (!this.isSourceDirectory(p)) {
                            cp.add(this.newLibraryEntry(p));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        w.add(this.project.getFullPath().append(".wtpmodules"));
        this.cpentries = new IClasspathEntry[cp.size()];
        cp.toArray(this.cpentries);
        this.watchlist = new IPath[w.size()];
        w.toArray(this.watchlist);
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.cpentries;
    }

    public boolean isOutOfDate(IResourceDelta delta) {
        int i = 0;
        while (i < this.watchlist.length) {
            if (delta != null && delta.findMember(this.watchlist[i]) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract void refresh();

    static ClasspathDecorationsManager getDecorationsManager() {
        return decorations;
    }

    private IClasspathEntry newLibraryEntry(IPath p) {
        IPath srcpath = null;
        IPath srcrootpath = null;
        IClasspathAttribute[] attrs = new IClasspathAttribute[]{};
        IAccessRule[] access = new IAccessRule[]{};
        ClasspathDecorations dec = decorations.getDecorations(this.getPath().toString(), p.toString());
        if (dec != null) {
            srcpath = dec.getSourceAttachmentPath();
            srcrootpath = dec.getSourceAttachmentRootPath();
            attrs = dec.getExtraAttributes();
        }
        return JavaCore.newLibraryEntry((IPath)p, (IPath)srcpath, (IPath)srcrootpath, (IAccessRule[])access, (IClasspathAttribute[])attrs, (boolean)false);
    }

    private boolean isSourceDirectory(IPath path) {
        try {
            IJavaProject jproject = JavaCore.create((IProject)this.project);
            IClasspathEntry[] cp = jproject.getRawClasspath();
            int i = 0;
            while (i < cp.length) {
                IClasspathEntry cpe = cp[i];
                if (cpe.getEntryKind() == 3 && cpe.getPath().equals((Object)path)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (JavaModelException e) {
            CommonFrameworksPlugin.log((Exception)((Object)e));
            return false;
        }
    }

    private static boolean isJavaProject(IProject pj) {
        try {
            return pj.getNature(ComponentUtilities.JAVA_NATURE) != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static boolean isFlexibleProject(IProject pj) {
        try {
            return pj.getNature("org.eclipse.wst.common.modulecore.ModuleCoreNature") != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected static final class PathType {
        private final String type;
        public static final PathType LIB_DIRECTORY = new PathType("lib");
        public static final PathType CLASSES_DIRECTORY = new PathType("classes");

        private PathType(String type) {
            this.type = type;
        }
    }

    private static class Listener
    implements IResourceChangeListener {
        Listener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            ArrayList<IClasspathContainer> containers = new ArrayList<IClasspathContainer>();
            IProject[] projects = workspace.getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                try {
                    if (FlexibleProjectContainer.isJavaProject(project)) {
                        IJavaProject jproj = JavaCore.create((IProject)project);
                        IClasspathEntry[] cpes = jproj.getRawClasspath();
                        int j = 0;
                        while (j < cpes.length) {
                            IClasspathContainer cont;
                            IClasspathEntry cpe = cpes[j];
                            if (cpe.getEntryKind() == 5 && (cont = JavaCore.getClasspathContainer((IPath)cpe.getPath(), (IJavaProject)jproj)) instanceof FlexibleProjectContainer) {
                                containers.add(cont);
                            }
                            ++j;
                        }
                    }
                }
                catch (JavaModelException e) {
                    CommonFrameworksPlugin.log((Exception)((Object)e));
                }
                ++i;
            }
            IResourceDelta delta = event.getDelta();
            int i2 = 0;
            int n = containers.size();
            while (i2 < n) {
                FlexibleProjectContainer c = (FlexibleProjectContainer)containers.get(i2);
                if (c.isOutOfDate(delta)) {
                    c.refresh();
                }
                ++i2;
            }
        }
    }
}

