/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.activities;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.internal.activities.WTPActivityBridgeHelper;

public class WTPActivityBridge {
    private static final String PLUGIN_ID = "org.eclipse.wst.common.frameworks";
    private static final String EXTENSION_POINT = "WTPActivityBridgeHelper";
    private static final String LISTENER_CLASS = "class";
    private static WTPActivityBridge INSTANCE = null;
    private WTPActivityBridgeHelper[] listeners;

    public static WTPActivityBridge getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WTPActivityBridge();
        }
        return INSTANCE;
    }

    private WTPActivityBridge() {
        this.loadExtensionPoints();
    }

    public void enableActivity(String activityID, boolean enabled) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].enableActivity(activityID, enabled);
            ++i;
        }
    }

    public Set getEnabledActivityIds() {
        int i = 0;
        if (i < this.listeners.length) {
            return this.listeners[i].getEnabledActivityIds();
        }
        return Collections.EMPTY_SET;
    }

    public void setEnabledActivityIds(Set activityIDs) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].setEnabledActivityIds(activityIDs);
            ++i;
        }
    }

    public Set getActivityIDsFromContribution(String localID, String pluginID) {
        int i = 0;
        if (i < this.listeners.length) {
            return this.listeners[i].getActivityIDsFromContribution(localID, pluginID);
        }
        return Collections.EMPTY_SET;
    }

    private void loadExtensionPoints() {
        IExtensionPoint point = Platform.getPluginRegistry().getExtensionPoint(PLUGIN_ID, EXTENSION_POINT);
        if (point == null) {
            return;
        }
        IConfigurationElement[] elements = point.getConfigurationElements();
        this.listeners = new WTPActivityBridgeHelper[elements.length];
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getAttribute(LISTENER_CLASS) == null) {
                WTPActivityBridge.logError(elements[i], "No class defined.");
            }
            try {
                this.listeners[i] = (WTPActivityBridgeHelper)elements[i].createExecutableExtension(LISTENER_CLASS);
            }
            catch (CoreException e) {
                WTPActivityBridge.logError(elements[i], "Error loading class:" + elements[i].getAttribute(LISTENER_CLASS));
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        IPluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + descriptor.getUniqueIdentifier() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        Logger.getLogger().logError(buf.toString());
    }
}

