/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.BaseNodeAction;
import org.eclipse.wst.wsdl.ui.internal.actions.DeleteNodeAction;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeleteAction
extends BaseNodeAction {
    protected List list;
    protected String deleteString = String.valueOf(WSDLEditorPlugin.getWSDLString("_UI_ACTION_DELETE")) + " ";

    public DeleteAction(Object object, Node node) {
        this.setText(WSDLEditorPlugin.getWSDLString("_UI_ACTION_DELETE"));
        this.list = new Vector();
        this.list.add(object);
    }

    public DeleteAction(List deleteList) {
        this.setText(WSDLEditorPlugin.getWSDLString("_UI_ACTION_DELETE"));
        this.list = deleteList;
    }

    private Vector getReferencedMessages(Operation operation) {
        Vector<Message> messages = new Vector<Message>();
        messages.addAll(this.getMessages((List)operation.getEFaults()));
        if (operation.getEInput() != null && operation.getEInput().getEMessage() != null) {
            messages.addElement(operation.getEInput().getEMessage());
        }
        if (operation.getEOutput() != null && operation.getEOutput().getEMessage() != null) {
            messages.addElement(operation.getEOutput().getEMessage());
        }
        return messages;
    }

    public void run() {
        ArrayList sortedList = new ArrayList(this.list.size());
        Iterator listIterator = this.list.iterator();
        while (listIterator.hasNext()) {
            Object unsortedObject = listIterator.next();
            if (unsortedObject instanceof Operation) {
                sortedList.add(0, unsortedObject);
                continue;
            }
            sortedList.add(unsortedObject);
        }
        Element recordingNode = null;
        if (sortedList.size() > 1) {
            recordingNode = this.getElement(sortedList.get(0));
            this.beginRecording(recordingNode, WSDLEditorPlugin.getWSDLString("_UI_ACTION_MULTIPLE_DELETE"));
        }
        Iterator iterator = sortedList.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof Operation) {
                this.deleteOperation((Operation)object);
                continue;
            }
            if (object instanceof Part) {
                this.deletePart((Part)object);
                continue;
            }
            DeleteNodeAction deleteNodeAction = new DeleteNodeAction(this.getElement(object));
            deleteNodeAction.run();
        }
        if (recordingNode != null) {
            this.endRecording(recordingNode);
        }
    }

    private Vector getMessages(List faults) {
        Vector<Message> v = new Vector<Message>();
        Iterator it = faults.iterator();
        while (it.hasNext()) {
            Fault fault = (Fault)it.next();
            if (fault.getEMessage() == null) continue;
            v.addElement(fault.getEMessage());
        }
        return v;
    }

    private Vector getParts(Vector messages) {
        Vector parts = new Vector();
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            Message message = (Message)it.next();
            if (message.getEParts() == null) continue;
            parts.addAll(message.getEParts());
        }
        return parts;
    }

    public Node getNode() {
        return this.list.size() > 0 ? this.getElement(this.list.get(0)) : null;
    }

    public String getUndoDescription() {
        return WSDLEditorPlugin.getWSDLString("_UI_ACTION_DELETE");
    }

    private void deleteOperation(Operation operation) {
        DeleteOperationDialog dialog = new DeleteOperationDialog(WSDLEditorPlugin.getShell(), operation.getName());
        int returnCode = dialog.createAndOpen();
        if (returnCode == 0) {
            if (dialog.deleteMessagesAndParts()) {
                Vector messages = this.getReferencedMessages(operation);
                Vector referencedMessages = new Vector();
                if (operation.getEnclosingDefinition().getEPortTypes() != null) {
                    Iterator portTypeIterator = operation.getEnclosingDefinition().getEPortTypes().iterator();
                    Vector<Operation> operations = new Vector<Operation>();
                    while (portTypeIterator.hasNext()) {
                        PortType portType = (PortType)portTypeIterator.next();
                        if (portType.getEOperations() == null) continue;
                        Iterator operationIterator = portType.getEOperations().iterator();
                        while (operationIterator.hasNext()) {
                            Operation nextOperation = (Operation)operationIterator.next();
                            if (nextOperation.equals(operation)) continue;
                            operations.add(nextOperation);
                        }
                    }
                    int index = 0;
                    while (index < operations.size()) {
                        referencedMessages.addAll(this.getReferencedMessages((Operation)operations.elementAt(index)));
                        ++index;
                    }
                    index = 0;
                    while (index < messages.size()) {
                        int foundIndex = referencedMessages.indexOf(messages.elementAt(index));
                        if (foundIndex != -1) {
                            messages.remove(index);
                        }
                        ++index;
                    }
                }
                Vector parts = this.getParts(messages);
                PortType portType = (PortType)operation.eContainer();
                Element recordingNode = portType.getEnclosingDefinition().getElement();
                this.beginRecording(recordingNode, String.valueOf(this.deleteString) + WSDLEditorPlugin.getWSDLString("_UI_LABEL_OPERATION"));
                int index = 0;
                while (index < messages.size()) {
                    Message message = (Message)messages.elementAt(index);
                    Definition definition = (Definition)message.eContainer();
                    definition.getEMessages().remove((Object)message);
                    ++index;
                }
                index = 0;
                while (index < parts.size()) {
                    Part part = (Part)parts.elementAt(index);
                    Message message = (Message)part.eContainer();
                    message.getEParts().remove((Object)part);
                    ++index;
                }
                portType.getEOperations().remove((Object)operation);
                this.endRecording(recordingNode);
            } else {
                PortType portType = (PortType)operation.eContainer();
                Element recordingNode = portType.getElement();
                this.beginRecording(recordingNode, String.valueOf(this.deleteString) + WSDLEditorPlugin.getWSDLString("_UI_LABEL_OPERATION"));
                portType.getEOperations().remove((Object)operation);
                this.endRecording(recordingNode);
            }
        }
    }

    private void deletePart(Part part) {
        Message message = (Message)part.eContainer();
        if (message != null) {
            this.beginRecording(message.getElement(), String.valueOf(this.deleteString) + WSDLEditorPlugin.getWSDLString("_UI_LABEL_PART"));
            message.getEParts().remove((Object)part);
            this.endRecording(message.getElement());
        }
    }

    private Element getElement(Object object) {
        Element element = null;
        if (object instanceof WSDLElement) {
            element = ((WSDLElement)object).getElement();
        } else if (object instanceof XSDSchema) {
            element = ((XSDSchema)object).getElement();
        }
        return element;
    }

    private void beginRecording(Node node, String undoDescription) {
        if (node instanceof IDOMNode) {
            ((IDOMNode)node).getModel().beginRecording((Object)this, undoDescription);
        }
    }

    public void endRecording(Node node) {
        if (node instanceof IDOMNode) {
            ((IDOMNode)node).getModel().endRecording((Object)this);
        }
    }

    private class DeleteOperationDialog
    extends Dialog
    implements SelectionListener {
        private Button checkButton = null;
        private boolean deleteMessagesAndParts = true;
        private String operationName;

        public DeleteOperationDialog(Shell shell, String name) {
            super(shell);
            this.operationName = name;
        }

        protected Control createDialogArea(Composite parent) {
            Composite dialogArea = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(dialogArea, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            composite.setLayout((Layout)layout);
            GridData gdFill = new GridData();
            gdFill.horizontalAlignment = 4;
            gdFill.grabExcessHorizontalSpace = true;
            gdFill.verticalAlignment = 4;
            gdFill.grabExcessVerticalSpace = true;
            composite.setLayoutData((Object)gdFill);
            Label label = new Label(composite, 0);
            label.setText(this.operationName);
            GridData labelData = new GridData();
            labelData.horizontalSpan = 2;
            label.setLayoutData((Object)labelData);
            Label emptyLabel = new Label(composite, 0);
            GridData emptyData = new GridData();
            emptyData.horizontalSpan = 2;
            emptyLabel.setLayoutData((Object)emptyData);
            this.checkButton = new Button(composite, 32);
            this.checkButton.setSelection(this.deleteMessagesAndParts);
            this.checkButton.addSelectionListener((SelectionListener)this);
            Label nameLabel = new Label(composite, 0);
            nameLabel.setText(WSDLEditorPlugin.getWSDLString("_UI_DELETE_ASSOCIATED_MSG_AND_PARTS"));
            return dialogArea;
        }

        public boolean deleteMessagesAndParts() {
            return this.deleteMessagesAndParts;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.checkButton) {
                this.deleteMessagesAndParts = this.checkButton.getSelection();
            }
        }

        public int createAndOpen() {
            this.create();
            this.getShell().setText(WSDLEditorPlugin.getWSDLString("_UI_DELETE_OPERATION_TITLE"));
            this.setBlockOnOpen(true);
            return this.open();
        }
    }
}

