/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph.editpolicies;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.actions.CopyWSDLElementAction;
import org.eclipse.wst.wsdl.ui.internal.actions.WSDLDragAction;
import org.eclipse.wst.wsdl.ui.internal.actions.WSDLDragReorderAction;
import org.eclipse.wst.wsdl.ui.internal.actions.WSDLDragSetMessageAction;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.WSDLTreeNodeEditPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class WSDLDragAndDropCommand
extends Command {
    protected EditPartViewer viewer;
    protected ChangeBoundsRequest request;
    protected Point location;
    protected WSDLDragAction dragAction;
    protected boolean canExecute = false;

    public WSDLDragAndDropCommand(EditPartViewer viewer, ChangeBoundsRequest request) {
        WSDLElement wsdlElement;
        this.viewer = viewer;
        this.request = request;
        this.location = request.getLocation();
        EditPart targetEditPart = viewer.findObjectAt(this.location);
        if (targetEditPart instanceof WSDLTreeNodeEditPart && (wsdlElement = (WSDLElement)targetEditPart.getModel()).getElement() instanceof IDOMNode) {
            WSDLTreeNodeEditPart movingChildEditPart;
            List list;
            ((GraphicalEditPart)viewer.getRootEditPart()).getFigure().translateToRelative((Translatable)this.location);
            Vector<WSDLDragAction> dragActions = new Vector<WSDLDragAction>();
            if (request.getType().equals("add children")) {
                list = request.getEditParts();
                if (list.size() <= 0) {
                    this.canExecute = false;
                    return;
                }
                movingChildEditPart = (WSDLTreeNodeEditPart)list.get(0);
                Object model = movingChildEditPart.getModel();
                EditPart pointerEditPart = viewer.findObjectAt(this.location);
                if (model instanceof Input || model instanceof Output) {
                    dragActions.add(new WSDLDragReorderAction(movingChildEditPart, pointerEditPart, this.getPointerLocation(this.location)));
                    dragActions.add(new WSDLDragSetMessageAction(movingChildEditPart, pointerEditPart, this.location));
                } else if (model instanceof Part) {
                    dragActions.add(new WSDLDragReorderAction(movingChildEditPart, pointerEditPart, this.getPointerLocation(this.location)));
                } else if (model instanceof Fault) {
                    dragActions.add(new WSDLDragSetMessageAction(movingChildEditPart, pointerEditPart, this.location));
                }
            } else if (request.getType().equals("clone") && (list = request.getEditParts()).size() > 0) {
                movingChildEditPart = (WSDLTreeNodeEditPart)list.get(0);
                dragActions.add(new CopyWSDLElementAction(viewer, (WSDLElement)movingChildEditPart.getModel(), (WSDLElement)targetEditPart.getModel(), null));
            }
            Iterator it = dragActions.iterator();
            while (it.hasNext()) {
                this.dragAction = (WSDLDragAction)((Object)it.next());
                this.canExecute = this.dragAction.canExecute();
                if (this.canExecute) break;
            }
        }
    }

    public boolean canExecute() {
        return this.canExecute;
    }

    public void execute() {
        if (this.canExecute) {
            this.dragAction.run();
        }
    }

    public IFigure getFeedbackFigure() {
        if (this.dragAction != null) {
            return this.dragAction.getFeedbackFigure();
        }
        return null;
    }

    private Point getPointerLocation(Point origPointerLocation) {
        Point compensatedLocation = origPointerLocation;
        FigureCanvas figureCanvas = (FigureCanvas)this.viewer.getControl();
        int yOffset = figureCanvas.getViewport().getVerticalRangeModel().getValue();
        compensatedLocation.y += yOffset;
        return compensatedLocation;
    }
}

