/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.properties.section;

import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.ui.properties.internal.provisional.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetPage;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLSelectionManager;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapter;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapterListener;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLTabbedPropertySheetPage
extends TabbedPropertySheetPage
implements ISelectionChangedListener,
INodeSelectionListener,
ModelAdapterListener {
    private WSDLSelectionManager fViewerSelectionManager;
    private WSDLEditor wsdlEditor;
    private Object currentObject;

    public WSDLTabbedPropertySheetPage(ITabbedPropertySheetPageContributor tabbedPropertySheetPageContributor, WSDLEditor editor) {
        super(tabbedPropertySheetPageContributor);
        this.wsdlEditor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.wsdlEditor.getSelectionManager().setSelection((ISelection)new StructuredSelection((Object)this.wsdlEditor.getDefinition()));
    }

    public void setSelectionManager(WSDLSelectionManager viewerSelectionManager) {
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.removeSelectionChangedListener(this);
        }
        this.fViewerSelectionManager = viewerSelectionManager;
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.addSelectionChangedListener(this);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!event.getSelection().isEmpty()) {
            this.selectionChanged(this.getSite().getWorkbenchWindow().getActivePage().getActivePart(), event.getSelection());
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection != null) {
            if (selection instanceof StructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                if (structuredSelection.isEmpty()) {
                    return;
                }
                Object obj = structuredSelection.getFirstElement();
                Node node = WSDLEditorUtil.getInstance().getNodeForObject(obj);
                Object o = WSDLEditorUtil.getInstance().findModelObjectForElement(this.wsdlEditor.getDefinition(), (Element)node);
                if (o instanceof XSDSchemaExtensibilityElement) {
                    obj = ((XSDSchemaExtensibilityElement)o).getSchema();
                    selection = new StructuredSelection(obj);
                }
                this.attachListener(o);
            } else if (selection instanceof TextSelection) {
                return;
            }
        }
        super.selectionChanged((IWorkbenchPart)this.wsdlEditor.getEditorPart(), selection);
    }

    protected void attachListener(Object object) {
        WSDLModelAdapterFactory adapterFactory = WSDLModelAdapterFactory.getWSDLModelAdapterFactory();
        ModelAdapter adapter = adapterFactory.getAdapter(object);
        if (adapter != null) {
            this.removeListener(this.currentObject);
            adapter.addListener(this);
            this.currentObject = object;
        }
    }

    protected void removeListener(Object object) {
        WSDLModelAdapterFactory adapterFactory = WSDLModelAdapterFactory.getWSDLModelAdapterFactory();
        ModelAdapter adapter = adapterFactory.getAdapter(object);
        if (adapter != null) {
            adapter.removeListener(this);
            this.currentObject = null;
        }
    }

    public void dispose() {
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.removeSelectionChangedListener(this);
        }
        if (this.currentObject != null) {
            this.removeListener(this.currentObject);
        }
        super.dispose();
    }

    public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
    }

    public void propertyChanged(Object object, String property) {
        if (this.getCurrentTab() != null) {
            this.refresh();
        }
    }
}

