/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.reconciler;

import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.extension.INodeReconciler;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtension;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtensionRegistry;
import org.w3c.dom.Element;

public class ExtensibleNodeReconciler {
    protected WSDLEditorExtension[] extensions;
    protected INodeReconciler[] reconcilers;

    public ExtensibleNodeReconciler() {
        WSDLEditorExtensionRegistry registry = WSDLEditorPlugin.getInstance().getWSDLEditorExtensionRegistry();
        this.extensions = registry.getRegisteredExtensions(7);
        this.reconcilers = new INodeReconciler[this.extensions.length];
        int i = 0;
        while (i < this.extensions.length) {
            this.reconcilers[i] = (INodeReconciler)this.extensions[i].createExtensionObject(7, null);
            ++i;
        }
    }

    protected INodeReconciler getApplicableNodeReconciler(Object object) {
        INodeReconciler reconciler = null;
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].isApplicable(object) && (reconciler = this.reconcilers[i]) != null) break;
            ++i;
        }
        return reconciler;
    }

    public void notifyChanged(Object modelObject, Element element, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        INodeReconciler reconciler = this.getApplicableNodeReconciler(modelObject);
        if (reconciler != null) {
            reconciler.notifyChanged(modelObject, element, eventType, feature, oldValue, newValue, index);
        }
    }
}

