/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.viewers;

import java.util.HashMap;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.PageBook;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLGroupObject;
import org.eclipse.wst.wsdl.ui.internal.viewers.EmptyViewer;
import org.eclipse.wst.wsdl.ui.internal.viewers.ExtensibleDetailsViewerProvider;
import org.eclipse.wst.wsdl.ui.internal.viewers.OperationViewer;
import org.eclipse.xsd.XSDSchema;

public class WSDLDetailsViewer
implements ISelectionChangedListener {
    protected WSDLEditor editor;
    protected Composite client;
    protected PageBook pageBook;
    protected ExtensibleDetailsViewerProvider detailsViewerProvider;
    protected HashMap viewerMap = new HashMap();
    protected static final String EMPTY_VIEWER_KEY = "EMPTY_VIEWER_KEY";
    protected Viewer emptyViewer;

    public WSDLDetailsViewer(WSDLEditor editor) {
        this.editor = editor;
        this.detailsViewerProvider = new ExtensibleDetailsViewerProvider(editor);
        editor.getSelectionManager().addSelectionChangedListener(this);
    }

    public Control createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.client = this.pageBook;
        this.pageBook.setLayoutData((Object)new GridData(1808));
        this.emptyViewer = new EmptyViewer((Composite)this.pageBook, 0);
        this.viewerMap.put(EMPTY_VIEWER_KEY, this.emptyViewer);
        this.pageBook.showPage(this.emptyViewer.getControl());
        return this.client;
    }

    public void setInput(Object object) {
        try {
            Viewer viewer;
            Object key = this.detailsViewerProvider.getViewerKey(object);
            if (key == null) {
                key = EMPTY_VIEWER_KEY;
            }
            if ((viewer = (Viewer)this.viewerMap.get(key)) == null && (viewer = this.detailsViewerProvider.createViewer(object, (Composite)this.pageBook, (IEditorPart)this.editor)) != null) {
                this.viewerMap.put(key, viewer);
                boolean cfr_ignored_0 = viewer instanceof OperationViewer;
            }
            if (viewer != null) {
                if (object instanceof XSDSchemaExtensibilityElement) {
                    XSDSchemaExtensibilityElement schema = (XSDSchemaExtensibilityElement)object;
                    XSDSchema xsdSchema = schema.getSchema();
                    if (xsdSchema != null) {
                        viewer.setInput((Object)xsdSchema.getElement());
                    }
                } else {
                    viewer.setInput(object);
                }
                this.pageBook.showPage(viewer.getControl());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object o = ((IStructuredSelection)selection).getFirstElement();
            if (o instanceof WSDLGroupObject) {
                o = ((WSDLGroupObject)o).getDefinition();
            }
            this.setInput(o);
        }
    }
}

