/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementIdentifier;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementIdentifierEvent;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementManager;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementIdentifier;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementIdentifierListener;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementManager;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchEditResourceHandler;
import org.eclipse.wst.common.internal.emfworkbench.edit.AdapterFactoryDescriptor;
import org.eclipse.wst.common.internal.emfworkbench.edit.AdapterFactoryRegistry;
import org.eclipse.wst.common.internal.emfworkbench.edit.ExtendedComposedAdapterFactory;

public class DynamicAdapterFactory
implements AdapterFactory,
IChangeNotifier,
IDisposable,
INotifyChangedListener,
IEnablementIdentifierListener {
    private static final AdapterFactory NULL_FACTORY = new AdapterFactoryImpl();
    private ResourceItemProviderAdapterFactory resourceItemProviderAdapterFactory = null;
    private String viewID;
    private Map adapterFactoriesByPackage;
    private Map adapterFactoriesByType;
    private Set allFactories;
    protected ChangeNotifier changeNotifier = new ChangeNotifier();
    private boolean respectingActivities = false;
    protected static final Object NO_PROJECT = "NO_PROJECT";
    private Set enablementIdentifiers;

    public DynamicAdapterFactory(String viewID, boolean respectActivies) {
        this.viewID = viewID;
        this.respectingActivities = respectActivies;
        this.initialize();
    }

    public DynamicAdapterFactory(String viewID) {
        this.viewID = viewID;
        this.initialize();
    }

    private void initialize() {
        this.adapterFactoriesByPackage = new HashMap();
        this.adapterFactoriesByType = new HashMap();
        this.allFactories = new HashSet();
    }

    public boolean isFactoryForType(Object type) {
        return this.getFactoryForType(type) != null;
    }

    private AdapterFactory getFactoryForType(Object type) {
        AdapterFactory factory;
        if (type == null) {
            return null;
        }
        if (type instanceof EObject) {
            return this.getFactoryForType((EObject)type);
        }
        Object aProject = ProjectUtilities.getProject((Object)type);
        if (aProject == null) {
            aProject = NO_PROJECT;
        }
        if ((factory = this.getExistingFactoryForType(aProject, type)) == NULL_FACTORY) {
            return null;
        }
        if (factory == null) {
            factory = this.findFactoryForType(aProject, type);
            if (factory == null) {
                this.addAdapterFactory(aProject, type, NULL_FACTORY);
            } else {
                this.addAdapterFactory(aProject, type, factory);
            }
        }
        return factory;
    }

    private AdapterFactory getExistingFactoryForType(Object p, Object type) {
        if (p == null) {
            return null;
        }
        Map aMap = (Map)this.adapterFactoriesByType.get(p);
        if (aMap == null) {
            return null;
        }
        return (AdapterFactory)this.adapterFactoriesByType.get(type);
    }

    private AdapterFactory findFactoryForType(Object project, Object type) {
        if (project == null) {
            return null;
        }
        Map aMap = (Map)this.adapterFactoriesByPackage.get(project);
        if (aMap == null) {
            return null;
        }
        Iterator iter = aMap.values().iterator();
        AdapterFactory factory = null;
        while (iter.hasNext()) {
            factory = (AdapterFactory)iter.next();
            if (!factory.isFactoryForType(type)) continue;
            return factory;
        }
        if (this.getResourceItemProviderAdapterFactory().isFactoryForType(type)) {
            return this.getResourceItemProviderAdapterFactory();
        }
        return null;
    }

    private AdapterFactory getFactoryForType(EObject obj) {
        AdapterFactory result;
        EClass eClass = obj.eClass();
        if (eClass == null) {
            return null;
        }
        EPackage ePackage = eClass.getEPackage();
        Object aProject = ProjectUtilities.getProject((EObject)obj);
        if (aProject == null) {
            aProject = NO_PROJECT;
        }
        if ((result = this.getFactoryForPackage(aProject, ePackage)) == null) {
            HashSet<EPackage> failedPackageSet = new HashSet<EPackage>();
            failedPackageSet.add(ePackage);
            Iterator supertypes = eClass.getEAllSuperTypes().iterator();
            while (supertypes.hasNext()) {
                eClass = (EClass)supertypes.next();
                if (eClass != null && failedPackageSet.add(ePackage = eClass.getEPackage()) && (result = this.getFactoryForPackage(aProject, ePackage)) != null) break;
            }
        }
        return result;
    }

    private AdapterFactory getFactoryForPackage(Object aProject, EPackage aPackage) {
        if (aProject == null || aPackage == null) {
            return null;
        }
        AdapterFactory factory = this.getExistingFactoryForPackage(aProject, aPackage);
        if (factory == NULL_FACTORY) {
            return null;
        }
        if (factory == null) {
            try {
                factory = this.createAdapterFactory(aProject, aPackage);
                if (factory == null) {
                    this.addAdapterFactory(aProject, aPackage, NULL_FACTORY);
                } else {
                    this.addAdapterFactory(aProject, aPackage, factory);
                }
            }
            catch (RuntimeException re) {
                Logger.getLogger().logError((Throwable)re);
            }
        }
        return factory;
    }

    private AdapterFactory getFactoryForTypes(Object p, List types) {
        Map aMap = (Map)this.adapterFactoriesByPackage.get(p);
        if (aMap == null) {
            return this.adaptResourceTypes(types);
        }
        Iterator factories = aMap.values().iterator();
        AdapterFactory factory = null;
        while (factories.hasNext()) {
            factory = (AdapterFactory)factories.next();
            if (!this.isFactoryForAllTypes(factory, types)) continue;
            return factory;
        }
        return null;
    }

    private AdapterFactory adaptResourceTypes(List types) {
        if (this.isFactoryForAllTypes((AdapterFactory)this.getResourceItemProviderAdapterFactory(), types)) {
            return this.getResourceItemProviderAdapterFactory();
        }
        return null;
    }

    private void removeFactoryForTypes(Object p, List types) {
        Map aMap = (Map)this.adapterFactoriesByPackage.get(p);
        if (aMap == null) {
            return;
        }
        Iterator factories = aMap.values().iterator();
        AdapterFactory factory = null;
        while (factories.hasNext()) {
            factory = (AdapterFactory)factories.next();
            if (!this.isFactoryForAllTypes(factory, types)) continue;
            aMap.remove(factory);
        }
    }

    private boolean isFactoryForAllTypes(AdapterFactory factory, List types) {
        int i = 0;
        while (i < types.size()) {
            if (!factory.isFactoryForType(types.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private AdapterFactory getExistingFactoryForPackage(Object p, EPackage aPackage) {
        if (p == null) {
            return null;
        }
        Map aMap = (Map)this.adapterFactoriesByPackage.get(p);
        if (aMap == null) {
            return null;
        }
        return (AdapterFactory)aMap.get(aPackage);
    }

    private void addAdapterFactory(Object p, EPackage aPackage, AdapterFactory adapterFactory) {
        Map aMap = this.getOrCreateMap(p, this.adapterFactoriesByPackage);
        aMap.put(aPackage, adapterFactory);
        if (adapterFactory == NULL_FACTORY) {
            return;
        }
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
        this.allFactories.add(adapterFactory);
    }

    private Map getOrCreateMap(Object p, Map container) {
        HashMap aMap = (HashMap)container.get(p);
        if (aMap == null) {
            aMap = new HashMap(10);
            container.put(p, aMap);
        }
        return aMap;
    }

    private void addAdapterFactory(Object p, Object type, AdapterFactory adapterFactory) {
        Map aMap = this.getOrCreateMap(p, this.adapterFactoriesByType);
        aMap.put(type, adapterFactory);
        if (adapterFactory == NULL_FACTORY) {
            return;
        }
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
        this.allFactories.add(adapterFactory);
    }

    public Object adapt(Object target, Object type) {
        Object adapter = target;
        if (target instanceof Notifier) {
            adapter = this.adapt((Notifier)target, type);
        }
        if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
            return adapter;
        }
        return null;
    }

    public Adapter adapt(Notifier target, Object type) {
        Adapter result = null;
        if (target instanceof EObject) {
            result = this.adapt((EObject)target, type);
        } else {
            Object p = ProjectUtilities.getProject((Object)target);
            if (p == null) {
                p = NO_PROJECT;
            }
            result = this.adapt(p, target, type, new HashSet(), target.getClass());
        }
        return result;
    }

    public Adapter adapt(EObject target, Object type) {
        EClass eClass = target.eClass();
        if (eClass == null) {
            return null;
        }
        EPackage ePackage = eClass.getEPackage();
        Adapter result = this.adapt(target, ePackage, type);
        if (result == null) {
            HashSet<EPackage> failedPackageSet = new HashSet<EPackage>();
            failedPackageSet.add(ePackage);
            Iterator supertypes = eClass.getEAllSuperTypes().iterator();
            while (supertypes.hasNext()) {
                eClass = (EClass)supertypes.next();
                if (eClass != null && failedPackageSet.add(ePackage = eClass.getEPackage()) && (result = this.adapt(target, ePackage, type)) != null) break;
            }
        }
        return result;
    }

    private Adapter adapt(EObject target, EPackage ePackage, Object type) {
        AdapterFactory delegate;
        Object aProject = ProjectUtilities.getProject((EObject)target);
        if (aProject == null) {
            aProject = NO_PROJECT;
        }
        if ((delegate = this.getFactoryForPackage(aProject, ePackage)) != null && delegate.isFactoryForType(type)) {
            return delegate.adapt((Notifier)target, type);
        }
        return null;
    }

    private Adapter adapt(Object p, Notifier target, Object type, Collection failedPackages, Class javaClass) {
        if (p == null) {
            return null;
        }
        Adapter result = null;
        Package javaPackage = javaClass.getPackage();
        if (failedPackages.add(javaPackage)) {
            ArrayList<Object> types = new ArrayList<Object>(2);
            types.add(javaPackage);
            if (type != null) {
                types.add(type);
            }
            boolean attemptAdaptAgain = true;
            while (result == null && attemptAdaptAgain) {
                attemptAdaptAgain = false;
                AdapterFactory delegateAdapterFactory = this.getFactoryForTypes(p, types);
                if (delegateAdapterFactory == null) continue;
                try {
                    result = delegateAdapterFactory.adapt(target, type);
                }
                catch (RuntimeException re) {
                    Logger.getLogger().logError((Throwable)re);
                    this.removeFactoryForTypes(p, types);
                    attemptAdaptAgain = true;
                }
            }
        }
        if (result == null) {
            Class superclass = javaClass.getSuperclass();
            if (superclass != null) {
                result = this.adapt(p, target, type, failedPackages, javaClass.getSuperclass());
            }
            if (result == null) {
                Class<?>[] interfaces = javaClass.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    result = this.adapt(p, target, type, failedPackages, interfaces[i]);
                    if (result != null) break;
                    ++i;
                }
            }
        }
        return result;
    }

    public Adapter adaptNew(Notifier target, Object type) {
        AdapterFactory factory = this.getFactoryForType(target);
        if (factory != null) {
            return factory.adaptNew(target, type);
        }
        return null;
    }

    public void adaptAllNew(Notifier target) {
        AdapterFactory factory = this.getFactoryForType(target);
        if (factory != null) {
            factory.adaptAllNew(target);
        }
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.add((Object)notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.remove((Object)notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        if (this.changeNotifier == null || this.changeNotifier.isEmpty() || this.changeNotifier.get(0) == null) {
            return;
        }
        this.changeNotifier.fireNotifyChanged(notification);
    }

    public void dispose() {
        Iterator iter = this.allFactories.iterator();
        Object factory = null;
        while (iter.hasNext()) {
            factory = iter.next();
            this.disposeFactory(factory);
        }
        Iterator itr = this.getEnablementIdentifiers().iterator();
        while (itr.hasNext()) {
            ((IEnablementIdentifier)itr.next()).removeIdentifierListener((IEnablementIdentifierListener)this);
        }
        if (this.resourceItemProviderAdapterFactory != null) {
            this.resourceItemProviderAdapterFactory.removeListener((INotifyChangedListener)this);
        }
    }

    private void disposeFactory(Object factory) {
        if (factory instanceof IDisposable) {
            ((IDisposable)factory).dispose();
        }
    }

    public void notifyChanged(Notification notification) {
        this.fireNotifyChanged(notification);
    }

    private void removeAdapterFactories(Object project) {
        this.adapterFactoriesByType.remove(project);
        Map aMap = (Map)this.adapterFactoriesByPackage.remove(project);
        if (aMap == null) {
            return;
        }
        Iterator factories = aMap.values().iterator();
        while (factories.hasNext()) {
            Object adapterFactory = factories.next();
            this.allFactories.remove(adapterFactory);
            this.disposeFactory(adapterFactory);
        }
    }

    private AdapterFactory createAdapterFactory(Object project, EPackage ePackage) {
        if (ePackage == null) {
            throw new IllegalArgumentException(EMFWorkbenchEditResourceHandler.getString("DynamicAdapterFactory_ERROR_0"));
        }
        return this.createAdapterFactory(project, AdapterFactoryRegistry.instance().getDescriptors(ePackage, this.viewID));
    }

    private AdapterFactory createAdapterFactory(Object project, List descriptors) {
        if (descriptors == null || descriptors.isEmpty()) {
            return null;
        }
        AdapterFactory fact = null;
        IEnablementIdentifier identifier = null;
        AdapterFactoryDescriptor desc = null;
        if (descriptors.size() == 1) {
            desc = (AdapterFactoryDescriptor)descriptors.get(0);
            identifier = this.getIdentifier(project, desc);
            this.addListenerIfNecessary(identifier);
            if (project.equals(NO_PROJECT) || identifier != null && identifier.isEnabled()) {
                return desc.createInstance();
            }
            return null;
        }
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>(descriptors.size());
        int i = 0;
        while (i < descriptors.size()) {
            desc = (AdapterFactoryDescriptor)descriptors.get(i);
            identifier = this.getIdentifier(project, desc);
            this.addListenerIfNecessary(identifier);
            if ((project.equals(NO_PROJECT) || identifier != null && identifier.isEnabled()) && (fact = desc.createInstance()) != null) {
                factories.add(fact);
            }
            ++i;
        }
        if (factories.isEmpty()) {
            return null;
        }
        return new ExtendedComposedAdapterFactory(factories);
    }

    private IEnablementIdentifier getIdentifier(Object project, AdapterFactoryDescriptor desc) {
        IEnablementIdentifier identifier = null;
        if (this.isRespectingActivities() && project instanceof IProject) {
            identifier = IEnablementManager.INSTANCE.getIdentifier(desc.getID(), (IProject)project);
        } else if (project instanceof IProject) {
            identifier = EnablementManager.INSTANCE.getIdentifier(desc.getID(), (IProject)project);
        }
        return identifier;
    }

    private boolean isRespectingActivities() {
        return this.respectingActivities;
    }

    protected void addListenerIfNecessary(IEnablementIdentifier identifier) {
        if (identifier == null) {
            return;
        }
        identifier.addIdentifierListener((IEnablementIdentifierListener)this);
        this.getEnablementIdentifiers().add(identifier);
    }

    protected boolean isListeningTo(IEnablementIdentifier identifier) {
        return this.getEnablementIdentifiers().contains(identifier);
    }

    protected Set getEnablementIdentifiers() {
        if (this.enablementIdentifiers == null) {
            this.enablementIdentifiers = new HashSet();
        }
        return this.enablementIdentifiers;
    }

    public void identifierChanged(EnablementIdentifierEvent identifierEvent) {
        IProject project;
        if ((identifierEvent.hasEnabledChanged() || identifierEvent.hasFunctionGroupIdsChanged()) && (project = ((EnablementIdentifier)identifierEvent.getIdentifier()).getProject()) != null) {
            this.removeAdapterFactories(project);
            this.notifyChanged((Notification)new NotificationImpl(3, null, null){

                public Object getNotifier() {
                    return null;
                }
            });
        }
    }

    public ResourceItemProviderAdapterFactory getResourceItemProviderAdapterFactory() {
        if (this.resourceItemProviderAdapterFactory == null) {
            this.resourceItemProviderAdapterFactory = new ResourceItemProviderAdapterFactory();
            this.resourceItemProviderAdapterFactory.addListener((INotifyChangedListener)this);
        }
        return this.resourceItemProviderAdapterFactory;
    }
}

