/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.mysql.ddl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentServiceImpl;
import org.eclipse.wst.rdb.internal.core.rte.DDLGenerator;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOption;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.wst.rdb.internal.core.rte.fe.GenericDdlGenerationOptions;
import org.eclipse.wst.rdb.internal.models.sql.constraints.CheckConstraint;
import org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Index;
import org.eclipse.wst.rdb.internal.models.sql.constraints.TableConstraint;
import org.eclipse.wst.rdb.internal.models.sql.constraints.UniqueConstraint;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.PersistentTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.Trigger;
import org.eclipse.wst.rdb.internal.models.sql.tables.ViewTable;
import org.eclipse.wst.rdb.internal.mysql.ddl.MySqlDdlBuilder;
import org.eclipse.wst.rdb.internal.mysql.ddl.MySqlDdlScript;

public class MySqlDdlGenerator
implements DDLGenerator {
    private EngineeringOption[] options = null;
    private EngineeringOptionCategory[] categories = null;
    private MySqlDdlBuilder builder = null;

    public String[] generateDDL(SQLObject[] elements, IProgressMonitor progressMonitor) {
        String[] statements = this.createSQLObjects(elements, this.generateQuotedIdentifiers(), this.generateFullyQualifiedNames(), progressMonitor);
        if (this.generateDropStatement()) {
            String[] drop = this.dropSQLObjects(elements, this.generateQuotedIdentifiers(), this.generateFullyQualifiedNames(), progressMonitor);
            String[] temp = statements;
            statements = new String[temp.length + drop.length];
            System.arraycopy(drop, 0, statements, 0, drop.length);
            System.arraycopy(temp, 0, statements, drop.length, temp.length);
        }
        return statements;
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        String[] statements = this.createStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
        return statements;
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        String[] statements = this.dropStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
        return statements;
    }

    private String[] createStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        MySqlDdlScript script = new MySqlDdlScript();
        if (this.builder == null) {
            this.builder = new MySqlDdlBuilder();
        }
        Iterator it = this.getAllContainedDisplayableElementSet(elements).iterator();
        while (it.hasNext()) {
            String statement;
            Object o = it.next();
            if (o instanceof PersistentTable) {
                if (!this.generateTables() || (statement = this.builder.createTable((BaseTable)((PersistentTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews() || (statement = this.builder.createView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateViewStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers() || (statement = this.builder.createTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                statement = this.builder.addCheckConstraint((CheckConstraint)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                statement = this.builder.addUniqueConstraint((UniqueConstraint)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                statement = this.builder.addForeignKey((ForeignKey)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addAlterTableAddForeignKeyStatement(statement);
                continue;
            }
            if (!(o instanceof Index) || !this.generateIndexes() || (statement = this.builder.createIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addCreateIndexStatement(statement);
        }
        return script.getStatements();
    }

    private String[] dropStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        MySqlDdlScript script = new MySqlDdlScript();
        if (this.builder == null) {
            this.builder = new MySqlDdlBuilder();
        }
        Iterator it = this.getAllContainedDisplayableElementSet(elements).iterator();
        while (it.hasNext()) {
            String statement;
            Iterator iter;
            List statements;
            String statement2;
            Object o = it.next();
            if (o instanceof PersistentTable) {
                if (!this.generateTables() || (statement2 = this.builder.dropTable((BaseTable)((PersistentTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTableStatement(statement2);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews() || (statement2 = this.builder.dropView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropViewStatement(statement2);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers() || (statement2 = this.builder.dropTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTriggerStatement(statement2);
                continue;
            }
            if (o instanceof CheckConstraint) {
                statements = this.builder.dropTableConstraint((TableConstraint)((CheckConstraint)o), quoteIdentifiers, qualifyNames);
                if (statements.isEmpty()) continue;
                iter = statements.iterator();
                while (iter.hasNext()) {
                    statement = (String)iter.next();
                    script.addAlterTableDropConstraintStatement(statement);
                }
                continue;
            }
            if (o instanceof UniqueConstraint) {
                statements = this.builder.dropTableConstraint((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames);
                if (statements.isEmpty()) continue;
                iter = statements.iterator();
                while (iter.hasNext()) {
                    statement = (String)iter.next();
                    script.addAlterTableDropConstraintStatement(statement);
                }
                continue;
            }
            if (o instanceof ForeignKey) {
                statements = this.builder.dropTableConstraint((TableConstraint)((ForeignKey)o), quoteIdentifiers, qualifyNames);
                if (statements.isEmpty()) continue;
                iter = statements.iterator();
                while (iter.hasNext()) {
                    statement = (String)iter.next();
                    script.addAlterTableDropForeignKeyStatement(statement);
                }
                continue;
            }
            if (!(o instanceof Index) || !this.generateIndexes() || (statement2 = this.builder.dropIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addDropIndexStatement(statement2);
        }
        return script.getStatements();
    }

    public EngineeringOption[] getOptions() {
        if (this.options == null) {
            this.options = GenericDdlGenerationOptions.createDDLGenerationOptions((EngineeringOptionCategory[])this.getOptionCategories());
        }
        return this.options;
    }

    public EngineeringOptionCategory[] getOptionCategories() {
        if (this.categories == null) {
            this.categories = GenericDdlGenerationOptions.createDDLGenerationOptionCategories();
        }
        return this.categories;
    }

    private boolean generateDropStatement() {
        return this.getOptions()[2].getBoolean();
    }

    private final boolean generateQuotedIdentifiers() {
        return this.getOptions()[1].getBoolean();
    }

    private final boolean generateFullyQualifiedNames() {
        return this.getOptions()[0].getBoolean();
    }

    public final boolean generateTables() {
        return this.getOptions()[4].getBoolean();
    }

    public boolean generateIndexes() {
        return this.getOptions()[5].getBoolean();
    }

    public boolean generateViews() {
        return this.getOptions()[6].getBoolean();
    }

    public boolean generateTriggers() {
        return this.getOptions()[7].getBoolean();
    }

    private Set getAllContainedDisplayableElementSet(SQLObject[] elements) {
        HashSet<SQLObject> s = new HashSet<SQLObject>();
        int i = 0;
        while (i < elements.length) {
            s.add(elements[i]);
            s.addAll(ContainmentServiceImpl.INSTANCE.getAllContainedDisplayableElements((EObject)elements[i]));
            ++i;
        }
        return s;
    }
}

