/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.IPublishListener;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.WorkingCopyHelper;
import org.eclipse.wst.server.core.model.InternalInitializer;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class ServerWorkingCopy
extends Server
implements IServerWorkingCopy {
    protected Server server;
    protected WorkingCopyHelper wch;
    protected ServerDelegate workingCopyDelegate;

    public ServerWorkingCopy(Server server) {
        super(server.getFile());
        this.server = server;
        this.map = new HashMap(server.map);
        this.wch = new WorkingCopyHelper(this);
        this.resolve();
    }

    public ServerWorkingCopy(String id, IFile file, IRuntime runtime, IServerType serverType) {
        super(id, file, runtime, serverType);
        this.wch = new WorkingCopyHelper(this);
        this.wch.setDirty(true);
        this.serverState = ((ServerType)serverType).getInitialState();
    }

    public boolean isWorkingCopy() {
        return true;
    }

    public IServer getOriginal() {
        return this.server;
    }

    public IServerWorkingCopy createWorkingCopy() {
        return this;
    }

    public int getServerState() {
        if (this.server != null) {
            return this.server.getServerState();
        }
        return this.serverState;
    }

    public void setServerState(int state) {
        if (this.server != null) {
            this.server.setServerState(state);
        } else {
            super.setServerState(state);
        }
    }

    public int getServerPublishState() {
        if (this.server != null) {
            return this.server.getServerPublishState();
        }
        return this.serverState;
    }

    public void setServerPublishState(int state) {
        if (this.server != null) {
            this.server.setServerPublishState(state);
        } else {
            super.setServerPublishState(state);
        }
    }

    public String getMode() {
        if (this.server != null) {
            return this.server.getMode();
        }
        return this.mode;
    }

    public void setMode(String mode) {
        if (this.server != null) {
            this.server.setMode(mode);
        } else {
            super.setMode(mode);
        }
    }

    public void setAttribute(String attributeName, int value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, boolean value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, String value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, List value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, Map value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public void setReadOnly(boolean b) {
        this.setAttribute("locked", b);
    }

    public void setPrivate(boolean b) {
        this.setAttribute("private", b);
    }

    public void setHost(String host) {
        this.setAttribute("hostname", host);
    }

    public void setAutoPublishTime(int p) {
        this.setAttribute("auto-publish-time", p);
    }

    public void setAutoPublishSetting(int s) {
        this.setAttribute("auto-publish-setting", s);
    }

    public void setServerConfiguration(IFolder config) {
        this.configuration = config;
        if (this.configuration == null) {
            this.setAttribute("configuration-id", (String)null);
        } else {
            this.setAttribute("configuration-id", this.configuration.getFullPath().toString());
        }
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public boolean isDirty() {
        return this.wch.isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerDelegate getWorkingCopyDelegate(IProgressMonitor monitor) {
        if (this.workingCopyDelegate != null || this.serverType == null) {
            return this.workingCopyDelegate;
        }
        ServerWorkingCopy serverWorkingCopy = this;
        synchronized (serverWorkingCopy) {
            if (this.workingCopyDelegate == null) {
                try {
                    long time = System.currentTimeMillis();
                    IConfigurationElement element = ((ServerType)this.serverType).getElement();
                    this.workingCopyDelegate = (ServerDelegate)element.createExecutableExtension("class");
                    InternalInitializer.initializeServerDelegate(this.workingCopyDelegate, this, monitor);
                    Trace.trace(Trace.PERFORMANCE, "ServerWorkingCopy.getWorkingCopyDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getServerType().getId());
                }
                catch (Exception e) {
                    Trace.trace(Trace.SEVERE, "Could not create delegate " + this.toString(), e);
                }
            }
        }
        return this.workingCopyDelegate;
    }

    public void dispose() {
        super.dispose();
        if (this.workingCopyDelegate != null) {
            this.workingCopyDelegate.dispose();
        }
    }

    public IServer save(boolean force, IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.subTask(NLS.bind((String)Messages.savingTask, (Object)this.getName()));
        if (!force && this.getOriginal() != null) {
            this.wch.validateTimestamp(((Server)this.getOriginal()).getTimestamp());
        }
        if (this.server == null) {
            this.server = new Server(this.file);
            this.server.setServerState(this.serverState);
            this.server.publishListeners = this.publishListeners;
            this.server.notificationManager = this.notificationManager;
        }
        if (this.getServerType().hasServerConfiguration() && (folder = this.getServerConfiguration()) == null) {
            folder = ServerType.getServerProject().getFolder(String.valueOf(this.getName()) + "-config");
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            this.setServerConfiguration(folder);
        }
        this.server.setInternal(this);
        this.server.doSave(monitor);
        if (this.getServerType().hasServerConfiguration() && (folder = this.getServerConfiguration()) != null) {
            IProject project = folder.getProject();
            if (project != null && !project.exists()) {
                project.create(null);
                project.open(null);
                ((ProjectProperties)ServerCore.getProjectProperties(project)).setServerProject(true, monitor);
            }
            if (!folder.exists()) {
                folder.create(1, true, null);
            }
        }
        this.getDelegate(monitor).saveConfiguration(monitor);
        this.wch.setDirty(false);
        return this.server;
    }

    public IServer saveAll(boolean force, IProgressMonitor monitor) throws CoreException {
        if (this.runtime != null && this.runtime.isWorkingCopy()) {
            IRuntimeWorkingCopy wc = (IRuntimeWorkingCopy)this.runtime;
            wc.save(force, monitor);
        }
        return this.save(force, monitor);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.wch.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.wch.removePropertyChangeListener(listener);
    }

    public void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        this.wch.firePropertyChangeEvent(propertyName, oldValue, newValue);
    }

    public void addServerListener(IServerListener listener) {
        if (this.server != null) {
            this.server.addServerListener(listener);
        } else {
            super.addServerListener(listener);
        }
    }

    public void removeServerListener(IServerListener listener) {
        if (this.server != null) {
            this.server.removeServerListener(listener);
        } else {
            super.removeServerListener(listener);
        }
    }

    public void addPublishListener(IPublishListener listener) {
        if (this.server != null) {
            this.server.addPublishListener(listener);
        } else {
            super.addPublishListener(listener);
        }
    }

    public void removePublishListener(IPublishListener listener) {
        if (this.server != null) {
            this.server.removePublishListener(listener);
        } else {
            super.removePublishListener(listener);
        }
    }

    public void setRuntime(IRuntime runtime) {
        this.runtime = runtime;
        if (runtime != null) {
            this.setAttribute("runtime-id", runtime.getId());
        } else {
            this.setAttribute("runtime-id", (String)null);
        }
    }

    public void setRuntimeId(String runtimeId) {
        this.setAttribute("runtime-id", runtimeId);
        this.resolve();
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        if (add == null && remove == null) {
            throw new IllegalArgumentException("Add and remove cannot both be null");
        }
        try {
            int i;
            int size;
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.subTask(Messages.taskModifyModules);
            this.getWorkingCopyDelegate(monitor).modifyModules(add, remove, monitor);
            this.wch.setDirty(true);
            this.getModules();
            if (add != null) {
                size = add.length;
                i = 0;
                while (i < size) {
                    if (!this.modules.contains(add[i])) {
                        this.modules.add(add[i]);
                    }
                    ++i;
                }
            }
            if (remove != null) {
                size = remove.length;
                i = 0;
                while (i < size) {
                    if (this.modules.contains(remove[i])) {
                        this.modules.remove(remove[i]);
                    }
                    ++i;
                }
            }
            ArrayList<String> list = new ArrayList<String>();
            Iterator iterator = this.modules.iterator();
            while (iterator.hasNext()) {
                IModule module = (IModule)iterator.next();
                list.add(String.valueOf(module.getName()) + "::" + module.getId());
            }
            this.setAttribute("modules", list);
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate modifyModule() " + this.toString(), e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public void setDefaults(IProgressMonitor monitor) {
        try {
            this.getWorkingCopyDelegate(monitor).setDefaults(monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate setDefaults() " + this.toString(), e);
        }
    }

    public String toString() {
        return "ServerWorkingCopy " + this.getId();
    }
}

