/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.tomcat.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.application.internal.operations.FlexibleProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.operations.NewServletClassDataModel;
import org.eclipse.jst.servlet.tomcat.tests.AllTomcatTests;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.LogUtility;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wst.common.tests.TaskViewUtility;

public class WebProjectCreationTomcatTest
extends TestCase {
    protected String projectName = null;
    static /* synthetic */ Class class$0;

    public void createSimpleProject(String projectName) throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new FlexibleProjectCreationDataModelProvider());
        dataModel.setProperty("IFlexibleProjectCreationDataModelProperties.PROJECT_NAME", (Object)projectName);
        this.setServerTargetProperty(dataModel);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
    }

    public void setServerTargetProperty(IDataModel dataModel) {
        dataModel.setProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", (Object)AllTomcatTests.TOMCAT_RUNTIME.getId());
    }

    public static void createServlet(NewServletClassDataModel model) throws Exception {
    }

    public IDataModel setupStandaloneWebProject(String aProjectName, int j2eeVersion) throws Exception {
        this.projectName = aProjectName;
        this.createSimpleProject(this.projectName);
        IDataModel model = this.getWebComponentCreationDataModel(this.projectName, j2eeVersion);
        WebProjectCreationTomcatTest.createStandaloneWebProject(model);
        this.createServlet(this.projectName);
        return model;
    }

    public IDataModel setupStandaloneAnnotatedWebProject(String aProjectName, int j2eeVersion) throws Exception {
        this.projectName = aProjectName;
        this.createSimpleProject(this.projectName);
        IDataModel model = this.getWebComponentCreationDataModel(this.projectName, j2eeVersion);
        WebProjectCreationTomcatTest.createStandaloneWebProject(model);
        this.createAnnotatedServlet(this.projectName);
        return model;
    }

    public static void createStandaloneWebProject(IDataModel model) throws Exception {
        IDataModelOperation webOp = model.getDefaultOperation();
        webOp.execute((IProgressMonitor)new NullProgressMonitor(), null);
        TaskViewUtility.verifyNoErrors();
    }

    private IDataModel getWebComponentCreationDataModel(String aProjectName, int j2eeVersion) {
        this.projectName = aProjectName;
        IProject javaProject = ProjectUtility.getProject((String)aProjectName);
        String moduleName = String.valueOf(aProjectName) + "WebModule";
        String moduleDeployName = String.valueOf(moduleName) + ".war";
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentCreationDataModelProvider());
        model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)javaProject.getName());
        model.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeVersion);
        model.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)moduleName);
        model.setProperty("IComponentCreationDataModelProperties.COMPONENT_DEPLOY_NAME", (Object)moduleDeployName);
        return model;
    }

    private void createServlet(String projectName) throws Exception {
        NewServletClassDataModel servletModel = this.setupServletCreationDataModel(projectName);
        WebProjectCreationTomcatTest.createServlet(servletModel);
    }

    private void createAnnotatedServlet(String projectName) throws Exception {
        NewServletClassDataModel servletModel = this.setupAnnotatedServletCreationDataModel(projectName);
        WebProjectCreationTomcatTest.createServlet(servletModel);
    }

    public NewServletClassDataModel setupAnnotatedServletCreationDataModel(String projectName) {
        NewServletClassDataModel servletDataModel = new NewServletClassDataModel();
        servletDataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)projectName);
        servletDataModel.setProperty("NewJavaClassDataModel.CLASS_NAME", (Object)"FooServlet");
        servletDataModel.setProperty("NewServletClassDataModel.DISPLAY_NAME", (Object)"FooServlet");
        servletDataModel.setBooleanProperty("IAnnotationsDataModel.useAnnotations", true);
        return servletDataModel;
    }

    public NewServletClassDataModel setupServletCreationDataModel(String projectName) {
        NewServletClassDataModel servletDataModel = new NewServletClassDataModel();
        servletDataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)projectName);
        servletDataModel.setProperty("NewJavaClassDataModel.CLASS_NAME", (Object)"FooServlet");
        servletDataModel.setProperty("NewServletClassDataModel.DISPLAY_NAME", (Object)"FooServlet");
        servletDataModel.setBooleanProperty("IAnnotationsDataModel.useAnnotations", false);
        return servletDataModel;
    }

    public void createVaildProjectAndServletCreation(String projectName, int j2eeVersion) throws Exception {
        LogUtility.getInstance().resetLogging();
        IDataModel model = null;
        model = this.setupStandaloneWebProject(projectName, j2eeVersion);
        LogUtility.getInstance().verifyNoWarnings();
        this.checkValidDataModel(model);
    }

    public void createVaildAnnotatedProjectAndServletCreation(String projectName, int j2eeVersion) throws Exception {
        LogUtility.getInstance().resetLogging();
        IDataModel model = null;
        model = this.setupStandaloneAnnotatedWebProject(projectName, j2eeVersion);
        LogUtility.getInstance().verifyNoWarnings();
        this.checkValidDataModel(model);
    }

    protected void checkValidDataModel(IDataModel model) {
    }

    public void testVaild12WebProjectNameCreation() throws Exception {
        ProjectUtility.deleteAllProjects();
        this.createVaildProjectAndServletCreation("FooTomcatWebProject12", 22);
    }

    public void testVaild13WebProjectNameCreation() throws Exception {
        ProjectUtility.deleteAllProjects();
        this.createVaildProjectAndServletCreation("Foo1TomcatWebProject13", 23);
    }

    public void testVaild14WebProjectNameCreation() throws Exception {
        ProjectUtility.deleteAllProjects();
        this.createVaildProjectAndServletCreation("Foo1TomcatWebProject14", 24);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.servlet.tomcat.tests.WebProjectCreationTomcatTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SimpleTestSuite((Class)clazz);
    }

    public IDataModel getProjectCreationDataModel() {
        return null;
    }
}

