/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.ws.internal.common.J2EEActionAdapterFactory;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.common.WSDLParserFactory;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.WSDLSelectionConditionCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.WSDLSelectionTreeWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.AbstractObjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.IObjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.Timer;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.WSDLSelectionWrapper;
import org.eclipse.jst.ws.internal.ui.common.DialogResourceBrowser;
import org.eclipse.jst.ws.internal.ui.common.FileExtensionFilter;
import org.eclipse.jst.ws.internal.ui.common.IFilter;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.ws.internal.parser.wsil.WebServiceEntity;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.wsdl.internal.impl.ServiceImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public class WSDLSelectionWidget
extends AbstractObjectSelectionWidget
implements IObjectSelectionWidget,
Runnable {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private MessageUtils msgUtils_ = new MessageUtils(String.valueOf(this.pluginId_) + ".plugin", (Object)this);
    private FileExtensionFilter wsFilter_ = new FileExtensionFilter(new String[]{"wsdl", "wsil", "html"});
    private WebServicesParser webServicesParser = WSDLParserFactory.getWSDLParser();
    private Composite parent_;
    private Listener statusListener_;
    private WSDLSelectionTreeWidget tree;
    private final String INFOPOP_PCON_PAGE = "PCON0001";
    private final String INFOPOP_PCON_TEXT_WSDL = "PCON0002";
    private Text webServiceURI;
    private final String INFOPOP_PCON_BUTTON_BROWSE_WSDL = "PCON0003";
    private Button wsBrowseButton_;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils(this.msgUtils_, this.pluginId_);
        this.parent_ = parent;
        this.statusListener_ = statusListener;
        parent.setToolTipText(this.msgUtils_.getMessage("TOOLTIP_PCON_PAGE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(this.pluginId_) + "." + "PCON0001");
        Composite wsdlGroup = uiUtils.createComposite(parent, 2, 5, 0);
        Label wsLabel = new Label(wsdlGroup, 64);
        wsLabel.setText(this.msgUtils_.getMessage("LABEL_WS_SELECTION"));
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        wsLabel.setLayoutData((Object)gd);
        wsLabel.setToolTipText(this.msgUtils_.getMessage("TOOLTIP_PCON_TEXT_WS"));
        this.webServiceURI = uiUtils.createText(wsdlGroup, null, "TOOLTIP_PCON_TEXT_WS", "PCON0002", 2052);
        this.webServiceURI.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                WSDLSelectionWidget.this.handleWebServiceURIModifyEvent();
            }
        });
        this.webServiceURI.addListener(24, statusListener);
        this.wsBrowseButton_ = uiUtils.createPushButton(wsdlGroup, "BUTTON_BROWSE", "TOOLTIP_PCON_BUTTON_BROWSE_WS", "PCON0003");
        this.wsBrowseButton_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                WSDLSelectionWidget.this.handleWSDLButton();
            }

            public void widgetSelected(SelectionEvent event) {
                WSDLSelectionWidget.this.handleWSDLButton();
            }
        });
        this.tree = new WSDLSelectionTreeWidget();
        this.tree.addControls(parent, statusListener);
        this.tree.setWebServicesParser(this.webServicesParser);
        return this;
    }

    private void handleWebServiceURIModifyEvent() {
        if (this.webServiceURI.getText().indexOf(58) > 0) {
            Timer.newInstance(Display.getCurrent(), this).startTimer();
        } else {
            this.handleWebServiceURI();
        }
        this.statusListener_.handleEvent(null);
    }

    private void handleWebServiceURI() {
        WebServiceEntity entity;
        IFile file;
        String wsURI = this.webServiceURI.getText();
        if (wsURI.indexOf(58) < 0 && (file = this.uri2IFile(wsURI)) != null) {
            wsURI = this.iFile2URI(file);
        }
        if (wsURI != null && wsURI.indexOf(58) >= 0 && this.webServicesParser.getWebServiceEntityByURI(wsURI) == null) {
            WSDLSelectionConditionCommand cmd = new WSDLSelectionConditionCommand();
            cmd.setWebServicesParser(this.webServicesParser);
            cmd.setWebServiceURI(wsURI);
            cmd.execute(null);
        }
        if ((entity = this.webServicesParser.getWebServiceEntityByURI(wsURI)) != null && entity.getType() == 2) {
            this.tree.setEnabled(false);
        } else {
            this.tree.setEnabled(true);
        }
        this.tree.setWebServiceURI(wsURI);
        this.tree.refreshTreeViewer();
    }

    public void run() {
        this.handleWebServiceURI();
        this.statusListener_.handleEvent(null);
    }

    private void handleWSDLButton() {
        DialogResourceBrowser dialog = new DialogResourceBrowser(this.parent_.getShell(), null, (IFilter)this.wsFilter_);
        dialog.open();
        IResource res = dialog.getFirstSelection();
        if (res != null) {
            this.webServiceURI.setText(res.getFullPath().toString());
        }
        this.statusListener_.handleEvent(null);
    }

    public Status getStatus() {
        String wsdlURI;
        String wsPath = this.webServiceURI.getText();
        if (wsPath == null || wsPath.length() <= 0) {
            return new SimpleStatus("", this.msgUtils_.getMessage("PAGE_MSG_INVALID_WEB_SERVICE_URI"), 4);
        }
        if (wsPath.indexOf(58) < 0) {
            IResource res = ResourceUtils.findResource((String)wsPath);
            if (res == null) {
                return new SimpleStatus("", this.msgUtils_.getMessage("PAGE_MSG_NO_SUCH_FILE", new Object[]{wsPath}), 4);
            }
            if (res.getType() != 1) {
                return new SimpleStatus("", this.msgUtils_.getMessage("PAGE_MSG_INVALID_WEB_SERVICE_URI"), 4);
            }
        }
        if (!Timer.isRunning() && this.tree.isEnabled()) {
            int severity;
            Status status = this.tree.getStatus();
            if (status != null && ((severity = status.getSeverity()) == 4 || severity == 2)) {
                return status;
            }
        } else if (wsPath.indexOf(58) < 0 && this.webServicesParser.getWSDLDefinition(wsdlURI = this.iFile2URI((IFile)ResourceUtils.findResource((String)wsPath))) == null) {
            return new SimpleStatus("", this.msgUtils_.getMessage("PAGE_MSG_SELECTION_MUST_BE_WSDL"), 4);
        }
        return new SimpleStatus("");
    }

    private IFile uri2IFile(String uri) {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(uri);
        if (res instanceof IFile) {
            return (IFile)res;
        }
        return null;
    }

    private String iFile2URI(IFile file) {
        File f = file.getLocation().toFile();
        try {
            return f.toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            return f.toString();
        }
    }

    public void setInitialSelection(IStructuredSelection initialSelection) {
        Object object;
        String wsdlURI;
        if (initialSelection != null && !initialSelection.isEmpty() && (wsdlURI = this.toWsdlURI(object = initialSelection.getFirstElement())) != null) {
            this.webServiceURI.setText(wsdlURI);
            this.handleWebServiceURI();
        }
    }

    private String toWsdlURI(Object object) {
        if (object instanceof ServiceImpl) {
            return J2EEActionAdapterFactory.getWSDLURI((ServiceImpl)((ServiceImpl)object));
        }
        if (object instanceof WSDLResourceImpl) {
            return J2EEActionAdapterFactory.getWSDLURI((WSDLResourceImpl)((WSDLResourceImpl)object));
        }
        if (object instanceof ServiceRef) {
            return J2EEActionAdapterFactory.getWSDLURI((ServiceRef)((ServiceRef)object));
        }
        if (object instanceof IFile) {
            return ((IFile)object).getFullPath().toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    private String toAbsoluteWsdlURI(Object object) {
        if (object instanceof IFile) {
            try {
                return ((IFile)object).getLocation().toFile().toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return this.toWsdlURI(object);
    }

    public IStructuredSelection getObjectSelection() {
        return new StructuredSelection((Object)new WSDLSelectionWrapper(this.webServicesParser, (IStructuredSelection)new StructuredSelection((Object)this.tree.getWsdlURI())));
    }

    public WebServicesParser getWebServicesParser() {
        return this.webServicesParser;
    }

    public Status validateSelection(IStructuredSelection objectSelection) {
        return new SimpleStatus("");
    }

    public IProject getProject() {
        String wsdlURI = this.tree.getWsdlURI();
        if (wsdlURI != null) {
            IProject p = this.getProjectFromURI(wsdlURI);
            if (p != null && p.exists()) {
                return p;
            }
            String wsRelPath = this.webServiceURI.getText();
            IResource wsRes = ResourceUtils.findResource((String)wsRelPath);
            if (wsRes != null && wsRes instanceof IFile) {
                IProject p2 = ((IFile)wsRes).getProject();
                return p2;
            }
        }
        return null;
    }

    public String getComponentName() {
        String wsdlURI = this.tree.getWsdlURI();
        if (wsdlURI != null) {
            IVirtualComponent comp;
            String cname = this.getComponentNameFromURI(wsdlURI);
            if (cname != null && cname.length() > 0) {
                return cname;
            }
            String wsRelPath = this.webServiceURI.getText();
            IResource wsRes = ResourceUtils.findResource((String)wsRelPath);
            if (wsRes != null && wsRes instanceof IFile && (comp = ResourceUtils.getComponentOf((IResource)wsRes)) != null) {
                return comp.getName();
            }
        }
        return null;
    }

    private IProject getProjectFromURI(String uri) {
        String relPath;
        IResource res;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String wkspcRootLoc = root.getLocation().toString();
        int idx = uri.indexOf(wkspcRootLoc);
        if (idx != -1 && (res = root.findMember((IPath)new Path(relPath = uri.substring(wkspcRootLoc.length() + idx)))) instanceof IFile) {
            IProject p = ((IFile)res).getProject();
            return p;
        }
        return null;
    }

    private String getComponentNameFromURI(String uri) {
        IVirtualComponent comp;
        String relPath;
        IResource res;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String wkspcRootLoc = root.getLocation().toString();
        int idx = uri.indexOf(wkspcRootLoc);
        if (idx != -1 && (res = root.findMember((IPath)new Path(relPath = uri.substring(wkspcRootLoc.length() + idx)))) instanceof IFile && (comp = ResourceUtils.getComponentOf((IResource)res)) != null) {
            return comp.getName();
        }
        return null;
    }
}

