/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test;

import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.plugin.WebServiceConsumptionPlugin;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.provisional.env.core.context.TransientResourceContext;

public class CopyWebServiceUtilsJarCommand
extends SimpleCommand {
    private static String DESCRIPTION = "Copy WebserviceUtils.jar";
    private static String LABEL = "CopyWebServiceUtilsJarCommand";
    private String sampleProject;
    private String sampleC;
    private MessageUtils msgUtils;

    public CopyWebServiceUtilsJarCommand() {
        super(LABEL, DESCRIPTION);
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
    }

    public Status execute(Environment env) {
        try {
            env.getProgressMonitor().report(this.msgUtils.getMessage("PROGRESS_INFO_COPY_WEBSERVICE_UTILS"));
            IProject sampleIProject = ProjectUtilities.getProject((String)this.sampleProject);
            IPath webModulePath = J2EEUtils.getWebContentPath((IProject)sampleIProject, (String)this.sampleC);
            if (webModulePath == null) {
                return new SimpleStatus("org.eclipse.jst.ws.consumption.ui", this.msgUtils.getMessage("MSG_ERROR_PROJECT_NOT_FOUND"), 4);
            }
            Status status = this.copyIFile("webserviceutils.jar", webModulePath, "WEB-INF/lib/webserviceutils.jar", (Plugin)WebServiceConsumptionPlugin.getInstance(), env);
            if (status.getSeverity() == 4) {
                StatusHandler sHandler = env.getStatusHandler();
                SimpleStatus errorStatus = new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_FILECOPY_WEBSERVICE_UTILS"), 4);
                sHandler.reportError((Status)errorStatus);
                return status;
            }
        }
        catch (Exception e) {
            StatusHandler sHandler = env.getStatusHandler();
            SimpleStatus errorStatus = new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_FILECOPY_WEBSERVICE_UTILS"), 4);
            sHandler.reportError((Status)errorStatus);
            return new SimpleStatus("org.eclipse.jst.ws.consumption.ui", this.msgUtils.getMessage("MSG_ERROR_FILECOPY_WEBSERVICE_UTILS"), 4, (Throwable)e);
        }
        return new SimpleStatus("");
    }

    private Status copyIFile(String source, IPath targetPath, String targetFile, Environment env) {
        return this.copyIFile(source, targetPath, targetFile, (Plugin)WebServicePlugin.getInstance(), env);
    }

    private Status copyIFile(String source, IPath targetPath, String targetFile, Plugin plugin, Environment env) {
        if (plugin != null) {
            IPath target = targetPath.append((IPath)new Path(targetFile));
            env.getProgressMonitor().report(this.msgUtils.getMessage("PROGRESS_INFO_COPYING_FILE"));
            try {
                TransientResourceContext context = new TransientResourceContext();
                context.setOverwriteFilesEnabled(true);
                context.setCreateFoldersEnabled(true);
                context.setCheckoutFilesEnabled(true);
                IResource resource = FileResourceUtils.findResource((IPath)target);
                if (resource != null) {
                    return new SimpleStatus("");
                }
                FileResourceUtils.createFile((ResourceContext)context, (IPath)target, (InputStream)plugin.openStream((IPath)new Path(source)), (ProgressMonitor)env.getProgressMonitor(), (StatusHandler)env.getStatusHandler());
            }
            catch (Exception e) {
                return new SimpleStatus("org.eclipse.jst.ws.consumption.ui", this.msgUtils.getMessage("MSG_ERROR_FILECOPY_WEBSERVICE_UTILS"), 4, (Throwable)e);
            }
        }
        return new SimpleStatus("");
    }

    public void setSampleProject(String sampleProject) {
        this.sampleProject = sampleProject;
    }

    public void setSampleComponent(String sampleComponent) {
        this.sampleC = sampleComponent;
    }
}

