/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test.wssample;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.consumption.codegen.Generator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.InputFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.MethodFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.ResultFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.TestClientFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.command.GeneratePageCommand;
import org.eclipse.jst.ws.internal.consumption.sampleapp.command.JavaToModelCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.CopyWebServiceUtilsJarCommand;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.provisional.wsrt.TestInfo;

public class GSTCGenerateCommand
extends SimpleCommand {
    public static String INPUT = "Input.jsp";
    public static String TEST_CLIENT = "TestClient.jsp";
    public static String RESULT = "Result.jsp";
    public static String METHOD = "Method.jsp";
    private TestInfo testInfo;
    private Model proxyModel;

    public GSTCGenerateCommand(TestInfo testInfo) {
        this.testInfo = testInfo;
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        CopyWebServiceUtilsJarCommand copy = new CopyWebServiceUtilsJarCommand();
        copy.setSampleProject(this.testInfo.getGenerationProject());
        copy.setSampleComponent(this.testInfo.getGenerationModule());
        status = copy.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        status = this.createModel(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        status = this.generatePages(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        return status;
    }

    private Status createModel(Environment env) {
        JavaToModelCommand jtmc = new JavaToModelCommand();
        jtmc.setMethods(this.testInfo.getMethods());
        jtmc.setClientProject(this.testInfo.getClientProject());
        jtmc.setProxyBean(this.testInfo.getProxyBean());
        Status status = jtmc.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        this.proxyModel = jtmc.getDataModel();
        return status;
    }

    private Status generatePages(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        Path fDestinationFolderPath = new Path(this.testInfo.getJspFolder());
        fDestinationFolderPath = fDestinationFolderPath.makeAbsolute();
        IWorkspaceRoot fWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IPath pathTest = fDestinationFolderPath.append(TEST_CLIENT);
        IFile fileTest = fWorkspace.getFile(pathTest);
        GeneratePageCommand gpcTest = new GeneratePageCommand(EnvironmentUtils.getResourceContext((Environment)env), this.proxyModel, (Generator)new TestClientFileGenerator(INPUT, METHOD, RESULT), fileTest);
        status = gpcTest.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        IPath pathInput = fDestinationFolderPath.append(INPUT);
        IFile fileInput = fWorkspace.getFile(pathInput);
        InputFileGenerator inputGenerator = new InputFileGenerator(RESULT);
        GeneratePageCommand gpcInput = new GeneratePageCommand(EnvironmentUtils.getResourceContext((Environment)env), this.proxyModel, (Generator)inputGenerator, fileInput);
        status = gpcInput.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        IPath pathMethod = fDestinationFolderPath.append(METHOD);
        IFile fileMethod = fWorkspace.getFile(pathMethod);
        MethodFileGenerator methodGenerator = new MethodFileGenerator(INPUT);
        methodGenerator.setClientFolderPath(this.testInfo.getJspFolder());
        GeneratePageCommand gpcMethod = new GeneratePageCommand(EnvironmentUtils.getResourceContext((Environment)env), this.proxyModel, (Generator)methodGenerator, fileMethod);
        status = gpcMethod.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        IPath pathResult = fDestinationFolderPath.append(RESULT);
        IFile fileResult = fWorkspace.getFile(pathResult);
        ResultFileGenerator rfg = new ResultFileGenerator();
        rfg.setClientFolderPath(this.testInfo.getJspFolder());
        rfg.setSetEndpointMethod(this.testInfo.getSetEndpointMethod());
        GeneratePageCommand gpcResult = new GeneratePageCommand(EnvironmentUtils.getResourceContext((Environment)env), this.proxyModel, (Generator)rfg, fileResult);
        status = gpcResult.execute(env);
        return status;
    }
}

