/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;

public class ServerUIPreferences {
    private static final String PREF_PROMPT_IRREVERSIBLE = "prompt-irreversible";
    private static final String PREF_IMPORT_LOCATION = "import-location";
    private static final String PREF_SAVE_EDITORS = "save-editors";
    private static final String PREF_HOST_NAMES = "host-names";
    private static final String PREF_SHOW_ON_ACTIVITY = "show-on-activity";
    public static final byte SAVE_EDITORS_NEVER = 0;
    public static final byte SAVE_EDITORS_PROMPT = 1;
    public static final byte SAVE_EDITORS_AUTO = 2;
    private static final int MAX_HOSTNAMES = 10;
    private Preferences preferences = ServerUIPlugin.getInstance().getPluginPreferences();

    public void setDefaults() {
        this.preferences.setDefault(PREF_PROMPT_IRREVERSIBLE, this.getDefaultPromptBeforeIrreversibleChange());
        this.preferences.setDefault(PREF_SAVE_EDITORS, (int)this.getDefaultSaveEditors());
        this.preferences.setDefault(PREF_HOST_NAMES, "localhost");
        this.preferences.setDefault(PREF_SHOW_ON_ACTIVITY, true);
    }

    public boolean getPromptBeforeIrreversibleChange() {
        return this.preferences.getBoolean(PREF_PROMPT_IRREVERSIBLE);
    }

    public boolean getDefaultPromptBeforeIrreversibleChange() {
        return true;
    }

    public void setPromptBeforeIrreversibleChange(boolean b) {
        this.preferences.setValue(PREF_PROMPT_IRREVERSIBLE, b);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public String getImportLocation() {
        return this.preferences.getString(PREF_IMPORT_LOCATION);
    }

    public void setImportLocation(String s) {
        this.preferences.setValue(PREF_IMPORT_LOCATION, s);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public byte getDefaultSaveEditors() {
        return 1;
    }

    public byte getSaveEditors() {
        return (byte)this.preferences.getInt(PREF_SAVE_EDITORS);
    }

    public void setSaveEditors(byte b) {
        this.preferences.setValue(PREF_SAVE_EDITORS, (int)b);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public boolean getDefaultShowOnActivity() {
        return true;
    }

    public boolean getShowOnActivity() {
        return this.preferences.getBoolean(PREF_SHOW_ON_ACTIVITY);
    }

    public void setShowOnActivity(boolean b) {
        this.preferences.setValue(PREF_SHOW_ON_ACTIVITY, b);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public List getHostnames() {
        String s = this.preferences.getString(PREF_HOST_NAMES);
        StringTokenizer st = new StringTokenizer(s, "|*|");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public void addHostname(String hostname) {
        if ("localhost".equals(hostname)) {
            return;
        }
        List list = this.getHostnames();
        if (list.contains(hostname)) {
            list.remove(hostname);
        }
        list.add(1, hostname);
        if (list.size() > 10) {
            list.remove(list.size() - 1);
        }
        StringBuffer sb = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            sb.append(s);
            sb.append("|*|");
        }
        this.preferences.setValue(PREF_HOST_NAMES, sb.toString());
        ServerUIPlugin.getInstance().savePluginPreferences();
    }
}

