/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.ui.wsi.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.wst.command.internal.provisional.env.core.common.Choice;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.ws.internal.ui.plugin.WSUIPlugin;
import org.eclipse.wst.ws.internal.ui.wsi.preferences.PersistentWSIContext;

public class WSIComplianceUtils {
    private static final int IGNORE_ID = 0;
    private static final int IGNORE_ALL_ID = 1;
    private static final int CANCEL_ID = 2;
    private static MessageUtils msgUtils_;

    public static int getWSISeverity(IProject project) {
        return WSIComplianceUtils.getWSISeverity(project, WSUIPlugin.getInstance().getWSISSBPContext());
    }

    public static int getWSISeverity(IProject project, PersistentWSIContext context) {
        if (context.projectStopNonWSICompliances(project)) {
            return 4;
        }
        if (context.projectWarnNonWSICompliances(project)) {
            return 2;
        }
        return 1;
    }

    public static boolean checkWSICompliance(StatusHandler monitor, Status[] status, IProject project) {
        return WSIComplianceUtils.checkWSICompliance(monitor, status, project, WSUIPlugin.getInstance().getWSISSBPContext());
    }

    public static boolean checkWSICompliance(StatusHandler monitor, Status[] status, IProject project, PersistentWSIContext context) {
        String pluginId = "org.eclipse.wst.ws.ui";
        msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)WSUIPlugin.getInstance());
        if (context.projectStopNonWSICompliances(project)) {
            SimpleStatus status_ = new SimpleStatus("org.eclipse.wst.ws.ui", msgUtils_.getMessage(context.getError()), 4);
            int i = 0;
            while (i < status.length) {
                status_.addChild(status[i]);
                ++i;
            }
            monitor.reportError((Status)status_);
            return false;
        }
        if (context.projectWarnNonWSICompliances(project)) {
            Choice cancelChoice;
            Choice ignoreAllChoice;
            SimpleStatus status_ = new SimpleStatus("org.eclipse.wst.ws.ui", msgUtils_.getMessage(context.getWarning()), 2);
            int i = 0;
            while (i < status.length) {
                status_.addChild(status[i]);
                ++i;
            }
            Choice ignoreChoice = new Choice('I', msgUtils_.getMessage("IGNORE_LABEL"), msgUtils_.getMessage("IGNORE_DESCRIPTION"));
            Choice result = monitor.report((Status)status_, new Choice[]{ignoreChoice, ignoreAllChoice = new Choice('A', msgUtils_.getMessage("IGNORE_ALL_LABEL"), msgUtils_.getMessage("IGNORE_ALL_DESCRIPTION")), cancelChoice = new Choice('C', msgUtils_.getMessage("CANCEL_LABEL"), msgUtils_.getMessage("CANCEL_DESCRIPTION"))});
            if (result == null || result.getLabel().equals(ignoreChoice.getLabel())) {
                return true;
            }
            if (result.getLabel().equals(ignoreAllChoice.getLabel())) {
                context.updateProjectWSICompliances(project, "2");
                return true;
            }
            if (result.getLabel().equals(cancelChoice.getLabel())) {
                return false;
            }
        }
        return true;
    }
}

