/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.response;

import java.util.Vector;
import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.uddi4j.response.ErrInfo;
import org.uddi4j.response.Result;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DispositionReport
extends UDDIElement {
    public static String UDDI_TAG = "dispositionReport";
    String genericAttrib = null;
    String operatorAttrib = null;
    String truncated = null;
    Vector results = new Vector();
    public static final String E_assertionNotFound = "E_assertionNotFound";
    public static final String E_authTokenExpired = "E_authTokenExpired";
    public static final String E_authTokenRequired = "E_authTokenRequired";
    public static final String E_accountLimitExceeded = "E_accountLimitExceeded";
    public static final String E_busy = "E_busy";
    public static final String E_categorizationNotAllowed = "E_categorizationNotAllowed";
    public static final String E_fatalError = "E_fatalError";
    public static final String E_invalidKeyPassed = "E_invalidKeyPassed";
    public static final String E_invalidProjection = "E_invalidProjection";
    public static final String E_invalidCategory = "E_invalidCategory";
    public static final String E_invalidCompletionStatus = "E_invalidCompletionStatus";
    public static final String E_invalidURLPassed = "E_invalidURLPassed";
    public static final String E_invalidValue = "E_invalidValue";
    public static final String E_keyRetired = "E_keyRetired";
    public static final String E_languageError = "E_languageError";
    public static final String E_messageTooLarge = "E_messageTooLarge";
    public static final String E_nameTooLong = "E_nameTooLong";
    public static final String E_operatorMismatch = "E_operatorMismatch";
    public static final String E_publisherCancelled = "E_publisherCancelled";
    public static final String E_requestDenied = "E_requestDenied";
    public static final String E_requestTimeout = "E_requestTimeout";
    public static final String E_secretUnknown = "E_secretUnknown";
    public static final String E_success = "E_success";
    public static final String E_tooManyOptions = "E_tooManyOptions";
    public static final String E_transferAborted = "E_transferAborted";
    public static final String E_unrecognizedVersion = "E_unrecognizedVersion";
    public static final String E_unknownUser = "E_unknownUser";
    public static final String E_unsupported = "E_unsupported";
    public static final String E_unvalidatable = "E_unvalidatable";
    public static final String E_userMismatch = "E_userMismatch";
    public static final String E_valueNotAllowed = "E_valueNotAllowed";

    public DispositionReport() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DispositionReport(Element el) throws UDDIException {
        NodeList nl;
        boolean fault = false;
        UDDIException exception = null;
        if (UDDIException.isValidElement(el)) {
            fault = true;
            exception = new UDDIException(el, true);
            nl = exception.getDetailElement().getElementsByTagName(UDDI_TAG);
            if (nl.getLength() <= 0) throw exception;
            this.base = (Element)nl.item(0);
        } else {
            this.base = el;
        }
        if (this.isValidElement(this.base)) {
            this.genericAttrib = el.getAttribute("generic");
            this.operatorAttrib = el.getAttribute("operator");
            this.truncated = el.getAttribute("truncated");
            nl = el.getElementsByTagName("result");
            for (int i = 0; i < nl.getLength(); ++i) {
                this.results.add(new Result((Element)nl.item(i)));
            }
        }
        if (!fault) return;
        throw exception;
    }

    public boolean getTruncated() {
        return "true".equals(this.truncated);
    }

    public String getGeneric() {
        return this.genericAttrib;
    }

    public String getOperator() {
        return this.operatorAttrib;
    }

    public boolean success() {
        boolean success = true;
        for (int i = 0; i < this.results.size(); ++i) {
            int errnoInt = new Integer(((Result)this.results.elementAt(i)).getErrno());
            success = success && errnoInt == 0;
        }
        return success;
    }

    public int getErrno() {
        if (this.results.size() > 0) {
            return new Integer(((Result)this.results.elementAt(0)).getErrno());
        }
        return -1;
    }

    public int getErrno(int index) {
        if (this.results.size() > index) {
            return new Integer(((Result)this.results.elementAt(index)).getErrno());
        }
        return -1;
    }

    public String getErrCode() {
        if (this.results.size() > 0) {
            Result r = (Result)this.results.elementAt(0);
            if (r.getErrInfo() != null) {
                return r.getErrInfo().getErrCode();
            }
            return null;
        }
        return null;
    }

    public String getErrCode(int index) {
        if (this.results.size() > index) {
            Result r = (Result)this.results.elementAt(index);
            if (r.getErrInfo() != null) {
                return r.getErrInfo().getErrCode();
            }
            return null;
        }
        return null;
    }

    public String getErrInfoText() {
        if (this.results.size() > 0) {
            Result r = (Result)this.results.elementAt(0);
            if (r.getErrInfo() != null) {
                return r.getErrInfo().getText();
            }
            return null;
        }
        return null;
    }

    public String getErrInfoText(int index) {
        if (this.results.size() > index) {
            Result r = (Result)this.results.elementAt(index);
            if (r.getErrInfo() != null) {
                return r.getErrInfo().getText();
            }
            return null;
        }
        return null;
    }

    public String getKeyType() {
        if (this.results.size() > 0) {
            return ((Result)this.results.elementAt(0)).getKeyType();
        }
        return null;
    }

    public String getKeyType(int index) {
        if (this.results.size() > index) {
            return ((Result)this.results.elementAt(index)).getKeyType();
        }
        return null;
    }

    public Vector getResultVector() {
        return this.results;
    }

    public int getNumResults() {
        return this.results.size();
    }

    public void setGeneric(String gen) {
        this.genericAttrib = gen;
    }

    public void setOperator(String oper) {
        this.operatorAttrib = oper;
    }

    public void setTruncated(boolean t) {
        this.truncated = t ? "true" : "false";
    }

    public void setErrno(int errno) {
        this.setErrno(0, errno);
    }

    public void setErrno(int errno, int index) {
        if (index >= 0) {
            Result r;
            if (index > this.results.size()) {
                this.results.setSize(index + 1);
                r = new Result();
                this.results.setElementAt(r, index);
            }
            r = (Result)this.results.elementAt(index);
            r.setErrno(new Integer(errno).toString());
        }
    }

    public void setErrCode(String errCode) {
        this.setErrCode(errCode, 0);
    }

    public void setErrCode(String errCode, int index) {
        if (index >= 0) {
            ErrInfo ei;
            Result r;
            if (index > this.results.size()) {
                this.results.setSize(index + 1);
                r = new Result();
                ei = new ErrInfo();
                r.setErrInfo(ei);
                this.results.setElementAt(r, index);
            }
            if ((ei = (r = (Result)this.results.elementAt(index)).getErrInfo()) == null) {
                ei = new ErrInfo();
            }
            ei.setErrCode(errCode);
            r.setErrInfo(ei);
        }
    }

    public void setErrInfoText(String errInfoText) {
        this.setErrInfoText(errInfoText, 0);
    }

    public void setErrInfoText(String errInfoText, int index) {
        if (index >= 0) {
            ErrInfo ei;
            Result r;
            if (index > this.results.size()) {
                this.results.setSize(index + 1);
                r = new Result();
                ei = new ErrInfo();
                r.setErrInfo(ei);
                this.results.setElementAt(r, index);
            }
            if ((ei = (r = (Result)this.results.elementAt(index)).getErrInfo()) == null) {
                ei = new ErrInfo();
            }
            ei.setText(errInfoText);
            r.setErrInfo(ei);
        }
    }

    public void setKeyType(String keyType) {
        this.setKeyType(keyType, 0);
    }

    public void setKeyType(String keyType, int index) {
        if (index >= 0) {
            Result r;
            if (index > this.results.size()) {
                this.results.setSize(index + 1);
                r = new Result();
                this.results.setElementAt(r, index);
            }
            r = (Result)this.results.elementAt(index);
            r.setKeyType(keyType);
        }
    }

    public void setResultVector(Vector rv) {
        this.results = rv != null ? rv : new Vector();
    }

    public boolean isValidElement(Element el) {
        return el.getNodeName().equals(UDDI_TAG);
    }

    public void saveToXML(Element parent) {
        this.base = parent.getOwnerDocument().createElement(UDDI_TAG);
        if (this.genericAttrib != null) {
            this.base.setAttribute("generic", this.genericAttrib);
        }
        this.base.setAttribute("xmlns", UDDIElement.XMLNS);
        if (this.operatorAttrib != null) {
            this.base.setAttribute("operator", this.operatorAttrib);
        }
        if (this.truncated != null) {
            this.base.setAttribute("truncated", this.truncated);
        }
        for (int i = 0; i < this.results.size(); ++i) {
            Result r = (Result)this.results.elementAt(i);
            if (r == null) continue;
            r.saveToXML(this.base);
        }
        parent.appendChild(this.base);
    }
}

