/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.wst.css.core.internal.CSSCoreMessages;
import org.eclipse.wst.css.core.internal.document.AbstractCSSNodeList;
import org.eclipse.wst.css.core.internal.document.CSSCharsetRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSDocumentImpl;
import org.eclipse.wst.css.core.internal.document.CSSFontFaceRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSImportRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSMediaRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSModelParser;
import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSPageRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSRuleListImpl;
import org.eclipse.wst.css.core.internal.document.CSSStyleDeclarationImpl;
import org.eclipse.wst.css.core.internal.document.CSSStyleRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSUnknownRuleImpl;
import org.eclipse.wst.css.core.internal.document.MediaListImpl;
import org.eclipse.wst.css.core.internal.encoding.CSSDocumentLoader;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSCharsetRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSImportRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSMediaRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPageRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.core.internal.util.ImportRuleCollector;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSUnknownRule;
import org.w3c.dom.stylesheets.MediaList;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

class CSSStyleSheetImpl
extends CSSDocumentImpl
implements ICSSStyleSheet {
    private boolean fDisabled = false;

    CSSStyleSheetImpl() {
        this.setOwnerDocument(this);
    }

    CSSStyleSheetImpl(CSSStyleSheetImpl that) {
        super(that);
        this.setOwnerDocument(this);
    }

    public CSSRule appendRule(CSSRule rule) throws DOMException {
        if (rule == null) {
            return null;
        }
        CSSRule ret = (CSSRule)((Object)this.appendChild((CSSNodeImpl)((Object)rule)));
        return ret;
    }

    public ICSSNode cloneNode(boolean deep) {
        CSSStyleSheetImpl cloned = new CSSStyleSheetImpl(this);
        if (deep) {
            this.cloneChildNodes(cloned, deep);
        }
        return cloned;
    }

    public ICSSCharsetRule createCSSCharsetRule() {
        CSSCharsetRuleImpl rule = new CSSCharsetRuleImpl();
        rule.setOwnerDocument(this);
        return rule;
    }

    public CSSFontFaceRule createCSSFontFaceRule() {
        CSSFontFaceRuleImpl rule = new CSSFontFaceRuleImpl();
        CSSStyleDeclarationImpl style = (CSSStyleDeclarationImpl)this.createCSSStyleDeclaration();
        rule.appendChild(style);
        rule.setOwnerDocument(this);
        return rule;
    }

    public ICSSImportRule createCSSImportRule() {
        CSSImportRuleImpl rule = new CSSImportRuleImpl();
        MediaListImpl media = (MediaListImpl)this.createMediaList();
        rule.appendChild(media);
        rule.setOwnerDocument(this);
        return rule;
    }

    public ICSSMediaRule createCSSMediaRule() {
        CSSMediaRuleImpl rule = new CSSMediaRuleImpl();
        MediaListImpl media = (MediaListImpl)this.createMediaList();
        rule.insertBefore(media, (CSSNodeImpl)rule.getFirstChild());
        rule.setOwnerDocument(this);
        return rule;
    }

    public ICSSPageRule createCSSPageRule() {
        CSSPageRuleImpl rule = new CSSPageRuleImpl();
        CSSStyleDeclarationImpl style = (CSSStyleDeclarationImpl)this.createCSSStyleDeclaration();
        rule.appendChild(style);
        rule.setOwnerDocument(this);
        return rule;
    }

    public CSSRule createCSSRule(String rule) {
        CSSDocumentLoader loader = new CSSDocumentLoader();
        IStructuredDocument structuredDocument = (IStructuredDocument)loader.createNewStructuredDocument();
        structuredDocument.set(rule);
        CSSModelParser modelParser = new CSSModelParser((CSSDocumentImpl)this.getOwnerDocument());
        return modelParser.createCSSRule(structuredDocument.getRegionList());
    }

    public ICSSStyleDeclaration createCSSStyleDeclaration() {
        CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(false);
        decl.setOwnerDocument(this);
        return decl;
    }

    public ICSSStyleRule createCSSStyleRule() {
        CSSStyleRuleImpl rule = new CSSStyleRuleImpl();
        CSSStyleDeclarationImpl style = (CSSStyleDeclarationImpl)this.createCSSStyleDeclaration();
        rule.appendChild(style);
        rule.setOwnerDocument(this);
        return rule;
    }

    public CSSUnknownRule createCSSUnknownRule() {
        CSSUnknownRuleImpl rule = new CSSUnknownRuleImpl();
        rule.setOwnerDocument(this);
        return rule;
    }

    public MediaList createMediaList() {
        MediaListImpl media = new MediaListImpl();
        media.setOwnerDocument(this);
        return media;
    }

    public void deleteRule(int index) throws DOMException {
        CSSRuleImpl node = this.getIndexedRule(index);
        if (node != null) {
            this.removeChild(node);
        }
    }

    public CSSRuleList getCssRules() {
        CSSRuleListImpl list = new CSSRuleListImpl();
        ICSSNode node = this.getFirstChild();
        while (node != null) {
            if (node instanceof CSSRule) {
                list.appendNode(node);
            }
            node = node.getNextSibling();
        }
        return list;
    }

    public boolean getDisabled() {
        return this.fDisabled;
    }

    public String getHref() {
        ICSSModel model = this.getModel();
        if (model != null && model.getStyleSheetType() == "externalCSS") {
            return model.getBaseLocation();
        }
        return null;
    }

    CSSRuleImpl getIndexedRule(int index) {
        if (index < 0) {
            return null;
        }
        int i = 0;
        ICSSNode node = this.getFirstChild();
        while (node != null) {
            if (node instanceof CSSRule && i++ == index) {
                return (CSSRuleImpl)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public MediaList getMedia() {
        return null;
    }

    public short getNodeType() {
        return 7;
    }

    public Node getOwnerNode() {
        ICSSModel model = this.getModel();
        if (model != null) {
            return model.getOwnerDOMNode();
        }
        return null;
    }

    public NodeList getOwnerNodes() {
        Vector list;
        Vector vector = list = this.getModel().getStyleListeners() != null ? new Vector(this.getModel().getStyleListeners()) : null;
        if (list == null) {
            return null;
        }
        InternalNodeList nodes = new InternalNodeList();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof IStyleSheetAdapter)) continue;
            nodes.nodes.add(((IStyleSheetAdapter)obj).getElement());
        }
        if (nodes.getLength() > 0) {
            return nodes;
        }
        return null;
    }

    public NodeList getOwnerNodes(Document doc) {
        Vector list;
        Vector vector = list = this.getModel().getStyleListeners() != null ? new Vector(this.getModel().getStyleListeners()) : null;
        if (list == null) {
            return null;
        }
        InternalNodeList nodes = new InternalNodeList();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Element ele;
            Object obj = it.next();
            if (!(obj instanceof IStyleSheetAdapter) || (ele = ((IStyleSheetAdapter)obj).getElement()).getOwnerDocument() != doc) continue;
            nodes.nodes.add(ele);
        }
        if (nodes.getLength() > 0) {
            return nodes;
        }
        return null;
    }

    public CSSRule getOwnerRule() {
        Assert.isTrue((boolean)false, (String)CSSCoreMessages.You_cannot_use_CSSStyleShe_UI_);
        return null;
    }

    public CSSRuleList getOwnerRules() {
        StyleSheetList list = this.getParentStyleSheets();
        if (list == null) {
            return null;
        }
        CSSRuleListImpl ruleList = new CSSRuleListImpl();
        int i = 0;
        while (i < list.getLength()) {
            ImportRuleCollector trav = new ImportRuleCollector(this);
            trav.apply((ICSSStyleSheet)list.item(i));
            ruleList.nodes.addAll(trav.getRules());
            ++i;
        }
        return ruleList;
    }

    public StyleSheet getParentStyleSheet() {
        CSSRule owner = this.getOwnerRule();
        if (owner != null) {
            return owner.getParentStyleSheet();
        }
        return null;
    }

    public StyleSheetList getParentStyleSheets() {
        Vector list;
        Vector vector = list = this.getModel().getStyleListeners() != null ? new Vector(this.getModel().getStyleListeners()) : null;
        if (list == null) {
            return null;
        }
        InternalStyleSheetList sheets = new InternalStyleSheetList();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof ICSSModel)) continue;
            sheets.appendNode(((ICSSModel)obj).getDocument());
        }
        if (sheets.getLength() > 0) {
            return sheets;
        }
        return null;
    }

    public String getTitle() {
        Node node = this.getOwnerNode();
        if (node instanceof Element) {
            return ((Element)node).getAttribute("TITLE");
        }
        return null;
    }

    public String getType() {
        Node node = this.getOwnerNode();
        if (node instanceof Element) {
            return ((Element)node).getAttribute("TYPE");
        }
        return null;
    }

    public int insertRule(String rule, int index) throws DOMException {
        int length = this.getCssRules().getLength();
        if (index < 0 || length < index) {
            throw new DOMException(1, "");
        }
        IStructuredDocument doc = this.getModel().getStructuredDocument();
        CSSRuleImpl refRule = length != index ? this.getIndexedRule(index) : null;
        int offset = refRule != null ? refRule.getStartOffset() : doc.getLength();
        doc.replaceText((Object)this, offset, 0, rule);
        return index;
    }

    public CSSRule insertRuleBefore(CSSRule newRule, CSSRule refRule) throws DOMException {
        if (newRule == null && refRule == null) {
            return null;
        }
        CSSRule ret = (CSSRule)((Object)this.insertBefore((CSSNodeImpl)((Object)newRule), (CSSNodeImpl)((Object)refRule)));
        return ret;
    }

    public boolean isDocument() {
        return true;
    }

    public CSSRule removeRule(CSSRule rule) throws DOMException {
        if (rule == null) {
            return null;
        }
        CSSRule ret = (CSSRule)((Object)this.removeChild((CSSNodeImpl)((Object)rule)));
        return ret;
    }

    public CSSRule replaceRule(CSSRule newRule, CSSRule oldRule) throws DOMException {
        if (newRule == null && oldRule == null) {
            return null;
        }
        CSSRule ret = (CSSRule)((Object)this.replaceChild((CSSNodeImpl)((Object)newRule), (CSSNodeImpl)((Object)oldRule)));
        return ret;
    }

    public void setDisabled(boolean disabled) {
        this.fDisabled = disabled;
    }

    class InternalNodeList
    implements NodeList {
        Vector nodes = new Vector();

        InternalNodeList() {
        }

        public int getLength() {
            if (this.nodes == null) {
                return 0;
            }
            return this.nodes.size();
        }

        public Node item(int i) {
            if (this.nodes == null) {
                return null;
            }
            if (i < 0 || this.nodes.size() <= i) {
                return null;
            }
            return (Node)this.nodes.get(i);
        }
    }

    class InternalStyleSheetList
    extends AbstractCSSNodeList
    implements StyleSheetList {
        InternalStyleSheetList() {
        }

        public ICSSNode appendNode(ICSSNode node) {
            if (this.nodes == null || !this.nodes.contains(node)) {
                return super.appendNode(node);
            }
            return node;
        }

        public StyleSheet item(int i) {
            return (StyleSheet)((Object)this.itemImpl(i));
        }
    }
}

