/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.tests.encoding.jsp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.contenttype.JSPResourceEncodingDetector;
import org.eclipse.jst.jsp.tests.encoding.JSPEncodingTestsPlugin;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;

public class JSPEncodingTests
extends TestCase {
    private boolean DEBUG = false;
    private final String fileDir = "jsp/";
    private final String fileHome = "testfiles/";
    private final String fileLocation = "testfiles/jsp/";
    private int READ_BUFFER_SIZE = 8000;

    private static InputStream getMarkSupportedStream(InputStream original) {
        if (original == null) {
            return null;
        }
        if (original.markSupported()) {
            return original;
        }
        return new BufferedInputStream(original);
    }

    public JSPEncodingTests(String name) {
        super(name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doTestFileStream(String filename, String expectedIANAEncoding, IResourceCharsetDetector detector) throws IOException {
        FileInputStream inputStream;
        block5: {
            File file = JSPEncodingTestsPlugin.getTestFile(filename);
            if (!file.exists()) {
                throw new IllegalArgumentException(String.valueOf(filename) + " was not found");
            }
            inputStream = new FileInputStream(file);
            InputStream istream = JSPEncodingTests.getMarkSupportedStream(inputStream);
            try {
                detector.set(istream);
                EncodingMemento encodingMemento = ((JSPResourceEncodingDetector)detector).getEncodingMemento();
                String foundIANAEncoding = encodingMemento.getJavaCharsetName();
                boolean expectedIANAResult = false;
                expectedIANAResult = expectedIANAEncoding.equalsIgnoreCase(foundIANAEncoding);
                JSPEncodingTests.assertTrue((String)("encoding test file " + filename + " expected: " + expectedIANAEncoding + " found: " + foundIANAEncoding), (boolean)expectedIANAResult);
                this.ensureCanRead(filename, foundIANAEncoding, istream);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (istream != null) {
                    istream.close();
                }
                if (inputStream == null) throw throwable;
                ((InputStream)inputStream).close();
                throw throwable;
            }
            {
                Object var10_12 = null;
                if (istream == null) break block5;
            }
            istream.close();
        }
        if (inputStream == null) return;
        ((InputStream)inputStream).close();
    }

    private void ensureCanRead(String filename, String encoding, InputStream inStream) throws IOException {
        Charset charset = Charset.forName(encoding);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        InputStreamReader reader = new InputStreamReader(inStream, charsetDecoder);
        StringBuffer stringBuffer = this.readInputStream(reader);
        if (this.DEBUG) {
            System.out.println();
            System.out.println(filename);
            System.out.println(stringBuffer.toString());
        }
    }

    private StringBuffer readInputStream(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int numRead = 0;
        char[] tBuff = new char[this.READ_BUFFER_SIZE];
        while ((numRead = reader.read(tBuff, 0, tBuff.length)) != -1) {
            buffer.append(tBuff, 0, numRead);
        }
        return buffer;
    }

    public void testdefect4205wpsjsp() throws IOException {
        String filename = "testfiles/jsp/defect_4205_wps.jsp";
        this.doTestFileStream(filename, "UTF-8", (IResourceCharsetDetector)new JSPResourceEncodingDetector());
    }

    public void testJSPEmptyFile() throws IOException {
        String filename = "testfiles/jsp/EmptyFile.jsp";
        this.doTestFileStream(filename, "ISO-8859-1", (IResourceCharsetDetector)new JSPResourceEncodingDetector());
    }

    public void testUTF16() throws IOException {
        String filename = "testfiles/jsp/testUTF16.jsp";
        this.doTestFileStream(filename, "UTF-16BE", (IResourceCharsetDetector)new JSPResourceEncodingDetector());
    }

    public void testUtf16UnicodeStreamWithNoEncodingInHeader() throws IOException {
        String filename = "testfiles/jsp/utf16UnicodeStreamWithNoEncodingInHeader2.jsp";
        this.doTestFileStream(filename, "UTF-16", (IResourceCharsetDetector)new JSPResourceEncodingDetector());
    }

    public void testUtf16UnicodeStreamWithNoEncodingInHeaderBE() throws IOException {
        String filename = "testfiles/jsp/utf16UnicodeStreamWithNoEncodingInHeaderBE.jsp";
        this.doTestFileStream(filename, "UTF-16BE", (IResourceCharsetDetector)new JSPResourceEncodingDetector());
    }

    public void testUTF16WithJapaneseChars() throws IOException {
        String filename = "testfiles/jsp/utf16WithJapaneseChars.jsp";
        this.doTestFileStream(filename, "UTF-16BE", (IResourceCharsetDetector)new JSPResourceEncodingDetector());
    }

    public void testUTF83ByteBOM() throws IOException {
        String filename = "testfiles/jsp/UTF8With3ByteBOM.jsp";
        this.doTestFileStream(filename, "UTF-8", (IResourceCharsetDetector)new JSPResourceEncodingDetector());
    }

    public void testXMLIllformedNormalNonDefault() throws IOException {
        String filename = "testfiles/jsp/IllformedNormalNonDefault.jsp";
        String ianaInFile = "ISO-8859-8";
        this.doTestFileStream(filename, ianaInFile, (IResourceCharsetDetector)new JSPResourceEncodingDetector());
    }

    public void testXMLNoEncoding() throws IOException {
        String filename = "testfiles/jsp/noEncoding.jsp";
        this.doTestFileStream(filename, "ISO-8859-1", (IResourceCharsetDetector)new JSPResourceEncodingDetector());
    }

    public void testXMLNormalNonDefault() throws IOException {
        String filename = "testfiles/jsp/NormalNonDefault.jsp";
        String ianaInFile = "ISO-8859-8";
        this.doTestFileStream(filename, ianaInFile, (IResourceCharsetDetector)new JSPResourceEncodingDetector());
    }
}

