/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.ParseException;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.jst.jsp.core.internal.java.jspel.TokenMgrError;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSPELValidator
implements IValidator {
    static boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    protected void validateRegionContainer(ITextRegionCollection container, IReporter reporter, IFile file) {
        ITextRegionCollection containerRegion = container;
        Iterator regions = containerRegion.getRegions().iterator();
        ITextRegion region = null;
        while (regions.hasNext() && !reporter.isCancelled()) {
            region = (ITextRegion)regions.next();
            String type = region.getType();
            if (type == null || !(region instanceof ITextRegionCollection)) continue;
            ITextRegionCollection parentRegion = (ITextRegionCollection)region;
            Iterator childRegions = parentRegion.getRegions().iterator();
            while (childRegions.hasNext() && !reporter.isCancelled()) {
                ITextRegion childRegion = (ITextRegion)childRegions.next();
                if (childRegion.getType() != "JSP_EL_CONTENT") continue;
                this.validateXMLNode(parentRegion, childRegion, reporter, file);
            }
        }
    }

    protected void validateXMLNode(ITextRegionCollection container, ITextRegion region, IReporter reporter, IFile file) {
        String elText = container.getText(region);
        JSPELParser elParser = JSPELParser.createParser(elText);
        int contentStart = container.getStartOffset(region);
        int contentLength = container.getLength();
        try {
            elParser.Expression();
        }
        catch (ParseException e) {
            Token curTok = e.currentToken;
            int problemStartOffset = contentStart + curTok.beginColumn;
            LocalizedMessage message = new LocalizedMessage(4, JSPCoreMessages.JSPEL_Syntax);
            message.setOffset(problemStartOffset);
            message.setLength(curTok.endColumn - curTok.beginColumn + 1);
            message.setTargetObject((Object)file);
            reporter.addMessage((IValidator)this, (IMessage)message);
        }
        catch (TokenMgrError tokenMgrError) {
            LocalizedMessage message = new LocalizedMessage(4, JSPCoreMessages.JSPEL_Token);
            message.setOffset(contentStart);
            message.setLength(contentLength);
            message.setTargetObject((Object)file);
            reporter.addMessage((IValidator)this, (IMessage)message);
        }
    }

    public void cleanup(IReporter reporter) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        block9: {
            String[] uris = helper.getURIs();
            reporter.removeAllMessages((IValidator)this);
            if (uris == null) break block9;
            int i = 0;
            while (i < uris.length && !reporter.isCancelled()) {
                block8: {
                    Object var10_10;
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uris[i]));
                    if (!JSPELValidator.shouldValidate(file)) break block8;
                    IStructuredModel model = null;
                    try {
                        try {
                            model = StructuredModelManager.getModelManager().getModelForRead(file);
                            DOMModelForJSP jspModel = (DOMModelForJSP)model;
                            IStructuredDocument structuredDoc = jspModel.getStructuredDocument();
                            IStructuredDocumentRegion curNode = structuredDoc.getFirstStructuredDocumentRegion();
                            while ((curNode = curNode.getNext()) != null && !reporter.isCancelled()) {
                                if (curNode.getType() == "XML_COMMENT_TEXT" || curNode.getType() == "XML_CDATA_TEXT" || curNode.getType() == "UNDEFINED") continue;
                                this.validateRegionContainer((ITextRegionCollection)curNode, reporter, file);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (Throwable throwable) {
                        var10_10 = null;
                        if (model != null) {
                            model.releaseFromRead();
                        }
                        throw throwable;
                    }
                    {
                        var10_10 = null;
                        if (model == null) break block8;
                    }
                    model.releaseFromRead();
                }
                ++i;
            }
        }
    }
}

