/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.command;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.plugin.JavaEMFNature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.impl.JavaClassImpl;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class JavaToWSDLMethodCommand
extends SimpleCommand {
    private static String LABEL = "TASK_LABEL_JAVA_TO_WSDL";
    private static String DESCRIPTION = "TASK_DESC_JAVA_TO_WSDL";
    private static String JAVA_EXTENSION = ".java";
    private static String CLASS_EXTENSION = ".class";
    private Hashtable fMethodNames;
    private String fClassName;
    private String fBeanName;
    private String fbeanBaseName;
    private IProject fProject;
    private JavaWSDLParameter javaWSDLParam_;
    private IProject serviceProject_;
    private MessageUtils msgUtils_;

    public JavaToWSDLMethodCommand() {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setName(this.msgUtils_.getMessage(LABEL));
        this.setDescription(this.msgUtils_.getMessage(DESCRIPTION));
    }

    public JavaToWSDLMethodCommand(JavaWSDLParameter javaParameter, IProject serviceProject) {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setName(this.msgUtils_.getMessage(LABEL));
        this.setDescription(this.msgUtils_.getMessage(DESCRIPTION));
        this.javaWSDLParam_ = javaParameter;
        this.serviceProject_ = serviceProject;
    }

    public Status execute(Environment environment) {
        this.fbeanBaseName = this.javaWSDLParam_.getBeanName();
        environment.getLog().log(1, 5070, (Object)this, "execute", (Object)("beanBaseName = " + this.fbeanBaseName));
        try {
            JavaEMFNature jMOF;
            JavaClass javaClass;
            this.fMethodNames = new Hashtable();
            Hashtable oldMethodsNames = this.javaWSDLParam_.getMethods();
            String qName = this.fbeanBaseName;
            if (qName.toLowerCase().endsWith(JAVA_EXTENSION) || qName.toLowerCase().endsWith(CLASS_EXTENSION)) {
                qName = qName.substring(0, qName.lastIndexOf(46));
            }
            if (!(javaClass = (JavaClass)JavaClassImpl.reflect((String)qName, (ResourceSet)(jMOF = JavaEMFNature.createRuntime((IProject)this.serviceProject_)).getResourceSet())).isExistingType()) {
                environment.getLog().log(4, 5022, (Object)this, "execute", (Object)this.msgUtils_.getMessage("MSG_ERROR_JAVA_MOF_REFLECT_FAILED", (Object[])new String[]{qName}));
                SimpleStatus status = new SimpleStatus("JavaToWSDLMethodCommand", this.msgUtils_.getMessage("MSG_ERROR_JAVA_MOF_REFLECT_FAILED", (Object[])new String[]{qName}), 4);
                environment.getStatusHandler().reportError((Status)status);
                return status;
            }
            this.fBeanName = this.fClassName = javaClass.getQualifiedName();
            String beanName = this.fClassName.lastIndexOf(46) != -1 ? this.fClassName.substring(this.fClassName.lastIndexOf(46) + 1, this.fClassName.length()) : this.fClassName;
            this.gatherMethods(javaClass, beanName, oldMethodsNames);
            this.javaWSDLParam_.setMethods(this.fMethodNames);
            return new SimpleStatus("");
        }
        catch (Exception e) {
            environment.getLog().log(4, 5023, (Object)this, "execute", (Object)this.msgUtils_.getMessage("MSG_ERROR_READ_BEAN"));
            SimpleStatus status = new SimpleStatus("JavaToWSDLMethodCommand", this.msgUtils_.getMessage("MSG_ERROR_JAVA_TO_METHOD"), 4, (Throwable)e);
            environment.getStatusHandler().reportError((Status)status);
            return status;
        }
    }

    private void gatherMethods(JavaClass javaClass, String beanName, Hashtable oldMethodsNames) {
        String javaName = javaClass.getJavaName();
        if (!(javaClass.isInterface() || javaName.equalsIgnoreCase("javax.ejb.EJBObject[]") || javaName.equalsIgnoreCase("javax.ejb.EJBObject") || javaName.equalsIgnoreCase("java.lang.Object[]") || javaName.equalsIgnoreCase("java.lang.Object"))) {
            List publicMethods = javaClass.getPublicMethods();
            Iterator it = publicMethods.iterator();
            while (it.hasNext()) {
                Method method = (Method)it.next();
                if (method.isConstructor() || beanName.equals(method.getName()) || this.isDuplicateMethodName(method.getMethodElementSignature())) continue;
                String methodName = method.getMethodElementSignature();
                Boolean isSelected = new Boolean(true);
                if (oldMethodsNames != null && oldMethodsNames.containsKey(methodName)) {
                    isSelected = (Boolean)oldMethodsNames.get(methodName);
                }
                this.fMethodNames.put(methodName, isSelected);
            }
            this.gatherMethods(javaClass.getSupertype(), beanName, oldMethodsNames);
        }
    }

    private boolean isDuplicateMethodName(String methodName) {
        return this.fMethodNames == null ? false : this.fMethodNames.containsKey(methodName);
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject_ = serviceProject;
    }
}

