/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.tests;

import java.util.List;
import junit.framework.Test;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatConfigurationWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.tests.OrderedTestSuite;
import org.eclipse.jst.server.tomcat.core.tests.RuntimeLocation;
import org.eclipse.jst.server.tomcat.core.tests.module.ModuleTestCase;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.tests.ext.AbstractServerTestCase;

public abstract class AbstractTomcatServerTestCase
extends AbstractServerTestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.tests.AbstractTomcatServerTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new OrderedTestSuite(clazz, "TomcatServerTestCase");
    }

    protected abstract String getServerTypeId();

    public IServer createServer() throws Exception {
        try {
            IServerWorkingCopy wc = this.createServer(this.getServerTypeId());
            return wc.save(true, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void deleteServer(IServer server2) throws Exception {
        server2.getRuntime().delete();
        server2.delete();
    }

    protected IRuntime createRuntime() {
        try {
            IServerType st = ServerCore.findServerType((String)this.getServerTypeId());
            IRuntimeWorkingCopy wc = this.createRuntime(st.getRuntimeType());
            return wc.save(true, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IRuntimeWorkingCopy createRuntime(IRuntimeType rt) throws Exception {
        IRuntimeWorkingCopy wc = rt.createRuntime(null, null);
        wc.setLocation((IPath)new Path(RuntimeLocation.runtimeLocation));
        return wc;
    }

    protected IServerWorkingCopy createServer(String serverTypeId) throws Exception {
        List portsList;
        IServerType st = ServerCore.findServerType((String)serverTypeId);
        IRuntime runtime = this.createRuntime();
        IServerWorkingCopy wc = st.createServer(null, null, runtime, null);
        ServerPort[] ports = wc.getServerPorts(null);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TomcatServer tomcatServer = (TomcatServer)wc.getAdapter((Class)clazz);
        ITomcatConfigurationWorkingCopy configuration = (ITomcatConfigurationWorkingCopy)tomcatServer.getServerConfiguration();
        if ((ports == null || ports.length == 0) && (portsList = configuration.getServerPorts()) != null && portsList.size() > 0) {
            ports = portsList.toArray(new ServerPort[portsList.size()]);
        }
        if (ports != null) {
            int size = ports.length;
            int i = 0;
            while (i < size) {
                configuration.modifyServerPort(ports[i].getId(), 22100 + i);
                ++i;
            }
        }
        return wc;
    }

    public void test0100CanAddModule() {
        IModule webModule = ModuleTestCase.webModule;
        IStatus status = server.canModifyModules(new IModule[]{webModule}, null, null);
        AbstractTomcatServerTestCase.assertTrue((boolean)status.isOK());
    }

    public void test0101HasModule() {
        IModule webModule = ModuleTestCase.webModule;
        IModule[] modules = server.getModules();
        int size = modules.length;
        boolean found = false;
        int i = 0;
        while (i < size) {
            if (webModule.equals(modules[i])) {
                found = true;
            }
            ++i;
        }
        if (found) {
            AbstractTomcatServerTestCase.assertTrue((boolean)false);
        }
    }

    public void test0102AddModule() throws Exception {
        IModule webModule = ModuleTestCase.webModule;
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.modifyModules(new IModule[]{webModule}, null, null);
        wc.save(true, null);
    }

    public void test0103HasModule() {
        IModule webModule = ModuleTestCase.webModule;
        IModule[] modules = server.getModules();
        int size = modules.length;
        boolean found = false;
        int i = 0;
        while (i < size) {
            if (webModule.equals(modules[i])) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            AbstractTomcatServerTestCase.assertTrue((boolean)false);
        }
    }

    public void test0104DeleteModule() throws Exception {
        IModule webModule = ModuleTestCase.webModule;
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.modifyModules(null, new IModule[]{webModule}, null);
        wc.save(true, null);
    }

    public void test0105HasModule() {
        IModule webModule = ModuleTestCase.webModule;
        IModule[] modules = server.getModules();
        int size = modules.length;
        boolean found = false;
        int i = 0;
        while (i < size) {
            if (webModule.equals(modules[i])) {
                found = true;
            }
            ++i;
        }
        if (found) {
            AbstractTomcatServerTestCase.assertTrue((boolean)false);
        }
    }
}

