/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.tests.module;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentCreationDataModelProvider;
import org.eclipse.jst.server.tomcat.core.tests.OrderedTestSuite;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class ModuleTestCase
extends TestCase {
    protected static final String WEB_MODULE_NAME = "MyWeb";
    public static IModule webModule;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.tests.TomcatRuntimeTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new OrderedTestSuite(clazz, "ModuleTestCase");
    }

    public void test01CreateWebModule() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentCreationDataModelProvider());
        dataModel.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)WEB_MODULE_NAME);
        dataModel.setBooleanProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", false);
        dataModel.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", 22);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        dataModel.dispose();
    }

    public void test02CreateWebContent() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(WEB_MODULE_NAME);
        IFile file = project.getFile(new Path("WebContent").append("test.html"));
        String content = "Hello!";
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
        file.create((InputStream)in, true, null);
    }

    public void test04GetModule() throws Exception {
        ResourcesPlugin.getWorkspace().build(6, null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(WEB_MODULE_NAME);
        IModule[] modules = ServerUtil.getModules((IProject)project);
        if (modules == null || modules.length != 1) {
            throw new Exception("Wrong number of modules in Web project");
        }
        webModule = modules[0];
    }
}

