/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class CSSCorePreferencesTest
extends TestCase {
    public void testBundleGetPreferences() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.xml.core");
        try {
            if (bundle != null) {
                bundle.start();
            } else {
                CSSCorePreferencesTest.fail((String)"Get preference value failed because could not find bundle: org.eclipse.wst.xml.core");
            }
        }
        catch (BundleException e) {
            CSSCorePreferencesTest.fail((String)("Get preference value failed because of exception starting bundle: org.eclipse.wst.xml.core exception: " + (Object)((Object)e)));
        }
        this.bundleGetPreference("org.eclipse.wst.xml.core", "indentationSize");
        this.bundleGetPreference("org.eclipse.wst.xml.core", "lineWidth");
    }

    private void bundleGetPreference(String bundleName, String prefKey) {
        int defaultValue = -1;
        int value = Platform.getPreferencesService().getInt(bundleName, prefKey, defaultValue, null);
        CSSCorePreferencesTest.assertTrue((String)("Get preference value failed using Platform.getPreferencesService. Key: " + prefKey), (defaultValue != value ? 1 : 0) != 0);
    }

    public void testPluginGetDefaultPreferences() {
        IEclipsePreferences node = new DefaultScope().getNode(CSSCorePlugin.getDefault().getBundle().getSymbolicName());
        this.pluginGetDefaultPreference(node, "identifierCase", "2");
        this.pluginGetDefaultPreference(node, "indentationChar", "tab");
    }

    private void pluginGetDefaultPreference(IEclipsePreferences node, String prefKey, String expected) {
        String defaultValue = Long.toString(System.currentTimeMillis());
        String theDefaultValue = node.get(prefKey, defaultValue);
        CSSCorePreferencesTest.assertEquals((String)("Get default preference value failed using plugin.getPreferenceStore. Key: " + prefKey), (String)expected, (String)theDefaultValue);
    }

    public void testPluginSetPreferences() {
        IEclipsePreferences node = new InstanceScope().getNode(CSSCorePlugin.getDefault().getBundle().getSymbolicName());
        this.pluginSetPreferenceBoolean(node, "onePropertyPerLine");
        this.pluginSetPreferenceInt(node, "propNameCase");
    }

    private void pluginSetPreferenceBoolean(IEclipsePreferences node, String prefKey) {
        boolean originalValue = false;
        boolean expectedValue = true;
        String originalString = node.get(prefKey, "bogus");
        if (!"bogus".equals(originalString)) {
            originalValue = Boolean.valueOf(originalString);
            expectedValue = !originalValue;
        }
        node.putBoolean(prefKey, expectedValue);
        boolean foundValue = node.getBoolean(prefKey, true);
        CSSCorePreferencesTest.assertEquals((String)("Set preference value failed using plugin.getPreferenceStore. Key: " + prefKey + "  expected: " + expectedValue + " found: " + foundValue), (boolean)expectedValue, (boolean)foundValue);
        if ("bogus".equals(originalString)) {
            node.remove(prefKey);
        } else {
            node.put(prefKey, originalString);
        }
    }

    private void pluginSetPreferenceInt(IEclipsePreferences node, String prefKey) {
        int originalValue = node.getInt(prefKey, -999);
        int expectedValue = -888;
        node.putInt(prefKey, expectedValue);
        int foundValue = node.getInt(prefKey, -999);
        CSSCorePreferencesTest.assertEquals((String)("Set preference value failed using plugin.getPreferenceStore. Key: " + prefKey + "  expected: " + expectedValue + " found: " + foundValue), (int)expectedValue, (int)foundValue);
        if (originalValue == -999) {
            node.remove(prefKey);
        } else {
            node.putInt(prefKey, originalValue);
        }
    }
}

