/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.model;

import java.io.IOException;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.core.tests.model.AbstractModelTest;
import org.eclipse.wst.css.core.tests.util.FileUtil;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class CSSFontFaceRuleTest
extends AbstractModelTest {
    public void testInsertRule() {
        ICSSStyleSheet sheet = this.getStyleSheet();
        CSSFontFaceRuleTest.assertEquals((int)0, (int)sheet.insertRule("@font-face { font-family: \"Swiss 721\"; src: url(swiss721.pfr); /* The expanded Swiss 721 */ font-stretch: expanded; }", 0));
        CSSRuleList ruleList = sheet.getCssRules();
        CSSRule rule = ruleList.item(0);
        CSSFontFaceRuleTest.assertTrue((boolean)(rule instanceof CSSFontFaceRule));
        CSSStyleDeclaration declaration = ((CSSFontFaceRule)rule).getStyle();
        CSSFontFaceRuleTest.assertEquals((int)3, (int)declaration.getLength());
        CSSValue value = declaration.getPropertyCSSValue("font-family");
        CSSFontFaceRuleTest.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        CSSPrimitiveValue primitiveValue = (CSSPrimitiveValue)value;
        CSSFontFaceRuleTest.assertEquals((short)19, (short)primitiveValue.getPrimitiveType());
        CSSFontFaceRuleTest.assertEquals((String)"Swiss 721", (String)primitiveValue.getStringValue());
        value = declaration.getPropertyCSSValue("src");
        CSSFontFaceRuleTest.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        primitiveValue = (CSSPrimitiveValue)value;
        CSSFontFaceRuleTest.assertEquals((short)20, (short)primitiveValue.getPrimitiveType());
        CSSFontFaceRuleTest.assertEquals((String)"swiss721.pfr", (String)primitiveValue.getStringValue());
        value = declaration.getPropertyCSSValue("font-stretch");
        CSSFontFaceRuleTest.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        primitiveValue = (CSSPrimitiveValue)value;
        CSSFontFaceRuleTest.assertEquals((short)21, (short)primitiveValue.getPrimitiveType());
        CSSFontFaceRuleTest.assertEquals((String)"expanded", (String)primitiveValue.getStringValue());
    }

    public void testInsertText1() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSFontFaceRuleTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList ruleList = sheet.getCssRules();
        CSSFontFaceRuleTest.assertEquals((int)3, (int)ruleList.getLength());
        CSSRule rule = ruleList.item(0);
        CSSFontFaceRuleTest.assertEquals((short)5, (short)rule.getType());
        CSSFontFaceRuleTest.assertTrue((boolean)(rule instanceof CSSFontFaceRule));
        CSSStyleDeclaration declaration = ((CSSFontFaceRule)rule).getStyle();
        CSSFontFaceRuleTest.assertEquals((int)4, (int)declaration.getLength());
        CSSValue value = declaration.getPropertyCSSValue("font-family");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(19, "Swiss 721"));
        value = declaration.getPropertyCSSValue("src");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(20, "swiss721blk.pfr"));
        value = declaration.getPropertyCSSValue("font-style");
        CSSFontFaceRuleTest.assertTrue((boolean)(value instanceof CSSValueList));
        CSSValueList valueList = (CSSValueList)value;
        CSSFontFaceRuleTest.assertEquals((int)3, (int)valueList.getLength());
        this.checkPrimitiveString(valueList.item(0), new AbstractModelTest.PrimitiveString(21, "normal"));
        this.checkPrimitiveString(valueList.item(1), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveString(valueList.item(2), new AbstractModelTest.PrimitiveString(21, "italic"));
        value = declaration.getPropertyCSSValue("font-weight");
        CSSFontFaceRuleTest.assertTrue((boolean)(value instanceof CSSValueList));
        valueList = (CSSValueList)value;
        CSSFontFaceRuleTest.assertEquals((int)3, (int)valueList.getLength());
        this.checkPrimitiveNumber(valueList.item(0), new AbstractModelTest.PrimitiveNumber(26, 800.0f));
        this.checkPrimitiveString(valueList.item(1), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveNumber(valueList.item(2), new AbstractModelTest.PrimitiveNumber(26, 900.0f));
    }

    public void testInsertText2() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSFontFaceRuleTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList ruleList = sheet.getCssRules();
        CSSFontFaceRuleTest.assertEquals((int)3, (int)ruleList.getLength());
        CSSRule rule = ruleList.item(1);
        CSSFontFaceRuleTest.assertEquals((short)5, (short)rule.getType());
        CSSFontFaceRuleTest.assertTrue((boolean)(rule instanceof CSSFontFaceRule));
        CSSStyleDeclaration declaration = ((CSSFontFaceRule)rule).getStyle();
        CSSFontFaceRuleTest.assertEquals((int)6, (int)declaration.getLength());
        CSSValue value = declaration.getPropertyCSSValue("src");
        CSSFontFaceRuleTest.assertTrue((boolean)(value instanceof CSSValueList));
        CSSValueList valueList = (CSSValueList)value;
        CSSFontFaceRuleTest.assertEquals((int)9, (int)valueList.getLength());
        this.checkPrimitiveString(valueList.item(0), new AbstractModelTest.PrimitiveString(30, "Palatino"));
        this.checkPrimitiveString(valueList.item(1), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveString(valueList.item(2), new AbstractModelTest.PrimitiveString(30, "Times New Roman"));
        this.checkPrimitiveString(valueList.item(3), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveString(valueList.item(4), new AbstractModelTest.PrimitiveString(30, "New York"));
        this.checkPrimitiveString(valueList.item(5), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveString(valueList.item(6), new AbstractModelTest.PrimitiveString(30, "Utopia"));
        this.checkPrimitiveString(valueList.item(7), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveString(valueList.item(8), new AbstractModelTest.PrimitiveString(20, "http://somewhere/free/font"));
        value = declaration.getPropertyCSSValue("font-family");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(21, "serif"));
        value = declaration.getPropertyCSSValue("font-weight");
        CSSFontFaceRuleTest.assertTrue((boolean)(value instanceof CSSValueList));
        valueList = (CSSValueList)value;
        CSSFontFaceRuleTest.assertEquals((int)9, (int)valueList.getLength());
        this.checkPrimitiveNumber(valueList.item(0), new AbstractModelTest.PrimitiveNumber(26, 100.0f));
        this.checkPrimitiveString(valueList.item(1), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveNumber(valueList.item(2), new AbstractModelTest.PrimitiveNumber(26, 200.0f));
        this.checkPrimitiveString(valueList.item(3), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveNumber(valueList.item(4), new AbstractModelTest.PrimitiveNumber(26, 300.0f));
        this.checkPrimitiveString(valueList.item(5), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveNumber(valueList.item(6), new AbstractModelTest.PrimitiveNumber(26, 400.0f));
        this.checkPrimitiveString(valueList.item(7), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveNumber(valueList.item(8), new AbstractModelTest.PrimitiveNumber(26, 500.0f));
        value = declaration.getPropertyCSSValue("font-style");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(21, "normal"));
        value = declaration.getPropertyCSSValue("font-variant");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(21, "normal"));
        value = declaration.getPropertyCSSValue("font-size");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(21, "all"));
    }

    public void testInsertText3() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSFontFaceRuleTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList ruleList = sheet.getCssRules();
        CSSFontFaceRuleTest.assertEquals((int)3, (int)ruleList.getLength());
        CSSRule rule = ruleList.item(2);
        CSSFontFaceRuleTest.assertEquals((short)5, (short)rule.getType());
        CSSFontFaceRuleTest.assertTrue((boolean)(rule instanceof CSSFontFaceRule));
        CSSStyleDeclaration declaration = ((CSSFontFaceRule)rule).getStyle();
        CSSFontFaceRuleTest.assertEquals((int)5, (int)declaration.getLength());
        CSSValue value = declaration.getPropertyCSSValue("src");
        CSSFontFaceRuleTest.assertTrue((boolean)(value instanceof CSSValueList));
        CSSValueList valueList = (CSSValueList)value;
        CSSFontFaceRuleTest.assertEquals((int)4, (int)valueList.getLength());
        this.checkPrimitiveString(valueList.item(0), new AbstractModelTest.PrimitiveString(30, "Alabama Italic"));
        this.checkPrimitiveString(valueList.item(1), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveString(valueList.item(2), new AbstractModelTest.PrimitiveString(20, "http://www.fonts.org/A/alabama-italic"));
        this.checkPrimitiveString(valueList.item(3), new AbstractModelTest.PrimitiveString(29, "truetype"));
        value = declaration.getPropertyCSSValue("panose-1");
        CSSFontFaceRuleTest.assertTrue((boolean)(value instanceof CSSValueList));
        valueList = (CSSValueList)value;
        CSSFontFaceRuleTest.assertEquals((int)10, (int)valueList.getLength());
        this.checkPrimitiveNumber(valueList.item(0), new AbstractModelTest.PrimitiveNumber(26, 2.0f));
        this.checkPrimitiveNumber(valueList.item(1), new AbstractModelTest.PrimitiveNumber(26, 4.0f));
        this.checkPrimitiveNumber(valueList.item(2), new AbstractModelTest.PrimitiveNumber(26, 5.0f));
        this.checkPrimitiveNumber(valueList.item(3), new AbstractModelTest.PrimitiveNumber(26, 2.0f));
        this.checkPrimitiveNumber(valueList.item(4), new AbstractModelTest.PrimitiveNumber(26, 5.0f));
        this.checkPrimitiveNumber(valueList.item(5), new AbstractModelTest.PrimitiveNumber(26, 4.0f));
        this.checkPrimitiveNumber(valueList.item(6), new AbstractModelTest.PrimitiveNumber(26, 5.0f));
        this.checkPrimitiveNumber(valueList.item(7), new AbstractModelTest.PrimitiveNumber(26, 9.0f));
        this.checkPrimitiveNumber(valueList.item(8), new AbstractModelTest.PrimitiveNumber(26, 3.0f));
        this.checkPrimitiveNumber(valueList.item(9), new AbstractModelTest.PrimitiveNumber(26, 3.0f));
        value = declaration.getPropertyCSSValue("font-family");
        CSSFontFaceRuleTest.assertTrue((boolean)(value instanceof CSSValueList));
        valueList = (CSSValueList)value;
        CSSFontFaceRuleTest.assertEquals((int)3, (int)valueList.getLength());
        this.checkPrimitiveString(valueList.item(0), new AbstractModelTest.PrimitiveString(21, "Alabama"));
        this.checkPrimitiveString(valueList.item(1), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveString(valueList.item(2), new AbstractModelTest.PrimitiveString(21, "serif"));
        value = declaration.getPropertyCSSValue("font-weight");
        CSSFontFaceRuleTest.assertTrue((boolean)(value instanceof CSSValueList));
        valueList = (CSSValueList)value;
        CSSFontFaceRuleTest.assertEquals((int)5, (int)valueList.getLength());
        this.checkPrimitiveNumber(valueList.item(0), new AbstractModelTest.PrimitiveNumber(26, 300.0f));
        this.checkPrimitiveString(valueList.item(1), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveNumber(valueList.item(2), new AbstractModelTest.PrimitiveNumber(26, 400.0f));
        this.checkPrimitiveString(valueList.item(3), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveNumber(valueList.item(4), new AbstractModelTest.PrimitiveNumber(26, 500.0f));
        value = declaration.getPropertyCSSValue("font-style");
        CSSFontFaceRuleTest.assertTrue((boolean)(value instanceof CSSValueList));
        valueList = (CSSValueList)value;
        CSSFontFaceRuleTest.assertEquals((int)3, (int)valueList.getLength());
        this.checkPrimitiveString(valueList.item(0), new AbstractModelTest.PrimitiveString(21, "italic"));
        this.checkPrimitiveString(valueList.item(1), new AbstractModelTest.PrimitiveString(32, ","));
        this.checkPrimitiveString(valueList.item(2), new AbstractModelTest.PrimitiveString(21, "oblique"));
    }
}

