/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.views.contentoutline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSValue;
import org.eclipse.wst.css.ui.internal.CSSUIPlugin;
import org.eclipse.wst.css.ui.internal.views.contentoutline.JFaceNodeContentProviderCSS;
import org.eclipse.wst.css.ui.internal.views.contentoutline.JFaceNodeLabelProviderCSS;
import org.eclipse.wst.css.ui.internal.views.contentoutline.SortAction;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.internal.provisional.views.contentoutline.StructuredContentOutlineConfiguration;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;

public class CSSContentOutlineConfiguration
extends StructuredContentOutlineConfiguration {
    private final String OUTLINE_SORT_PREF = "outline-sort";
    private IContentProvider fContentProvider = null;
    private ILabelProvider fLabelProvider = null;

    public IContributionItem[] createToolbarContributions(TreeViewer viewer) {
        IContributionItem[] items = super.createToolbarContributions(viewer);
        SortAction sortAction = new SortAction(viewer, CSSUIPlugin.getDefault().getPreferenceStore(), "outline-sort");
        PropertyChangeUpdateActionContributionItem sortItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)sortAction);
        if (items == null) {
            items = new IContributionItem[]{sortItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 1];
            combinedItems[0] = sortItem;
            System.arraycopy(items, 0, combinedItems, 1, items.length);
            items = combinedItems;
        }
        return items;
    }

    public IContentProvider getContentProvider(TreeViewer viewer) {
        if (this.fContentProvider == null && this.getFactory() != null) {
            this.fContentProvider = new JFaceNodeContentProviderCSS((INodeAdapterFactory)this.getFactory());
        }
        return this.fContentProvider;
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fLabelProvider == null && this.getFactory() != null) {
            this.fLabelProvider = new JFaceNodeLabelProviderCSS((INodeAdapterFactory)this.getFactory());
        }
        return this.fLabelProvider;
    }

    public List getNodes(List nodes) {
        ArrayList filteredNodes = new ArrayList(nodes);
        ArrayList targetNodes = new ArrayList();
        Iterator i = filteredNodes.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof ICSSNode) {
                ICSSNode node = (ICSSNode)obj;
                short nodeType = node.getNodeType();
                if (node instanceof ICSSValue) {
                    while (node != null && !(node instanceof ICSSStyleDeclItem)) {
                        node = node.getParentNode();
                    }
                } else if (nodeType == 8) {
                    node = node.getParentNode();
                } else if (nodeType == 12) {
                    node = node.getParentNode();
                }
                if (node != null) {
                    obj = node;
                }
            }
            targetNodes.add(obj);
        }
        return targetNodes;
    }

    public List getSelectedNodes(NodeSelectionChangedEvent event) {
        return this.getNodes(event.getSelectedNodes());
    }

    public String getSortPreferenceKey() {
        return "outline-sort";
    }

    protected IPreferenceStore getPreferenceStore() {
        return CSSUIPlugin.getDefault().getPreferenceStore();
    }
}

