/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.widgets.runtime;

import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ui.common.ServerSelectionUtils;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.PersistentServerRuntimeContext;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.ClientRuntimeSelectionWidgetDefaultingCommand;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ServiceType;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeInfo;
import org.eclipse.jst.ws.internal.context.ProjectTopologyContext;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionList;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionListChoices;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IRuntime;

public class ServerRuntimeSelectionWidgetDefaultingCommand
extends ClientRuntimeSelectionWidgetDefaultingCommand {
    private String DEFAULT_CLIENT_EAR_PROJECT_EXT = "EAR";
    private boolean generateProxy_;
    private ClientRuntimeSelectionWidgetDefaultingCommand.WSRuntimeJ2EEType webServiceRuntimeJ2EEType = null;
    private TypeRuntimeServer serviceIds_;
    private SelectionListChoices serviceProject2EARProject_;
    private String serviceComponentName_;
    private String serviceEarComponentName_;
    private String serviceComponentType_;
    private IStructuredSelection initialSelection_;
    private IProject initialProject_;
    private String initialComponentName_;
    private String serviceJ2EEVersion_;
    private boolean serviceNeedEAR_ = true;

    public Status execute(Environment env) {
        try {
            Status clientSideStatus = super.execute(env);
            if (clientSideStatus.getSeverity() == 4) {
                return clientSideStatus;
            }
            SimpleStatus status = new SimpleStatus("");
            this.setDefaultServiceRuntimeFromPreference();
            this.setDefaultServiceJ2EEVersionFromPreference();
            this.webServiceRuntimeJ2EEType = this.getWSRuntimeAndJ2EEFromProject(this.initialProject_, this.initialComponentName_);
            if (this.webServiceRuntimeJ2EEType != null) {
                this.serviceJ2EEVersion_ = this.webServiceRuntimeJ2EEType.getJ2eeVersionId();
                this.serviceIds_.setRuntimeId(this.webServiceRuntimeJ2EEType.getWsrId());
            }
            this.setServiceComponentType();
            this.setDefaultProjects();
            this.setDefaultEARs();
            Status serverStatus = this.setDefaultServer();
            if (serverStatus.getSeverity() == 4) {
                env.getStatusHandler().reportError(serverStatus);
                return serverStatus;
            }
            this.updateServiceEARs();
            this.updateClientEARs();
            return status;
        }
        catch (Exception e) {
            SimpleStatus errorStatus = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_TASK_EXCEPTED", (Object[])new String[]{e.getMessage()}), 4, (Throwable)e);
            env.getStatusHandler().reportError((Status)errorStatus);
            return errorStatus;
        }
    }

    private void setServiceComponentType() {
        ServiceType st = WebServiceRuntimeExtensionUtils.getServiceType((String)this.serviceIds_.getRuntimeId(), (String)this.serviceIds_.getTypeId());
        int scenario = WebServiceRuntimeExtensionUtils.getScenarioFromTypeId((String)this.serviceIds_.getTypeId());
        String[] includeComponentTypes = null;
        switch (scenario) {
            case 0: {
                includeComponentTypes = st.getBottomUpModuleTypesInclude();
                break;
            }
            case 1: {
                includeComponentTypes = st.getTopDownModuleTypesInclude();
            }
        }
        this.serviceComponentType_ = includeComponentTypes == null || includeComponentTypes.length == 0 ? "jst.web" : includeComponentTypes[0];
    }

    private ClientRuntimeSelectionWidgetDefaultingCommand.WSRuntimeJ2EEType getWSRuntimeAndJ2EEFromProject(IProject project, String componentName) {
        ClientRuntimeSelectionWidgetDefaultingCommand.WSRuntimeJ2EEType wsrJ2EE = null;
        if (project != null && project.exists()) {
            boolean isValidComponentType = false;
            if (componentName != null && componentName.length() > 0) {
                boolean bl = isValidComponentType = J2EEUtils.isWebComponent((IProject)project, (String)componentName) || J2EEUtils.isEJBComponent((IProject)project, (String)componentName);
            }
            if (isValidComponentType) {
                int versionId = J2EEUtils.getJ2EEVersion((IProject)project, (String)componentName);
                String versionString = String.valueOf(versionId);
                IRuntime runtimeTarget = ServerSelectionUtils.getRuntimeTarget((String)project.getName());
                String runtimeTargetId = null;
                if (runtimeTarget != null) {
                    runtimeTargetId = runtimeTarget.getRuntimeType().getId();
                }
                if (WebServiceRuntimeExtensionUtils.doesRuntimeSupportJ2EELevel((String)versionString, (String)this.serviceIds_.getRuntimeId()) && (runtimeTarget == null || runtimeTarget != null && WebServiceRuntimeExtensionUtils.doesRuntimeSupportServerTarget((String)runtimeTargetId, (String)this.serviceIds_.getRuntimeId()))) {
                    wsrJ2EE = new ClientRuntimeSelectionWidgetDefaultingCommand.WSRuntimeJ2EEType((ClientRuntimeSelectionWidgetDefaultingCommand)this);
                    wsrJ2EE.setWsrId(this.serviceIds_.getRuntimeId());
                    wsrJ2EE.setJ2eeVersionId(versionString);
                    return wsrJ2EE;
                }
                String[] validRuntimes = WebServiceRuntimeExtensionUtils.getRuntimesByType((String)this.serviceIds_.getTypeId());
                int i = 0;
                while (i < validRuntimes.length) {
                    if (WebServiceRuntimeExtensionUtils.doesRuntimeSupportJ2EELevel((String)versionString, (String)validRuntimes[i]) && (runtimeTarget == null || runtimeTarget != null && WebServiceRuntimeExtensionUtils.doesRuntimeSupportServerTarget((String)runtimeTargetId, (String)validRuntimes[i]))) {
                        wsrJ2EE = new ClientRuntimeSelectionWidgetDefaultingCommand.WSRuntimeJ2EEType((ClientRuntimeSelectionWidgetDefaultingCommand)this);
                        wsrJ2EE.setWsrId(validRuntimes[i]);
                        wsrJ2EE.setJ2eeVersionId(versionString);
                        return wsrJ2EE;
                    }
                    ++i;
                }
            }
        }
        return wsrJ2EE;
    }

    private void setDefaultServiceRuntimeFromPreference() {
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        String pRuntimeId = context.getRuntimeId();
        if (WebServiceRuntimeExtensionUtils.isRuntimeSupportedForType((String)this.serviceIds_.getTypeId(), (String)pRuntimeId)) {
            this.serviceIds_.setRuntimeId(pRuntimeId);
        } else {
            String[] validRuntimes = WebServiceRuntimeExtensionUtils.getRuntimesByType((String)this.serviceIds_.getTypeId());
            if (validRuntimes != null && validRuntimes.length > 0) {
                this.serviceIds_.setRuntimeId(validRuntimes[0]);
            }
        }
    }

    private void setDefaultServiceJ2EEVersionFromPreference() {
        String[] versions;
        WebServiceRuntimeInfo wsrt;
        String runtimeId;
        if (this.serviceIds_ != null && (runtimeId = this.serviceIds_.getRuntimeId()) != null && (wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById((String)runtimeId)) != null && (versions = wsrt.getJ2eeLevels()) != null && versions.length > 0) {
            PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
            String pJ2EE = context.getJ2EEVersion();
            if (pJ2EE != null && pJ2EE.length() > 0) {
                int i = 0;
                while (i < versions.length) {
                    if (versions[i].equals(pJ2EE)) {
                        this.serviceJ2EEVersion_ = versions[i];
                        return;
                    }
                    ++i;
                }
            }
            this.serviceJ2EEVersion_ = versions[0];
            return;
        }
    }

    private void setDefaultProjects() {
        if (this.initialProject_ == null || this.initialProject_ != null && this.webServiceRuntimeJ2EEType == null) {
            this.setServiceProjectToFirstValid();
            String serviceProjectName = this.getServiceProject2EARProject().getList().getSelection();
            this.updateClientProject(serviceProjectName, this.serviceComponentName_, this.serviceIds_.getTypeId());
            return;
        }
        this.getServiceProject2EARProject().getList().setSelectionValue(this.initialProject_.getName());
        this.serviceComponentName_ = this.initialComponentName_;
        this.updateClientProject(this.initialProject_.getName(), this.serviceComponentName_, this.serviceIds_.getTypeId());
    }

    private void setServiceProjectToFirstValid() {
        String[] projectNames = this.getServiceProject2EARProject().getList().getList();
        int i = 0;
        while (i < projectNames.length) {
            IProject project = ProjectUtilities.getProject((String)projectNames[i]);
            IVirtualComponent[] vcs = J2EEUtils.getComponentsByType((IProject)project, (String)this.serviceComponentType_);
            if (project.isOpen() && vcs != null && vcs.length > 0) {
                IRuntime runtimeTarget = ServerSelectionUtils.getRuntimeTarget((String)project.getName());
                String runtimeTargetId = null;
                if (runtimeTarget != null) {
                    runtimeTargetId = runtimeTarget.getRuntimeType().getId();
                }
                int j = 0;
                while (j < vcs.length) {
                    int versionId = J2EEUtils.getJ2EEVersion((IVirtualComponent)vcs[j]);
                    String versionString = String.valueOf(versionId);
                    if (this.serviceJ2EEVersion_ != null && this.serviceJ2EEVersion_.length() > 0 && this.serviceJ2EEVersion_.equals(versionString) && WebServiceRuntimeExtensionUtils.doesRuntimeSupportJ2EELevel((String)versionString, (String)this.serviceIds_.getRuntimeId()) && (runtimeTarget == null || runtimeTarget != null && WebServiceRuntimeExtensionUtils.doesRuntimeSupportServerTarget((String)runtimeTargetId, (String)this.serviceIds_.getRuntimeId()))) {
                        this.getServiceProject2EARProject().getList().setSelectionValue(projectNames[i]);
                        this.serviceComponentName_ = vcs[j].getName();
                        return;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (this.serviceComponentType_.equals("jst.ejb")) {
            this.getServiceProject2EARProject().getList().setSelectionValue(ResourceUtils.getDefaultEJBProjectName());
            this.serviceComponentName_ = ResourceUtils.getDefaultEJBComponentName();
        } else {
            this.getServiceProject2EARProject().getList().setSelectionValue(ResourceUtils.getDefaultWebProjectName());
            this.serviceComponentName_ = ResourceUtils.getDefaultWebComponentName();
        }
    }

    private void setDefaultEARs() {
        IVirtualComponent[] allEarComps;
        IVirtualComponent[] earComps;
        String initialProjectName = this.getServiceProject2EARProject().getList().getSelection();
        IProject initialProject = FileResourceUtils.getWorkspaceRoot().getProject(initialProjectName);
        boolean earIsSet = false;
        if (initialProject != null && initialProject.exists() && (earComps = J2EEUtils.getReferencingEARComponents((IProject)initialProject, (String)this.serviceComponentName_)).length > 0) {
            IVirtualComponent earComp = earComps[0];
            String earProjectName = earComp.getProject().getName();
            String earComponentName = earComp.getName();
            this.getServiceProject2EARProject().getChoice().getList().setSelectionValue(earProjectName);
            this.serviceEarComponentName_ = earComponentName;
            earIsSet = true;
        }
        if (!earIsSet && (allEarComps = J2EEUtils.getAllEARComponents()).length > 0) {
            int i = 0;
            while (i < allEarComps.length) {
                IRuntime runtime = ServerSelectionUtils.getRuntimeTarget((String)allEarComps[i].getProject().getName());
                if (runtime != null && this.serviceIds_.getRuntimeId() != null && WebServiceRuntimeExtensionUtils.doesRuntimeSupportServerTarget((String)runtime.getRuntimeType().getId(), (String)this.serviceIds_.getRuntimeId()) && this.serviceJ2EEVersion_.equals(String.valueOf(J2EEUtils.getJ2EEVersion((IVirtualComponent)allEarComps[i])))) {
                    String earProjectName = allEarComps[i].getProject().getName();
                    this.getServiceProject2EARProject().getChoice().getList().setSelectionValue(earProjectName);
                    this.serviceEarComponentName_ = allEarComps[i].getName();
                    earIsSet = true;
                }
                ++i;
            }
        }
        if (!earIsSet) {
            this.getServiceProject2EARProject().getChoice().getList().setSelectionValue(ResourceUtils.getDefaultServiceEARProjectName());
            this.serviceEarComponentName_ = ResourceUtils.getDefaultServiceEARComponentName();
        }
        String initialClientProjectName = this.getRuntime2ClientTypes().getChoice().getChoice().getList().getSelection();
        IProject initialClientProject = ProjectUtilities.getProject((String)initialClientProjectName);
        String[] clientEARInfo = this.getDefaultEARFromClientProject(initialClientProject, this.getClientComponentName());
        if (initialClientProject != null && initialClientProject.exists() && clientEARInfo[1].equalsIgnoreCase(this.serviceEarComponentName_)) {
            this.getRuntime2ClientTypes().getChoice().getChoice().getChoice().getList().setSelectionValue(clientEARInfo[0]);
            this.setClientEARComponentName(clientEARInfo[1]);
        } else {
            ProjectTopologyContext ptc = WebServicePlugin.getInstance().getProjectTopologyContext();
            String serviceEARName = this.getServiceProject2EARProject().getChoice().getList().getSelection();
            if (!ptc.isUseTwoEARs()) {
                this.getRuntime2ClientTypes().getChoice().getChoice().getChoice().getList().setSelectionValue(serviceEARName);
                this.setClientEARComponentName(this.serviceEarComponentName_);
            } else {
                IProject proxyEARProject = this.getUniqueClientEAR(clientEARInfo[0], serviceEARName, initialClientProjectName);
                this.getRuntime2ClientTypes().getChoice().getChoice().getChoice().getList().setSelectionValue(proxyEARProject.getName());
                this.setClientEARComponentName(proxyEARProject.getName());
            }
        }
    }

    private IProject getUniqueClientEAR(String earProject, String serviceProject, String clientProjectName) {
        String projectName = new String();
        if (!earProject.equalsIgnoreCase(serviceProject)) {
            projectName = earProject;
        } else {
            projectName = String.valueOf(clientProjectName) + this.DEFAULT_CLIENT_EAR_PROJECT_EXT;
            int i = 1;
            while (projectName.equalsIgnoreCase(serviceProject)) {
                projectName = String.valueOf(projectName) + i;
                ++i;
            }
        }
        return projectName.equals("") ? null : ResourceUtils.getWorkspaceRoot().getProject(projectName);
    }

    private Status setDefaultServer() {
        SimpleStatus status = new SimpleStatus("");
        String initialProjectName = this.getServiceProject2EARProject().getList().getSelection();
        IProject initialProject = ProjectUtilities.getProject((String)initialProjectName);
        if (initialProject.exists()) {
            String[] serverInfo = ServerSelectionUtils.getServerInfoFromExistingProject((IProject)initialProject, (String)this.serviceComponentName_, (String)this.serviceIds_.getRuntimeId(), (boolean)true);
            if (serverInfo != null) {
                if (serverInfo[0] != null && serverInfo[0].length() > 0) {
                    this.serviceIds_.setServerId(serverInfo[0]);
                }
                if (serverInfo[1] != null && serverInfo[1].length() > 0) {
                    this.serviceIds_.setServerInstanceId(serverInfo[1]);
                }
            }
        } else {
            String initialEARProjectName = this.getServiceProject2EARProject().getChoice().getList().getSelection();
            IProject initialEARProject = ProjectUtilities.getProject((String)initialEARProjectName);
            if (initialEARProject.exists()) {
                String[] serverInfo = ServerSelectionUtils.getServerInfoFromExistingProject((IProject)initialEARProject, (String)this.serviceEarComponentName_, (String)this.serviceIds_.getRuntimeId(), (boolean)false);
                if (serverInfo != null) {
                    if (serverInfo[0] != null && serverInfo[0].length() > 0) {
                        this.serviceIds_.setServerId(serverInfo[0]);
                    }
                    if (serverInfo[1] != null && serverInfo[1].length() > 0) {
                        this.serviceIds_.setServerInstanceId(serverInfo[1]);
                    }
                }
            } else {
                String[] serverInfo = ServerSelectionUtils.getServerFromWebServceRuntimeAndJ2EE((String)this.serviceIds_.getRuntimeId(), (String)this.serviceJ2EEVersion_);
                if (serverInfo != null) {
                    if (serverInfo[0] != null && serverInfo[0].length() > 0) {
                        this.serviceIds_.setServerId(serverInfo[0]);
                    }
                    if (serverInfo[1] != null && serverInfo[1].length() > 0) {
                        this.serviceIds_.setServerInstanceId(serverInfo[1]);
                    }
                } else {
                    String[] versions;
                    boolean foundServer = false;
                    WebServiceRuntimeInfo wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById((String)this.serviceIds_.getRuntimeId());
                    if (wsrt != null && (versions = wsrt.getJ2eeLevels()) != null && versions.length > 0) {
                        int k = 0;
                        while (k < versions.length) {
                            String[] si;
                            if (this.serviceJ2EEVersion_ != versions[k] && (si = ServerSelectionUtils.getServerFromWebServceRuntimeAndJ2EE((String)this.serviceIds_.getRuntimeId(), (String)versions[k])) != null) {
                                if (si[0] != null && si[0].length() > 0) {
                                    this.serviceIds_.setServerId(si[0]);
                                }
                                if (si[1] != null && si[1].length() > 0) {
                                    this.serviceIds_.setServerInstanceId(si[1]);
                                }
                                this.serviceJ2EEVersion_ = versions[k];
                                foundServer = true;
                                break;
                            }
                            ++k;
                        }
                    }
                    if (!foundServer) {
                        String runtimeLabel = WebServiceRuntimeExtensionUtils.getRuntimeLabelById((String)this.serviceIds_.getRuntimeId());
                        String serverLabels = this.getServerLabels(this.serviceIds_.getRuntimeId());
                        status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_NO_SERVER_RUNTIME", (Object[])new String[]{runtimeLabel, serverLabels}), 4);
                    }
                }
            }
        }
        return status;
    }

    private void updateServiceEARs() {
        String serviceProjectName = this.getServiceProject2EARProject().getList().getSelection();
        IProject serviceProject = FileResourceUtils.getWorkspaceRoot().getProject(serviceProjectName);
        if (serviceProject != null && serviceProject.exists()) {
            IRuntime serviceTarget = ServerSelectionUtils.getRuntimeTarget((String)serviceProjectName);
            String j2eeVersion = String.valueOf(J2EEUtils.getJ2EEVersion((IProject)serviceProject, (String)this.serviceComponentName_));
            if (serviceTarget != null && !ServerUtils.isTargetValidForEAR((String)serviceTarget.getRuntimeType().getId(), (String)j2eeVersion)) {
                this.getServiceProject2EARProject().getChoice().getList().setIndex(-1);
                this.serviceEarComponentName_ = "";
                this.serviceNeedEAR_ = false;
            }
        } else {
            String serverTargetId;
            String serverId = this.serviceIds_.getServerId();
            if (serverId != null && (serverTargetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)serverId)) != null && serverTargetId.length() > 0 && !ServerUtils.isTargetValidForEAR((String)serverTargetId, (String)this.serviceJ2EEVersion_)) {
                this.getServiceProject2EARProject().getChoice().getList().setIndex(-1);
                this.serviceEarComponentName_ = "";
                this.serviceNeedEAR_ = false;
            }
        }
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.initialSelection_ = selection;
    }

    public void setInitialProject(IProject initialProject) {
        this.initialProject_ = initialProject;
    }

    public void setInitialComponentName(String name) {
        this.initialComponentName_ = name;
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer ids) {
        this.serviceIds_ = ids;
    }

    public TypeRuntimeServer getServiceTypeRuntimeServer() {
        return this.serviceIds_;
    }

    public SelectionListChoices getServiceProject2EARProject() {
        if (this.serviceProject2EARProject_ == null) {
            String[] projectNames = this.getAllFlexibleProjects();
            SelectionList list = new SelectionList(projectNames, 0);
            Vector<SelectionListChoices> choices = new Vector<SelectionListChoices>();
            int i = 0;
            while (i < projectNames.length) {
                IProject project = ProjectUtilities.getProject((String)projectNames[i]);
                choices.add(this.getProjectEARChoice(project));
                ++i;
            }
            this.serviceProject2EARProject_ = new SelectionListChoices(list, choices, this.getEARProjects());
        }
        return this.serviceProject2EARProject_;
    }

    public boolean getGenerateProxy() {
        return this.generateProxy_;
    }

    public void setGenerateProxy(boolean generateProxy_) {
        this.generateProxy_ = generateProxy_;
    }

    public String getServiceJ2EEVersion() {
        return this.serviceJ2EEVersion_;
    }

    public String getServiceProjectName() {
        return this.getServiceProject2EARProject().getList().getSelection();
    }

    public String getServiceEarProjectName() {
        return this.getServiceProject2EARProject().getChoice().getList().getSelection();
    }

    public String getServiceComponentName() {
        return this.serviceComponentName_;
    }

    public String getServiceEarComponentName() {
        return this.serviceEarComponentName_;
    }

    public String getServiceComponentType() {
        return this.serviceComponentType_;
    }

    public boolean getServiceNeedEAR() {
        return this.serviceNeedEAR_;
    }
}

