/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.deployables;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.jfaces.extension.FileURL;
import org.eclipse.jst.j2ee.internal.web.jfaces.extension.FileURLExtensionReader;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.JSPType;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.util.WebResource;

public class WebDeployableArtifactUtil {
    private static final String[] extensionsToExclude = new String[]{"sql", "xmi"};
    private static final String GENERIC_SERVLET_CLASS_TYPE = "javax.servlet.GenericServlet";
    private static final String CACTUS_SERVLET_CLASS_TYPE = "org.apache.cactus.server.ServletTestRedirector";
    static /* synthetic */ Class class$0;

    public static IModuleArtifact getModuleObject(Object obj) {
        IPath correctJSPPath;
        String className;
        IProject project;
        String mapping;
        IResource resource = null;
        if (obj instanceof IResource) {
            resource = (IResource)obj;
        }
        if (obj instanceof IModuleArtifact) {
            resource = ((IModuleArtifact)obj).getModule().getProject();
        } else if (obj instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)iAdaptable.getAdapter((Class)clazz);
        } else if (obj instanceof EObject) {
            resource = ProjectUtilities.getProject((EObject)((EObject)obj));
            if (obj instanceof Servlet) {
                Servlet servlet = (Servlet)obj;
                Resource servResource = servlet.eResource();
                IVirtualResource[] resources = null;
                try {
                    IFile eclipeServResoruce = WorkbenchResourceHelper.getFile((Resource)servResource);
                    resources = ComponentCore.createResources((IResource)eclipeServResoruce);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                IVirtualComponent component = null;
                if (resources[0] != null) {
                    component = resources[0].getComponent();
                }
                mapping = null;
                List mappings = ((Servlet)obj).getMappings();
                if (mappings != null && !mappings.isEmpty()) {
                    ServletMapping map = (ServletMapping)mappings.get(0);
                    mapping = map.getUrlPattern();
                }
                if (mapping != null) {
                    return new WebResource(WebDeployableArtifactUtil.getModule(resource.getProject(), component), (IPath)new Path(mapping));
                }
                WebType webType = ((Servlet)obj).getWebType();
                if (webType.isJspType()) {
                    resource = ((IProject)resource).getFile(((JSPType)webType).getJspFile());
                } else if (webType.isServletType()) {
                    return new WebResource(WebDeployableArtifactUtil.getModule(resource.getProject(), component), (IPath)new Path("servlet/" + ((ServletType)webType).getClassName()));
                }
            }
        }
        if (resource == null) {
            return null;
        }
        if (resource instanceof IProject && WebDeployableArtifactUtil.hasInterestedComponents(project = (IProject)resource)) {
            return new WebResource(WebDeployableArtifactUtil.getModule(project, null), project.getProjectRelativePath());
        }
        if (!WebDeployableArtifactUtil.hasInterestedComponents(resource.getProject())) {
            return null;
        }
        if (WebDeployableArtifactUtil.isCactusJunitTest(resource)) {
            return null;
        }
        resource.getProjectRelativePath();
        IPath resourcePath = resource.getFullPath();
        IVirtualResource[] resources = ComponentCore.createResources((IResource)resource);
        IVirtualComponent component = null;
        if (resources[0] != null || resources.length <= 0) {
            component = resources[0].getComponent();
        }
        if ((className = WebDeployableArtifactUtil.getServletClassName(resource)) != null && component != null) {
            mapping = WebDeployableArtifactUtil.getServletMapping(resource, true, className, component.getName());
            if (mapping != null) {
                return new WebResource(WebDeployableArtifactUtil.getModule(resource.getProject(), component), (IPath)new Path(mapping));
            }
            return new WebResource(WebDeployableArtifactUtil.getModule(resource.getProject(), component), (IPath)new Path("servlet/" + className));
        }
        resourcePath = resources[0].getRuntimePath();
        FileURL jspURL = FileURLExtensionReader.getInstance().getFilesURL();
        if (jspURL != null && (correctJSPPath = jspURL.getFileURL(resource, resourcePath)) != null && correctJSPPath.toString().length() > 0) {
            return new WebResource(WebDeployableArtifactUtil.getModule(resource.getProject(), component), correctJSPPath);
        }
        return new WebResource(WebDeployableArtifactUtil.getModule(resource.getProject(), component), resourcePath);
    }

    private static IPath trim(IPath resourcePath, String stripValue) {
        int x = -1;
        String[] segements = resourcePath.segments();
        int i = 0;
        while (i < segements.length) {
            if (segements[i].equals(stripValue)) {
                x = ++i;
                break;
            }
            ++i;
        }
        if (x > -1) {
            return resourcePath.removeFirstSegments(x);
        }
        return resourcePath;
    }

    private static boolean shouldExclude(IResource resource) {
        String fileExt = resource.getFileExtension();
        int i = 0;
        while (i < extensionsToExclude.length) {
            String extension = extensionsToExclude[i];
            if (extension.equalsIgnoreCase(fileExt)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static IModule getModule(IProject project, IVirtualComponent component) {
        IModule deployable = null;
        Iterator<IModule> iterator = Arrays.asList(ServerUtil.getModules((String)"j2ee.web")).iterator();
        String componentName = null;
        if (component == null) return WebDeployableArtifactUtil.getModuleProject(project, iterator);
        componentName = component.getName();
        while (iterator.hasNext()) {
            IModule next = iterator.next();
            if (!(next instanceof IModule) || !(deployable = next).getName().equals(componentName)) continue;
            return deployable;
        }
        return null;
    }

    protected static IModule getModuleProject(IProject project, Iterator iterator) {
        IModule deployable = null;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof IModule) || !(deployable = (IModule)next).getProject().equals((Object)project)) continue;
            return deployable;
        }
        return null;
    }

    private static boolean isCactusJunitTest(IResource resource) {
        return WebDeployableArtifactUtil.getClassNameForType(resource, CACTUS_SERVLET_CLASS_TYPE) != null;
    }

    private static IType[] getTypes(IJavaElement element) {
        try {
            if (element.getElementType() != 5) {
                return null;
            }
            return ((ICompilationUnit)element).getAllTypes();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getServletClassName(IResource resource) {
        return WebDeployableArtifactUtil.getClassNameForType(resource, GENERIC_SERVLET_CLASS_TYPE);
    }

    public static String getClassNameForType(IResource resource, String superType) {
        if (resource == null) {
            return null;
        }
        try {
            IJavaElement javaElement;
            IType[] types;
            IClasspathEntry[] classPathEntry;
            IPath outputPath;
            IProject project = resource.getProject();
            IPath path = resource.getFullPath();
            if (!project.hasNature("org.eclipse.jdt.core.javanature") || path == null) {
                return null;
            }
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            if (!javaProject.isOpen()) {
                javaProject.open((IProgressMonitor)new NullProgressMonitor());
            }
            if ((outputPath = javaProject.getOutputLocation()) != null && "class".equals(path.getFileExtension()) && outputPath.isPrefixOf(path)) {
                int count = outputPath.segmentCount();
                path = path.removeFirstSegments(count);
            }
            if ((classPathEntry = javaProject.getResolvedClasspath(true)) != null) {
                int size = classPathEntry.length;
                int i = 0;
                while (i < size) {
                    IPath classPath = classPathEntry[i].getPath();
                    if (classPath.isPrefixOf(path)) {
                        int count = classPath.segmentCount();
                        path = path.removeFirstSegments(count);
                        i += size;
                    }
                    ++i;
                }
            }
            if ((types = WebDeployableArtifactUtil.getTypes(javaElement = javaProject.findElement(path))) != null) {
                int size2 = types.length;
                int i = 0;
                while (i < size2) {
                    if (WebDeployableArtifactUtil.hasSuperclass(types[i], superType)) {
                        return types[i].getFullyQualifiedName();
                    }
                    ++i;
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean hasSuperclass(IType type, String superClassName) {
        try {
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            IType[] superClasses = hierarchy.getAllSuperclasses(type);
            int size = superClasses.length;
            int i = 0;
            while (i < size) {
                if (superClassName.equals(superClasses[i].getFullyQualifiedName())) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isServlet(IType type) {
        try {
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            IType[] superClasses = hierarchy.getAllSuperclasses(type);
            int size = superClasses.length;
            int i = 0;
            while (i < size) {
                if (GENERIC_SERVLET_CLASS_TYPE.equals(superClasses[i].getFullyQualifiedName())) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getServletMapping(IResource resource, boolean isServlet, String typeName, String componentName) {
        WebApp webApp;
        block11: {
            if (typeName == null || typeName.equals("")) {
                return null;
            }
            IProject project = resource.getProject();
            WebArtifactEdit edit = null;
            webApp = null;
            try {
                ComponentHandle handle = ComponentHandle.create((IProject)project, (String)componentName);
                edit = WebArtifactEdit.getWebArtifactEditForRead(handle);
                edit.getDeploymentDescriptorRoot();
                webApp = edit.getWebApp();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (edit != null) {
                    edit.dispose();
                }
                throw throwable;
            }
            {
                Object var8_11 = null;
                if (edit == null) break block11;
            }
            edit.dispose();
        }
        new Object();
        try {
            Servlet servlet;
            List mappings;
            boolean valid;
            if (webApp == null) {
                return null;
            }
            Iterator iterator = webApp.getServlets().iterator();
            do {
                ServletType type;
                if (!iterator.hasNext()) {
                    return null;
                }
                servlet = (Servlet)iterator.next();
                valid = false;
                WebType webType = servlet.getWebType();
                if (webType.isServletType() && isServlet) {
                    type = (ServletType)webType;
                    if (!typeName.equals(type.getClassName())) continue;
                    valid = true;
                    continue;
                }
                if (!webType.isJspType() || isServlet || !typeName.equals((type = (JSPType)webType).getJspFile())) continue;
                valid = true;
            } while (!valid || (mappings = servlet.getMappings()) == null || mappings.isEmpty());
            ServletMapping map = (ServletMapping)mappings.get(0);
            return map.getUrlPattern();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean hasInterestedComponents(IProject project) {
        StructureEdit edit;
        block9: {
            block7: {
                edit = null;
                if (ModuleCoreNature.getModuleCoreNature((IProject)project) == null) {
                    return false;
                }
                try {
                    try {
                        edit = StructureEdit.getStructureEditForWrite((IProject)project);
                        WorkbenchComponent[] components = edit.findComponentsByType("jst.web");
                        if (components != null) {
                            if (components.length != 0) break block7;
                        }
                        Object var3_4 = null;
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    edit.dispose();
                    throw throwable;
                }
                edit.dispose();
                return false;
            }
            Object var3_5 = null;
            edit.dispose();
            return true;
        }
        Object var3_7 = null;
        edit.dispose();
        return false;
    }
}

