/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.taglib.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.web.locator.WebProjectTaglibLocator;
import org.eclipse.jst.j2ee.internal.web.locator.WebXMLTaglibLocator;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibInfo;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibLocator;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibRegistry;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibRegistryListener;

public abstract class AbstractTaglibRegistry
implements ITaglibRegistry {
    private static final boolean debug = false;
    protected IProject project;
    protected Vector listeners;
    protected Vector taglibs;
    protected ITaglibLocator[] locators;
    protected boolean needsRefresh = false;

    public AbstractTaglibRegistry(IProject project) {
        this.project = project;
        this.initialize();
        this.refresh();
    }

    protected void initialize() {
        this.locators = new ITaglibLocator[]{new WebProjectTaglibLocator(this.project), new WebXMLTaglibLocator(this.project)};
    }

    protected void addTaglib(ITaglibInfo taglib) {
        if (taglib.isWebXMLEntry()) {
            this.taglibs.add(0, taglib);
        } else {
            this.taglibs.add(taglib);
        }
    }

    public void addTaglibRegistryListener(ITaglibRegistryListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    public ITaglibInfo[] getTaglibs(IPath location) {
        Vector results = this.getTaglibsVector(location);
        return results.toArray(new ITaglibInfo[results.size()]);
    }

    protected Vector getTaglibsVector(IPath location) {
        Vector<ITaglibInfo> results = new Vector<ITaglibInfo>();
        Vector tTaglibs = this.primGetTaglibs();
        boolean isWebXML = this.isWebXMLFile(location);
        Iterator iter = tTaglibs.iterator();
        while (iter.hasNext()) {
            ITaglibInfo taglib = (ITaglibInfo)iter.next();
            if (isWebXML) {
                if (!taglib.isWebXMLEntry()) continue;
                results.add(taglib);
                continue;
            }
            if (!taglib.getLocation().equals((Object)location)) continue;
            results.add(taglib);
        }
        return results;
    }

    protected Vector getExistingTaglibs(IPath location) {
        Vector<ITaglibInfo> results = new Vector<ITaglibInfo>();
        Vector tTaglibs = this.taglibs;
        boolean isWebXML = this.isWebXMLFile(location);
        Iterator iter = tTaglibs.iterator();
        while (iter.hasNext()) {
            ITaglibInfo taglib = (ITaglibInfo)iter.next();
            if (isWebXML) {
                if (!taglib.isWebXMLEntry()) continue;
                results.add(taglib);
                continue;
            }
            if (!taglib.getLocation().equals((Object)location) || taglib.isWebXMLEntry()) continue;
            results.add(taglib);
        }
        return results;
    }

    public IProject getProject() {
        return this.project;
    }

    public ITaglibInfo[] getRecommendedTaglibs() {
        return this.getValidTaglibs(false);
    }

    public ITaglibInfo[] getVisibleTaglibs() {
        return this.getValidTaglibs(true);
    }

    protected ITaglibInfo[] getValidTaglibs(boolean showAllEntriesPerResource) {
        ITaglibInfo iTaglib;
        Vector allTaglibs = this.primGetTaglibs();
        Vector<ITaglibInfo> results = new Vector<ITaglibInfo>(allTaglibs.size());
        HashSet<IPath> locationSet = new HashSet<IPath>();
        HashSet<String> uriSet = new HashSet<String>();
        Iterator iter = allTaglibs.iterator();
        while (iter.hasNext()) {
            iTaglib = (ITaglibInfo)iter.next();
            if (!iTaglib.isWebXMLEntry() || uriSet.contains(iTaglib.getURI())) continue;
            if (!locationSet.contains(iTaglib.getLocation())) {
                locationSet.add(iTaglib.getLocation());
            }
            results.add(iTaglib);
            uriSet.add(iTaglib.getURI());
        }
        iter = allTaglibs.iterator();
        while (iter.hasNext()) {
            iTaglib = (ITaglibInfo)iter.next();
            if (!iTaglib.isURIFromTLD() || iTaglib.isWebXMLEntry() || uriSet.contains(iTaglib.getURI())) continue;
            if (!iTaglib.isInJar()) {
                if (showAllEntriesPerResource || !locationSet.contains(iTaglib.getLocation())) {
                    if (!locationSet.contains(iTaglib.getLocation())) {
                        locationSet.add(iTaglib.getLocation());
                    }
                    results.add(iTaglib);
                }
            } else {
                String jarRelativePath = iTaglib.getTLDLocation().toString();
                if (jarRelativePath.equalsIgnoreCase("META-INF/taglib.tld")) {
                    if (!(iTaglib.isServerContribution() || !showAllEntriesPerResource && locationSet.contains(iTaglib.getLocation()))) {
                        if (!locationSet.contains(iTaglib.getLocation())) {
                            locationSet.add(iTaglib.getLocation());
                        }
                        results.add(iTaglib);
                    }
                } else {
                    results.add(iTaglib);
                }
            }
            uriSet.add(iTaglib.getURI());
        }
        iter = allTaglibs.iterator();
        while (iter.hasNext()) {
            iTaglib = (ITaglibInfo)iter.next();
            if (iTaglib.isURIFromTLD() || iTaglib.isWebXMLEntry() || iTaglib.isDirectoryEntry() || uriSet.contains(iTaglib.getURI()) || !showAllEntriesPerResource && locationSet.contains(iTaglib.getLocation())) continue;
            results.add(iTaglib);
            locationSet.add(iTaglib.getLocation());
        }
        iter = allTaglibs.iterator();
        while (iter.hasNext()) {
            iTaglib = (ITaglibInfo)iter.next();
            if (!iTaglib.isDirectoryEntry()) continue;
            IPath directoryLoc = iTaglib.getLocation();
            if (uriSet.contains(iTaglib.getURI())) continue;
            boolean canAdd = true;
            Iterator iterator = locationSet.iterator();
            while (iterator.hasNext()) {
                IPath locationPath = (IPath)iterator.next();
                if (directoryLoc.matchingFirstSegments(locationPath) != locationPath.segmentCount() - 1) continue;
                canAdd = false;
                break;
            }
            if (!canAdd) continue;
            results.add(iTaglib);
            locationSet.add(iTaglib.getLocation());
        }
        return results.toArray(new ITaglibInfo[results.size()]);
    }

    protected Vector primGetTaglibs() {
        if (this.needsRefresh) {
            this.refresh();
        }
        return this.taglibs;
    }

    public ITaglibInfo[] getTaglibs() {
        Vector tTaglibs = this.primGetTaglibs();
        return tTaglibs.toArray(new ITaglibInfo[tTaglibs.size()]);
    }

    public ITaglibInfo getTaglib(String uri) {
        List<ITaglibInfo> tTaglibs = Arrays.asList(this.getVisibleTaglibs());
        Iterator<ITaglibInfo> iter = tTaglibs.iterator();
        while (iter.hasNext()) {
            ITaglibInfo taglib = iter.next();
            if (!taglib.getURI().equals(uri)) continue;
            return taglib;
        }
        return null;
    }

    protected void fireTaglibAdded(ITaglibInfo addedTaglib) {
        if (this.listeners == null) {
            return;
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ITaglibRegistryListener listener = (ITaglibRegistryListener)iter.next();
            listener.taglibAdded(addedTaglib);
        }
    }

    protected void fireTaglibChanged(ITaglibInfo changedTaglib) {
        if (this.listeners == null) {
            return;
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ITaglibRegistryListener listener = (ITaglibRegistryListener)iter.next();
            listener.taglibChanged(changedTaglib);
        }
    }

    protected void fireTaglibRemoved(ITaglibInfo removedTaglib) {
        if (this.listeners == null) {
            return;
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ITaglibRegistryListener listener = (ITaglibRegistryListener)iter.next();
            listener.taglibRemoved(removedTaglib);
        }
    }

    protected abstract boolean isWebXMLFile(IPath var1);

    protected boolean isTaglibTLD(IPath tldPath) {
        return tldPath.lastSegment().equalsIgnoreCase("taglib.tld");
    }

    public void processResourceChanged(IResourceDelta delta) {
        int kind = delta.getKind();
        IResource resource = delta.getResource();
        int flags = delta.getFlags();
        if (delta.getKind() == 4 && flags == 0) {
            return;
        }
        if (this.requiresFullUpdate(delta)) {
            this.updateAll();
            return;
        }
        if (resource == null) {
            return;
        }
        IPath resourcePath = resource.getProjectRelativePath();
        IResource refreshRoot = this.getRefreshRoot();
        if (refreshRoot == null) {
            return;
        }
        IPath refreshPath = refreshRoot.getProjectRelativePath();
        if (resourcePath.matchingFirstSegments(refreshPath) != refreshPath.segmentCount()) {
            return;
        }
        if (kind == 4 || kind == 262144) {
            this.handleResourceModified(resource);
        } else if (kind == 2) {
            this.handleResourceRemoved(resource);
        } else if (kind == 1) {
            this.handleResourceAdded(resource);
        }
    }

    protected void handleResourceAdded(IResource resource) {
        this.handleResourceModified(resource);
    }

    protected void handleResourceModified(IResource resource) {
        try {
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource aresource) throws CoreException {
                    if (aresource.getType() != 8 && AbstractTaglibRegistry.this.project != aresource.getProject()) {
                        return false;
                    }
                    if (aresource.getType() == 1) {
                        AbstractTaglibRegistry.this.processFile(aresource);
                        return false;
                    }
                    if (AbstractTaglibRegistry.this.shouldProcessDirectory(aresource)) {
                        AbstractTaglibRegistry.this.processDirectory(aresource);
                    }
                    return AbstractTaglibRegistry.this.canVisitResource(aresource);
                }
            });
        }
        catch (CoreException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    protected boolean canVisitResource(IResource resource) {
        if (resource.getType() != 8 && this.project != resource.getProject()) {
            return false;
        }
        if (resource.getType() != 1) {
            return true;
        }
        return true;
    }

    protected void handleResourceRemoved(IResource resource) {
        IPath location = resource.getProjectRelativePath();
        ITaglibInfo[] removedTaglibs = this.removeTaglibs(location);
        if (removedTaglibs != null) {
            int i = 0;
            while (i < removedTaglibs.length) {
                ITaglibInfo iTaglibInfo = removedTaglibs[i];
                this.fireTaglibRemoved(iTaglibInfo);
                ++i;
            }
        }
    }

    protected IResource getRefreshRoot() {
        return this.getProject();
    }

    public void refresh() {
        this.taglibs = new Vector();
        IResource refreshRoot = this.getRefreshRoot();
        if (refreshRoot != null) {
            this.handleResourceAdded(refreshRoot);
        }
        this.needsRefresh = false;
    }

    protected void updateAll() {
        try {
            IResource refreshRoot = this.getRefreshRoot();
            if (refreshRoot == null) {
                return;
            }
            refreshRoot.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    AbstractTaglibRegistry.this.handleResourceModified(resource);
                    return true;
                }
            });
        }
        catch (CoreException coreException) {}
    }

    protected ITaglibInfo[] removeTaglibs(IPath location) {
        ArrayList<ITaglibInfo> results = new ArrayList<ITaglibInfo>();
        boolean isWebXML = this.isWebXMLFile(location);
        int i = 0;
        while (i < this.taglibs.size()) {
            ITaglibInfo taglib = (ITaglibInfo)this.taglibs.get(i);
            if (isWebXML) {
                if (taglib.isWebXMLEntry()) {
                    this.removeTaglib(i);
                    results.add(taglib);
                    --i;
                }
            } else if (taglib.getLocation().equals((Object)location)) {
                this.removeTaglib(i);
                results.add(taglib);
                --i;
            }
            ++i;
        }
        return results.isEmpty() ? null : results.toArray(new ITaglibInfo[results.size()]);
    }

    protected abstract boolean requiresFullUpdate(IResourceDelta var1);

    protected void removeTaglib(int i) {
        this.taglibs.remove(i);
    }

    protected ITaglibInfo[] searchForTaglibs(IResource resource) {
        ArrayList<ITaglibInfo> results = new ArrayList<ITaglibInfo>();
        int i = 0;
        while (i < this.locators.length) {
            ITaglibLocator tLocator = this.locators[i];
            ITaglibInfo[] tTaglibs = tLocator.search(resource);
            if (tTaglibs != null) {
                int j = 0;
                while (j < tTaglibs.length) {
                    results.add(tTaglibs[j]);
                    ++j;
                }
            }
            ++i;
        }
        return results.toArray(new ITaglibInfo[results.size()]);
    }

    public void removeTaglibRegistryListener(ITaglibRegistryListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TaglibRegistry: \n");
        Iterator iter = this.taglibs.iterator();
        while (iter.hasNext()) {
            ITaglibInfo taglib = (ITaglibInfo)iter.next();
            sb.append("\t");
            sb.append(taglib);
            sb.append("\n");
        }
        return sb.toString();
    }

    protected void processDirectory(IResource resource) {
    }

    protected boolean shouldProcessDirectory(IResource resource) {
        return true;
    }

    protected void processFile(IResource resource) {
        Vector existingTaglibs = this.getExistingTaglibs(resource.getProjectRelativePath());
        ITaglibInfo[] newTaglibs = this.searchForTaglibs(resource);
        int i = 0;
        while (i < newTaglibs.length) {
            ITaglibInfo newTaglib = newTaglibs[i];
            int existingIndex = existingTaglibs.indexOf(newTaglib);
            if (existingIndex >= 0) {
                if (!newTaglib.isWebXMLEntry()) {
                    this.fireTaglibChanged(newTaglib);
                }
                existingTaglibs.remove(existingIndex);
            } else {
                this.addTaglib(newTaglib);
                this.fireTaglibAdded(newTaglib);
            }
            ++i;
        }
        Iterator iter = existingTaglibs.iterator();
        while (iter.hasNext()) {
            ITaglibInfo remainingTaglib = (ITaglibInfo)iter.next();
            this.taglibs.remove(remainingTaglib);
            this.fireTaglibRemoved(remainingTaglib);
        }
    }
}

