/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.jca.archive.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.archive.operations.J2EELoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.jca.archive.operations.NestedJARLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorNatureRuntime;

public class RARProjectLoadStrategyImpl
extends J2EELoadStrategyImpl {
    private IContainer moduleRoot;
    private int moduleRootSegmentCount;
    private Map innerClasses;
    public static String[] knownLibExtensions = new String[]{".jar", ".zip", ".so", ".o", ".sl", ".dll"};

    public RARProjectLoadStrategyImpl(IProject aProject) {
        this.project = aProject;
        this.filesList = new ArrayList();
        this.init();
    }

    public List getFiles() {
        List files = super.getFiles();
        files.addAll(this.getNestedJARsFromSourceFolders());
        return files;
    }

    protected boolean shouldInclude(IContainer iContainer) {
        return this.moduleRoot.equals((Object)iContainer) || !this.getSourceFolders().contains(iContainer);
    }

    private Collection getNestedJARsFromSourceFolders() {
        List localSourceFolders = this.getSourceFolders();
        ArrayList<File> result = new ArrayList<File>(localSourceFolders.size());
        int i = 0;
        while (i < localSourceFolders.size()) {
            IFolder folder = (IFolder)localSourceFolders.get(i);
            File aFile = this.getNestedJARFromSourceFolder(folder);
            if (aFile != null) {
                result.add(aFile);
            }
            ++i;
        }
        return result;
    }

    private File getNestedJARFromSourceFolder(IFolder folder) {
        ArrayList sourceIFiles = new ArrayList();
        boolean isModuleRoot = folder.equals((Object)this.moduleRoot);
        boolean foundJava = this.gatherFilesForJAR(sourceIFiles, folder, folder, isModuleRoot, false);
        if (!isModuleRoot || foundJava) {
            return this.createNestedArchive(sourceIFiles, folder);
        }
        return null;
    }

    private File createNestedArchive(List sourceIFiles, IFolder folder) {
        NestedJARLoadStrategyImpl loader = new NestedJARLoadStrategyImpl(this, sourceIFiles, folder);
        loader.setExportSource(this.isExportSource());
        ArchiveOptions options = ((Archive)this.getContainer()).getOptions().cloneWith((LoadStrategy)loader);
        String uri = this.computeUniqueArchiveURI(folder);
        try {
            return this.getArchiveFactory().primOpenArchive(options, uri);
        }
        catch (OpenFailureException ex) {
            throw new ArchiveRuntimeException((Exception)((Object)ex));
        }
    }

    private String computeUniqueArchiveURI(IFolder folder) {
        int increment = 0;
        String name = folder.getName();
        StringBuffer sb = null;
        do {
            sb = new StringBuffer(name.length() + 5);
            sb.append('_');
            sb.append(name);
            if (increment > 0) {
                sb.append(increment);
            }
            sb.append(".jar");
            ++increment;
        } while (this.visitedURIs.contains(sb.toString()));
        return sb.toString();
    }

    private boolean gatherFilesForJAR(List iFiles, IFolder current, IFolder root, boolean isModuleRoot, boolean foundJava) {
        IResource[] members;
        try {
            members = current.members();
        }
        catch (CoreException core) {
            throw new ArchiveRuntimeException((Exception)((Object)core));
        }
        int i = 0;
        while (i < members.length) {
            IResource res = members[i];
            if (res.getType() == 2) {
                foundJava = this.gatherFilesForJAR(iFiles, (IFolder)res, root, isModuleRoot, foundJava) || foundJava;
            } else {
                IFile iFile = (IFile)res;
                this.checkInnerClass(iFile);
                if (this.belongsInNestedJAR(iFile, root, isModuleRoot)) {
                    iFiles.add(iFile);
                    if (isModuleRoot) {
                        foundJava = foundJava || this.isJava(iFile) || this.isClass(iFile);
                    }
                }
            }
            ++i;
        }
        return foundJava;
    }

    private void checkInnerClass(IFile iFile) {
        if (!this.isClass(iFile)) {
            return;
        }
        String name = iFile.getName();
        if (name.indexOf(36) != -1) {
            if (this.innerClasses == null) {
                this.innerClasses = new HashMap();
            }
            IPath relPath = iFile.getProjectRelativePath().removeFirstSegments(this.moduleRootSegmentCount);
            String key = relPath.toString();
            ArrayList<IFile> inners = (ArrayList<IFile>)this.innerClasses.get(key = key.substring(0, key.indexOf(36)));
            if (inners == null) {
                inners = new ArrayList<IFile>(1);
                this.innerClasses.put(key, inners);
            }
            inners.add(iFile);
        }
    }

    public List retrieveInnerClasses(String key) {
        if (this.innerClasses == null) {
            return null;
        }
        return (List)this.innerClasses.get(key);
    }

    public boolean isJava(IFile iFile) {
        return this.hasExtension(iFile, ".java");
    }

    public boolean isClass(IFile iFile) {
        return this.hasExtension(iFile, ".class");
    }

    private boolean hasExtension(IFile iFile, String ext) {
        String name = iFile.getName();
        return this.hasExtension(name, ext);
    }

    private boolean hasExtension(String name, String ext) {
        int offset = ext.length();
        return name.regionMatches(true, name.length() - offset, ext, 0, offset);
    }

    protected boolean shouldInclude(String uri) {
        return !this.hasExtension(uri, ".class") && !this.hasExtension(uri, ".java");
    }

    private boolean belongsInNestedJAR(IFile iFile, IFolder root, boolean isModuleRoot) {
        int i = 0;
        while (i < knownLibExtensions.length) {
            if (this.hasExtension(iFile, knownLibExtensions[i]) || isModuleRoot && (this.isDeploymentDescriptor(iFile, root) || this.isClassWithSource(iFile))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isClassWithSource(IFile iFile) {
        return this.isClass(iFile) && this.hasSource(iFile);
    }

    private boolean hasSource(IFile classFile) {
        IPath path = classFile.getProjectRelativePath().removeFirstSegments(this.moduleRootSegmentCount);
        String baseURI = ArchiveUtil.classUriToJavaUri((String)path.toString());
        return this.moduleRoot.getFile((IPath)new Path(baseURI)).exists();
    }

    private boolean isDeploymentDescriptor(IFile iFile, IFolder root) {
        IPath path = iFile.getProjectRelativePath().removeFirstSegments(this.moduleRootSegmentCount);
        return "META-INF/ra.xml".equals(path.toString());
    }

    public IContainer getModuleContainer() {
        return this.moduleRoot;
    }

    public IContainer getModuleRoot() {
        return this.moduleRoot;
    }

    protected void init() {
        ConnectorNatureRuntime connRT = ConnectorNatureRuntime.getRuntime(this.getProject());
        this.moduleRoot = connRT.getModuleServerRoot();
        this.projectURIConverter = new WorkbenchURIConverterImpl(this.moduleRoot);
        this.moduleRootSegmentCount = this.moduleRoot.getProjectRelativePath().segmentCount();
    }

    public WorkbenchURIConverter getProjectURIConverter() {
        return this.projectURIConverter;
    }

    public int getModuleRootSegmentCount() {
        return this.moduleRootSegmentCount;
    }
}

