/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.wst.sse.ui.internal.ISourceViewerActionBarContributor;
import org.eclipse.wst.sse.ui.internal.StructuredTextEditor;
import org.eclipse.wst.xsd.ui.internal.XSDEditor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.XSDTextEditor;
import org.eclipse.wst.xsd.ui.internal.actions.DeleteAction;
import org.eclipse.wst.xsd.ui.internal.actions.ReloadDependenciesAction;
import org.eclipse.wst.xsd.ui.internal.actions.SourcePageActionContributor;
import org.osgi.framework.Bundle;

public class XSDActionBarContributor
extends MultiPageEditorActionBarContributor {
    protected XSDEditor xsdEditor;
    protected XSDTextEditor textEditor;
    protected IEditorActionBarContributor sourceViewerActionContributor = null;
    protected ReloadDependenciesAction reloadDependenciesAction;
    protected List fPartListeners = new ArrayList();
    protected RetargetAction retargetReloadDependenciesAction;
    private RetargetTextEditorAction renameElementAction = null;
    private IMenuManager refactorMenu = null;
    private IMenuManager editMenu;

    public XSDActionBarContributor() {
        this.sourceViewerActionContributor = new SourcePageActionContributor();
        this.reloadDependenciesAction = new ReloadDependenciesAction(XSDEditorPlugin.getXSDString("_UI_MENU_RELOAD_DEPENDENCIES"));
        this.retargetReloadDependenciesAction = new RetargetAction("retargetReloadDependenciesAction", XSDEditorPlugin.getXSDString("_UI_MENU_RELOAD_DEPENDENCIES"));
        this.retargetReloadDependenciesAction.setToolTipText(XSDEditorPlugin.getXSDString("_UI_MENU_RELOAD_DEPENDENCIES_TOOLTIP"));
        this.retargetReloadDependenciesAction.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)XSDEditorPlugin.getPlugin())).getClass(), (String)"icons/reloadgrammar.gif"));
        this.fPartListeners.add(this.retargetReloadDependenciesAction);
        ResourceBundle bundle = Platform.getResourceBundle((Bundle)XSDEditorPlugin.getPlugin().getBundle());
        this.renameElementAction = new RetargetTextEditorAction(bundle, "RenameElement.");
        this.renameElementAction.setActionDefinitionId("org.eclipse.wst.xsd.ui.refactor.rename.element");
        this.refactorMenu = new MenuManager(XSDEditorPlugin.getXSDString("refactoring.menu.label"), "org.eclipse.wst.xsd.ui.refactoring.menu");
        this.refactorMenu.add((IAction)this.renameElementAction);
    }

    protected void updateActions() {
        if (this.xsdEditor != null && this.xsdEditor.getCurrentPageType().equals(XSDEditorPlugin.GRAPH_PAGE)) {
            DeleteAction deleteAction = this.xsdEditor.getGraphViewer().getComponentViewer().getMenuListener().getDeleteAction();
            this.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)deleteAction);
            Action printGraphAction = this.xsdEditor.getGraphViewer().getPrintGraphAction();
            this.getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)printGraphAction);
        } else {
            this.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
            this.updateAction(ActionFactory.PRINT.getId(), ITextEditorActionConstants.PRINT, true);
        }
    }

    public void setActivePage(IEditorPart activeEditor) {
        this.updateActions();
        if (activeEditor != null && activeEditor instanceof StructuredTextEditor) {
            this.activateSourcePage(activeEditor, true);
        } else {
            this.activateSourcePage((IEditorPart)this.xsdEditor, false);
        }
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            actionBars.updateActionBars();
        }
        this.updateAction("undo", ITextEditorActionConstants.UNDO, true);
        this.updateAction("redo", ITextEditorActionConstants.REDO, true);
        this.getActionBars().updateActionBars();
    }

    protected void activateSourcePage(IEditorPart activeEditor, boolean state) {
        if (this.sourceViewerActionContributor != null && this.sourceViewerActionContributor instanceof ISourceViewerActionBarContributor) {
            this.sourceViewerActionContributor.setActiveEditor(activeEditor);
            ((ISourceViewerActionBarContributor)this.sourceViewerActionContributor).setViewerSpecificContributionsEnabled(state);
        }
    }

    protected void updateAction(String globalActionId, String textEditorActionId, boolean enable) {
        this.getActionBars().setGlobalActionHandler(globalActionId, enable ? this.getAction((ITextEditor)this.textEditor, textEditorActionId) : null);
    }

    protected IAction getAction(ITextEditor editor, String actionID) {
        try {
            return editor == null ? null : editor.getAction(actionID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addToMenu(IMenuManager menuManager) {
        this.editMenu = menuManager.findMenuUsingPath("edit");
        MenuManager treeMenu = new MenuManager(XSDEditorPlugin.getXSDString("_UI_MENU_XSD_EDITOR"));
        menuManager.insertAfter("additions", (IContributionItem)treeMenu);
        treeMenu.add((IContributionItem)new Separator("group1"));
        treeMenu.add((IAction)this.retargetReloadDependenciesAction);
        treeMenu.add((IContributionItem)new Separator("group2"));
    }

    public void addToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("XMLSchema.2"));
        toolBarManager.add((IAction)this.retargetReloadDependenciesAction);
        toolBarManager.add((IContributionItem)new Separator("XMLSchema.1"));
        toolBarManager.add((IContributionItem)new Separator());
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        this.addToToolBar(toolBarManager);
    }

    public void contributeToMenu(IMenuManager menuManager) {
        this.addToMenu(menuManager);
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (targetEditor instanceof XSDEditor) {
            this.xsdEditor = (XSDEditor)targetEditor;
            this.reloadDependenciesAction.setEditor((XSDEditor)targetEditor);
            this.textEditor = ((XSDEditor)targetEditor).getXSDTextEditor();
            if (this.textEditor != null) {
                this.renameElementAction.setAction(this.getAction((ITextEditor)this.textEditor, "RenameElement"));
                this.updateActions();
                this.getActionBars().updateActionBars();
            }
        }
        super.setActiveEditor(targetEditor);
        this.updateAction("undo", ITextEditorActionConstants.UNDO, true);
        this.updateAction("redo", ITextEditorActionConstants.REDO, true);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        Iterator e = this.fPartListeners.iterator();
        while (e.hasNext()) {
            page.addPartListener((IPartListener)((RetargetAction)e.next()));
        }
        bars.setGlobalActionHandler("retargetReloadDependenciesAction", (IAction)this.reloadDependenciesAction);
        this.initSourceViewerActionContributor(bars);
        super.init(bars, page);
    }

    protected void initSourceViewerActionContributor(IActionBars actionBars) {
        if (this.sourceViewerActionContributor != null) {
            this.sourceViewerActionContributor.init(actionBars, this.getPage());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.sourceViewerActionContributor != null) {
            this.sourceViewerActionContributor.dispose();
        }
    }
}

