/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.wst.xsd.ui.internal.actions.CreateElementAction;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CreateAttributeAndRequired
extends Action {
    String elementTag;
    String label;
    List attributes;
    XSDSchema xsdSchema;
    ISelectionProvider selectionProvider;
    Object parent;

    public CreateAttributeAndRequired(String elementTag, String label, List attributes, XSDSchema xsdSchema, ISelectionProvider selProvider, Object parent) {
        super(label);
        this.elementTag = elementTag;
        this.label = label;
        this.attributes = attributes;
        this.xsdSchema = xsdSchema;
        this.selectionProvider = selProvider;
        this.parent = parent;
    }

    public void run() {
        if (this.parent instanceof XSDElementDeclaration) {
            XSDElementDeclaration ed = (XSDElementDeclaration)this.parent;
            this.beginRecording(ed.getElement());
            ed.setTypeDefinition(null);
            XSDComplexTypeDefinition td = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            ed.setAnonymousTypeDefinition((XSDTypeDefinition)td);
            CreateElementAction action = new CreateElementAction(this.label);
            action.setElementTag(this.elementTag);
            action.setAttributes(this.attributes);
            action.setParentNode(td.getElement());
            action.setRelativeNode(null);
            action.setXSDSchema(this.xsdSchema);
            action.setSelectionProvider(this.selectionProvider);
            action.run();
            this.formatChild(td.getElement());
            if (td.getAttributeContents().size() > 0) {
                this.selectObject(td.getAttributeContents().get(0));
            }
            this.endRecording(ed.getElement());
        }
    }

    protected void beginRecording(Element element) {
        ((DocumentImpl)element.getOwnerDocument()).getModel().beginRecording((Object)this, this.getText());
    }

    protected void endRecording(Element element) {
        ((DocumentImpl)element.getOwnerDocument()).getModel().endRecording((Object)this);
    }

    public void selectObject(Object object) {
        if (this.selectionProvider != null) {
            this.selectionProvider.setSelection((ISelection)new StructuredSelection(object));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void formatChild(Element child) {
        if (!(child instanceof IDOMNode)) return;
        IDOMModel model = ((IDOMNode)child).getModel();
        try {
            model.aboutToChangeModel();
            FormatProcessorXML formatProcessor = new FormatProcessorXML();
            formatProcessor.formatNode((Node)child);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            model.changedModel();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        model.changedModel();
    }
}

