/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.OptionsTextCellEditor;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.wst.xsd.ui.internal.widgets.TypeSection;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypesPropertyDescriptor
extends PropertyDescriptor {
    Element element;
    XSDSchema xsdSchema;
    String property;
    boolean showComplexTypes = true;

    public TypesPropertyDescriptor(Object id, String displayName, Element element, XSDSchema xsdSchema) {
        super(id, displayName);
        this.property = (String)id;
        this.element = element;
        this.xsdSchema = xsdSchema;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (XSDDOMHelper.inputEquals(this.element, "element", false)) {
            this.showComplexTypes = true;
        } else if (XSDDOMHelper.inputEquals(this.element, "attribute", false) || XSDDOMHelper.inputEquals(this.element, "list", false) || XSDDOMHelper.inputEquals(this.element, "union", false)) {
            this.showComplexTypes = false;
        }
        TypesDialogCellEditor editor = new TypesDialogCellEditor(parent);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    public class TypesDialogCellEditor
    extends DialogCellEditor {
        protected TypesDialogCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            Shell shell = Display.getCurrent().getActiveShell();
            TypesDialog dialog = new TypesDialog(shell);
            dialog.setBlockOnOpen(true);
            dialog.create();
            String value = (String)this.getValue();
            int result = dialog.open();
            if (result == 0) {
                value = dialog.getType();
                this.doSetValue(value);
                this.fireApplyEditorValue();
            }
            this.deactivate();
            return null;
        }
    }

    public class TypesDialog
    extends Dialog
    implements SelectionListener {
        String type;
        Object typeObject;
        Table table;
        TypeSection typeSection;
        boolean showAnonymous = true;
        String previousStringType = "";
        boolean isAnonymous;
        int previousType;

        public TypesDialog(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.type = this.table.getItem(this.table.getSelectionIndex()).getText();
                this.ok();
            }
            super.buttonPressed(buttonId);
        }

        public Object getTypeObject() {
            return this.typeObject;
        }

        public String getType() {
            return this.type;
        }

        public Control createDialogArea(Composite parent) {
            Composite client = (Composite)super.createDialogArea(parent);
            this.getShell().setText(XSDEditorPlugin.getXSDString("_UI_LABEL_AVAILABLE_TYPES"));
            this.typeObject = null;
            GridLayout gl = new GridLayout(1, true);
            client.setLayout((Layout)gl);
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 4;
            gd.horizontalIndent = 0;
            client.setLayoutData((Object)gd);
            this.typeSection = new TypeSection(client);
            this.typeSection.setShowUserComplexType(TypesPropertyDescriptor.this.showComplexTypes);
            this.typeSection.createClient(client);
            this.typeSection.getSimpleType().setSelection(false);
            this.typeSection.getSimpleType().addSelectionListener((SelectionListener)this);
            this.typeSection.getUserSimpleType().addSelectionListener((SelectionListener)this);
            if (TypesPropertyDescriptor.this.showComplexTypes) {
                this.typeSection.getUserComplexType().addSelectionListener((SelectionListener)this);
            }
            this.table = new Table(client, 66308);
            this.table.setHeaderVisible(false);
            this.table.setLinesVisible(true);
            GridData gd2 = new GridData();
            gd2.grabExcessHorizontalSpace = true;
            gd2.grabExcessVerticalSpace = true;
            gd2.horizontalAlignment = 4;
            gd2.heightHint = 200;
            this.table.setLayoutData((Object)gd2);
            TableColumn tableColumn = new TableColumn(this.table, 16384);
            tableColumn.setResizable(true);
            tableColumn.setWidth(200);
            this.handleSetInput();
            return client;
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.typeSection.getSimpleType() && this.typeSection.getSimpleType().getSelection()) {
                this.populateBuiltInType();
            } else if (e.widget == this.typeSection.getUserComplexType() && this.typeSection.getUserComplexType().getSelection()) {
                this.populateUserComplexType();
            } else if (e.widget == this.typeSection.getUserSimpleType() && this.typeSection.getUserSimpleType().getSelection()) {
                this.populateUserSimpleType();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        protected void ok() {
            TableItem[] items = this.table.getItems();
            int selection = this.table.getSelectionIndex();
            if (items != null && items.length > 0 && selection >= 0) {
                this.typeObject = items[selection].getData();
            }
            if (!XSDDOMHelper.inputEquals(TypesPropertyDescriptor.this.element, "union", false)) {
                if (this.typeObject.equals("**anonymous**")) {
                    if (this.typeSection.getUserSimpleType().getSelection()) {
                        if (!this.previousStringType.equals("**anonymous**")) {
                            this.updateElementToAnonymous(TypesPropertyDescriptor.this.element, "simpleType");
                        }
                    } else if (!this.previousStringType.equals("**anonymous**")) {
                        this.updateElementToAnonymous(TypesPropertyDescriptor.this.element, "complexType");
                    }
                    TypesPropertyDescriptor.this.element.removeAttribute(TypesPropertyDescriptor.this.property);
                } else {
                    this.updateElementToNotAnonymous(TypesPropertyDescriptor.this.element);
                    TypesPropertyDescriptor.this.element.setAttribute(TypesPropertyDescriptor.this.property, this.typeObject.toString());
                }
            }
        }

        public void handleSetInput() {
            this.table.removeAll();
            this.isAnonymous = this.checkForAnonymousType(TypesPropertyDescriptor.this.element);
            Attr attr = TypesPropertyDescriptor.this.element.getAttributeNode(TypesPropertyDescriptor.this.property);
            if (attr != null) {
                String value = attr.getValue();
                if (this.typeSection.getBuiltInTypeNamesList(TypesPropertyDescriptor.this.xsdSchema).contains(value)) {
                    this.typeSection.getSimpleType().setSelection(true);
                    this.populateBuiltInType();
                    int i = this.typeSection.getBuiltInTypeNamesList(TypesPropertyDescriptor.this.xsdSchema).indexOf(value);
                    this.table.setSelection(i);
                    this.previousType = 1;
                } else if (this.typeSection.getUserSimpleTypeNamesList(TypesPropertyDescriptor.this.xsdSchema).contains(value)) {
                    this.typeSection.getUserSimpleType().setSelection(true);
                    this.populateUserSimpleType();
                    int i = this.typeSection.getUserSimpleTypeNamesList(TypesPropertyDescriptor.this.xsdSchema).indexOf(value);
                    if (this.showAnonymous) {
                        this.table.setSelection(i + 1);
                    } else {
                        this.table.setSelection(i);
                    }
                    this.previousType = 2;
                } else if (this.typeSection.getUserComplexTypeNamesList(TypesPropertyDescriptor.this.xsdSchema).contains(value)) {
                    this.typeSection.getUserComplexType().setSelection(true);
                    this.populateUserComplexType();
                    int i = this.typeSection.getUserComplexTypeNamesList(TypesPropertyDescriptor.this.xsdSchema).indexOf(value);
                    if (this.showAnonymous) {
                        this.table.setSelection(i + 1);
                    } else {
                        this.table.setSelection(i);
                    }
                    this.previousType = 3;
                } else {
                    this.typeSection.getUserSimpleType().setSelection(true);
                    this.populateUserSimpleType();
                    this.previousType = 2;
                }
            } else if (this.isAnonymous) {
                if (this.isSTAnonymous(TypesPropertyDescriptor.this.element)) {
                    this.typeSection.getUserSimpleType().setSelection(true);
                    this.populateUserSimpleType();
                    this.previousType = 2;
                } else {
                    this.typeSection.getUserComplexType().setSelection(true);
                    this.populateUserComplexType();
                    this.previousType = 3;
                }
                this.table.setSelection(0);
            } else {
                this.typeSection.getSimpleType().setSelection(true);
                this.populateBuiltInType();
                this.table.setSelection(0);
                this.previousType = 1;
            }
            if (this.table.getSelection() != null && this.table.getSelection().length > 0) {
                this.previousStringType = this.table.getSelection()[0].getText();
            }
        }

        public void populateBuiltInType() {
            this.table.removeAll();
            List items = this.getBuiltInTypeNamesList();
            int i = 0;
            while (i < items.size()) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(items.get(i).toString());
                item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif"));
                item.setData(items.get(i));
                ++i;
            }
        }

        public void populateUserComplexType() {
            this.table.removeAll();
            if (this.showAnonymous) {
                TableItem anonymousItem = new TableItem(this.table, 0);
                anonymousItem.setText("**anonymous**");
                anonymousItem.setData((Object)"**anonymous**");
            }
            List items = this.getUserComplexTypeNamesList();
            int i = 0;
            while (i < items.size()) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(items.get(i).toString());
                item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDComplexType.gif"));
                item.setData(items.get(i));
                ++i;
            }
        }

        public void populateUserSimpleType() {
            this.table.removeAll();
            if (this.showAnonymous) {
                TableItem anonymousItem = new TableItem(this.table, 0);
                anonymousItem.setText("**anonymous**");
                anonymousItem.setData((Object)"**anonymous**");
            }
            List items = this.getUserSimpleTypeNamesList();
            int i = 0;
            while (i < items.size()) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(items.get(i).toString());
                item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif"));
                item.setData(items.get(i));
                ++i;
            }
        }

        boolean checkForAnonymousType(Element element) {
            XSDDOMHelper helper = new XSDDOMHelper();
            boolean isAnonymous = false;
            Node aNode = helper.getChildNode(element, "simpleType");
            if (aNode != null) {
                return true;
            }
            aNode = helper.getChildNode(element, "complexType");
            if (aNode != null) {
                isAnonymous = true;
            }
            return isAnonymous;
        }

        void updateElementToAnonymous(Element element, String xsdType) {
            String prefix = element.getPrefix();
            prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
            this.updateElementToNotAnonymous(element);
            this.hasElementChildren(element);
            Element childNode = null;
            if (xsdType.equals("complexType")) {
                childNode = element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + "complexType");
            } else if (xsdType.equals("simpleType")) {
                childNode = element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + "simpleType");
            }
            element.appendChild(childNode);
        }

        boolean isSTAnonymous(Element element) {
            XSDDOMHelper helper = new XSDDOMHelper();
            Node aNode = helper.getChildNode(element, "simpleType");
            return aNode != null && XSDDOMHelper.inputEquals(aNode, "simpleType", false);
        }

        boolean isCTAnonymous(Element element) {
            XSDDOMHelper helper = new XSDDOMHelper();
            Node aNode = helper.getChildNode(element, "complexType");
            return aNode != null && XSDDOMHelper.inputEquals(aNode, "complexType", false);
        }

        XSDTypeDefinition getAnonymousTypeDefinition(Element element) {
            XSDConcreteComponent component;
            XSDDOMHelper helper = new XSDDOMHelper();
            Node typeDefinitionNode = helper.getChildNode(element, "simpleType");
            if (typeDefinitionNode == null) {
                typeDefinitionNode = helper.getChildNode(element, "complexType");
            }
            if (typeDefinitionNode != null && (component = TypesPropertyDescriptor.this.xsdSchema.getCorrespondingComponent(typeDefinitionNode)) instanceof XSDTypeDefinition) {
                return (XSDTypeDefinition)component;
            }
            return null;
        }

        void updateElementToNotAnonymous(Element element) {
            NodeList children;
            if (element != null && (children = element.getChildNodes()) != null) {
                int i = 0;
                while (i < children.getLength()) {
                    Node node = children.item(i);
                    if (node instanceof Element && (node.getLocalName().equals("simpleType") || node.getLocalName().equals("complexType"))) {
                        XSDDOMHelper.removeNodeAndWhitespace(node);
                        i = 0;
                    }
                    ++i;
                }
            }
        }

        public List getBuiltInTypeNamesList() {
            TypesHelper helper = new TypesHelper(TypesPropertyDescriptor.this.xsdSchema);
            return helper.getBuiltInTypeNamesList();
        }

        public List getUserSimpleTypeNamesList() {
            TypesHelper helper = new TypesHelper(TypesPropertyDescriptor.this.xsdSchema);
            return helper.getUserSimpleTypeNamesList();
        }

        public List getUserComplexTypeNamesList() {
            TypesHelper helper = new TypesHelper(TypesPropertyDescriptor.this.xsdSchema);
            return helper.getUserComplexTypeNamesList();
        }

        protected boolean hasElementChildren(Node parentNode) {
            boolean hasChildrenElements = false;
            if (parentNode != null && parentNode.hasChildNodes()) {
                NodeList nodes = parentNode.getChildNodes();
                int i = 0;
                while (i < nodes.getLength()) {
                    if (nodes.item(i) instanceof Element) {
                        hasChildrenElements = true;
                        break;
                    }
                    ++i;
                }
            }
            return hasChildrenElements;
        }
    }

    class TypesOptionsTextCellEditor
    extends OptionsTextCellEditor {
        boolean showAnonymous = true;
        Table table;
        TypeSection typeSection;
        String previousStringType = "";
        boolean isAnonymous;
        int previousType;

        public TypesOptionsTextCellEditor(Composite parent) {
            super(parent);
        }

        protected Control createControl(Composite parent) {
            this.isTextReadOnly = true;
            return super.createControl(parent);
        }

        /*
         * Exception decompiling
         */
        protected void openDialog() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 630->634)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.typeSection.getSimpleType() && this.typeSection.getSimpleType().getSelection()) {
                this.populateBuiltInType();
            } else if (e.widget == this.typeSection.getUserComplexType() && this.typeSection.getUserComplexType().getSelection()) {
                this.populateUserComplexType();
            } else if (e.widget == this.typeSection.getUserSimpleType() && this.typeSection.getUserSimpleType().getSelection()) {
                this.populateUserSimpleType();
            }
        }

        protected void cancel() {
            super.cancel();
            this.table.dispose();
        }

        protected void ok() {
            TableItem[] items = this.table.getItems();
            this.selection = this.table.getSelectionIndex();
            if (items != null && items.length > 0 && this.selection >= 0) {
                this.typeObject = items[this.selection].getData();
            }
            this.doSetValue(this.typeObject);
            this.applyEditorValueAndDeactivate();
            this.dialog.close();
            if (!XSDDOMHelper.inputEquals(TypesPropertyDescriptor.this.element, "union", false)) {
                if (this.typeObject.equals("**anonymous**")) {
                    if (this.typeSection.getUserSimpleType().getSelection()) {
                        if (!this.previousStringType.equals("**anonymous**")) {
                            this.updateElementToAnonymous(TypesPropertyDescriptor.this.element, "simpleType");
                        }
                    } else if (!this.previousStringType.equals("**anonymous**")) {
                        this.updateElementToAnonymous(TypesPropertyDescriptor.this.element, "complexType");
                    }
                    TypesPropertyDescriptor.this.element.removeAttribute(TypesPropertyDescriptor.this.property);
                } else {
                    this.updateElementToNotAnonymous(TypesPropertyDescriptor.this.element);
                    TypesPropertyDescriptor.this.element.setAttribute(TypesPropertyDescriptor.this.property, this.typeObject.toString());
                }
            }
            this.table.removeAll();
            this.table.dispose();
        }

        public void handleSetInput() {
            this.table.removeAll();
            this.isAnonymous = this.checkForAnonymousType(TypesPropertyDescriptor.this.element);
            Attr attr = TypesPropertyDescriptor.this.element.getAttributeNode(TypesPropertyDescriptor.this.property);
            if (attr != null) {
                String value = attr.getValue();
                if (this.typeSection.getBuiltInTypeNamesList(TypesPropertyDescriptor.this.xsdSchema).contains(value)) {
                    this.typeSection.getSimpleType().setSelection(true);
                    this.populateBuiltInType();
                    int i = this.typeSection.getBuiltInTypeNamesList(TypesPropertyDescriptor.this.xsdSchema).indexOf(value);
                    this.table.setSelection(i);
                    this.previousType = 1;
                } else if (this.typeSection.getUserSimpleTypeNamesList(TypesPropertyDescriptor.this.xsdSchema).contains(value)) {
                    this.typeSection.getUserSimpleType().setSelection(true);
                    this.populateUserSimpleType();
                    int i = this.typeSection.getUserSimpleTypeNamesList(TypesPropertyDescriptor.this.xsdSchema).indexOf(value);
                    if (this.showAnonymous) {
                        this.table.setSelection(i + 1);
                    } else {
                        this.table.setSelection(i);
                    }
                    this.previousType = 2;
                } else if (this.typeSection.getUserComplexTypeNamesList(TypesPropertyDescriptor.this.xsdSchema).contains(value)) {
                    this.typeSection.getUserComplexType().setSelection(true);
                    this.populateUserComplexType();
                    int i = this.typeSection.getUserComplexTypeNamesList(TypesPropertyDescriptor.this.xsdSchema).indexOf(value);
                    if (this.showAnonymous) {
                        this.table.setSelection(i + 1);
                    } else {
                        this.table.setSelection(i);
                    }
                    this.previousType = 3;
                } else {
                    this.typeSection.getUserSimpleType().setSelection(true);
                    this.populateUserSimpleType();
                    this.previousType = 2;
                }
            } else if (this.isAnonymous) {
                if (this.isSTAnonymous(TypesPropertyDescriptor.this.element)) {
                    this.typeSection.getUserSimpleType().setSelection(true);
                    this.populateUserSimpleType();
                    this.previousType = 2;
                } else {
                    this.typeSection.getUserComplexType().setSelection(true);
                    this.populateUserComplexType();
                    this.previousType = 3;
                }
                this.table.setSelection(0);
            } else {
                this.typeSection.getSimpleType().setSelection(true);
                this.populateBuiltInType();
                this.table.setSelection(0);
                this.previousType = 1;
            }
            if (this.table.getSelection() != null && this.table.getSelection().length > 0) {
                this.previousStringType = this.table.getSelection()[0].getText();
            }
        }

        public void populateBuiltInType() {
            this.table.removeAll();
            List items = this.getBuiltInTypeNamesList();
            int i = 0;
            while (i < items.size()) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(items.get(i).toString());
                item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif"));
                item.setData(items.get(i));
                ++i;
            }
        }

        public void populateUserComplexType() {
            this.table.removeAll();
            if (this.showAnonymous) {
                TableItem anonymousItem = new TableItem(this.table, 0);
                anonymousItem.setText("**anonymous**");
                anonymousItem.setData((Object)"**anonymous**");
            }
            List items = this.getUserComplexTypeNamesList();
            int i = 0;
            while (i < items.size()) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(items.get(i).toString());
                item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDComplexType.gif"));
                item.setData(items.get(i));
                ++i;
            }
        }

        public void populateUserSimpleType() {
            this.table.removeAll();
            if (this.showAnonymous) {
                TableItem anonymousItem = new TableItem(this.table, 0);
                anonymousItem.setText("**anonymous**");
                anonymousItem.setData((Object)"**anonymous**");
            }
            List items = this.getUserSimpleTypeNamesList();
            int i = 0;
            while (i < items.size()) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(items.get(i).toString());
                item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif"));
                item.setData(items.get(i));
                ++i;
            }
        }

        boolean checkForAnonymousType(Element element) {
            XSDDOMHelper helper = new XSDDOMHelper();
            boolean isAnonymous = false;
            Node aNode = helper.getChildNode(element, "simpleType");
            if (aNode != null) {
                return true;
            }
            aNode = helper.getChildNode(element, "complexType");
            if (aNode != null) {
                isAnonymous = true;
            }
            return isAnonymous;
        }

        void updateElementToAnonymous(Element element, String xsdType) {
            String prefix = element.getPrefix();
            prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
            this.updateElementToNotAnonymous(element);
            this.hasElementChildren(element);
            Element childNode = null;
            if (xsdType.equals("complexType")) {
                childNode = element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + "complexType");
            } else if (xsdType.equals("simpleType")) {
                childNode = element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + "simpleType");
            }
            element.appendChild(childNode);
        }

        boolean isSTAnonymous(Element element) {
            XSDDOMHelper helper = new XSDDOMHelper();
            Node aNode = helper.getChildNode(element, "simpleType");
            return aNode != null && XSDDOMHelper.inputEquals(aNode, "simpleType", false);
        }

        boolean isCTAnonymous(Element element) {
            XSDDOMHelper helper = new XSDDOMHelper();
            Node aNode = helper.getChildNode(element, "complexType");
            return aNode != null && XSDDOMHelper.inputEquals(aNode, "complexType", false);
        }

        XSDTypeDefinition getAnonymousTypeDefinition(Element element) {
            XSDConcreteComponent component;
            XSDDOMHelper helper = new XSDDOMHelper();
            Node typeDefinitionNode = helper.getChildNode(element, "simpleType");
            if (typeDefinitionNode == null) {
                typeDefinitionNode = helper.getChildNode(element, "complexType");
            }
            if (typeDefinitionNode != null && (component = TypesPropertyDescriptor.this.xsdSchema.getCorrespondingComponent(typeDefinitionNode)) instanceof XSDTypeDefinition) {
                return (XSDTypeDefinition)component;
            }
            return null;
        }

        void updateElementToNotAnonymous(Element element) {
            NodeList children = element.getChildNodes();
            if (children != null) {
                int i = 0;
                while (i < children.getLength()) {
                    Node node = children.item(i);
                    if (node instanceof Element && (node.getLocalName().equals("simpleType") || node.getLocalName().equals("complexType"))) {
                        XSDDOMHelper.removeNodeAndWhitespace(node);
                        i = 0;
                    }
                    ++i;
                }
            }
        }

        public List getBuiltInTypeNamesList() {
            TypesHelper helper = new TypesHelper(TypesPropertyDescriptor.this.xsdSchema);
            return helper.getBuiltInTypeNamesList();
        }

        public List getUserSimpleTypeNamesList() {
            TypesHelper helper = new TypesHelper(TypesPropertyDescriptor.this.xsdSchema);
            return helper.getUserSimpleTypeNamesList();
        }

        public List getUserComplexTypeNamesList() {
            TypesHelper helper = new TypesHelper(TypesPropertyDescriptor.this.xsdSchema);
            return helper.getUserComplexTypeNamesList();
        }

        protected boolean hasElementChildren(Node parentNode) {
            boolean hasChildrenElements = false;
            if (parentNode != null && parentNode.hasChildNodes()) {
                NodeList nodes = parentNode.getChildNodes();
                int i = 0;
                while (i < nodes.getLength()) {
                    if (nodes.item(i) instanceof Element) {
                        hasChildrenElements = true;
                        break;
                    }
                    ++i;
                }
            }
            return hasChildrenElements;
        }
    }
}

