/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.tests.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.eclipse.wst.wsi.internal.WSIPreferences;
import org.eclipse.wst.wsi.internal.analyzer.WSDLAnalyzer;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLReaderImpl;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.eclipse.wst.wsi.internal.report.AssertionError;
import org.eclipse.wst.wsi.tests.internal.WSITestsPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CoreWSDLConformanceTest
extends TestCase {
    public static final String WSDL_BASE_DIRECTORY = "testResources/samples/wsdl";
    public static final String TEST_CASE_FILE = "testcase.xml";
    public static final String WSDL_EXTENSION = ".wsdl";
    public static final String TAD_ID_AP = "AP10";
    public static final String TAD_ID_SSBP = "SSBP10";
    protected String pluginURI = WSITestsPlugin.getInstallURL();
    protected String tadID = "AP10";

    public CoreWSDLConformanceTest(String name) {
        super(name);
    }

    protected void setup() {
    }

    protected void runTest(String category, String testName, String tadID) {
        this.tadID = tadID;
        CoreWSDLConformanceTest.assertNotNull((String)"Problems determining base url", (Object)this.pluginURI);
        String testDirectory = String.valueOf(this.pluginURI) + WSDL_BASE_DIRECTORY + "/" + category + "/" + testName;
        String wsdlFile = "file://" + testDirectory + "/" + testName + WSDL_EXTENSION;
        String testcaseFile = String.valueOf(testDirectory) + "/" + TEST_CASE_FILE;
        WSDLAnalyzer analyzer = this.validateConformance(wsdlFile, tadID);
        CoreWSDLConformanceTest.assertNotNull((String)"Unknown problems during validation", (Object)analyzer);
        List expectedErrors = this.getExpectedAssertionFailures(testcaseFile);
        CoreWSDLConformanceTest.assertNotNull((String)"Problems retrieving expected failures", (Object)expectedErrors);
        this.analyzeResults(analyzer.getAssertionErrors(), expectedErrors);
    }

    protected WSDLAnalyzer validateConformance(String filename, String tadID) {
        WSDLAnalyzer analyzer = null;
        try {
            WSIPreferences preferences = new WSIPreferences();
            preferences.setComplianceLevel("0");
            preferences.setTADFile(this.getTADURI(tadID));
            analyzer = new WSDLAnalyzer(filename, preferences);
            this.setConfigurations(filename, analyzer);
            analyzer.validateConformance();
        }
        catch (Exception exception) {
            return null;
        }
        return analyzer;
    }

    protected List getExpectedAssertionFailures(String filename) {
        ArrayList<String> assertionFailures = new ArrayList<String>();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(filename);
            NodeList list = doc.getElementsByTagName("assertion");
            if (list != null) {
                int i = 0;
                while (i < list.getLength()) {
                    Element element = (Element)list.item(i);
                    String tad = element.getAttribute("tadID");
                    if (tad != null && tad.equals(this.tadID)) {
                        assertionFailures.add(element.getAttribute("id"));
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            assertionFailures = null;
        }
        return assertionFailures;
    }

    protected void analyzeResults(List errors, List expectedErrors) {
        ArrayList<String> actualErrors = new ArrayList<String>();
        if (errors != null && expectedErrors != null) {
            Iterator i = errors.iterator();
            while (i.hasNext()) {
                AssertionError e = (AssertionError)i.next();
                String assertionId = e.getAssertionID();
                actualErrors.add(assertionId);
                if (expectedErrors.contains(assertionId)) continue;
                CoreWSDLConformanceTest.fail((String)("Unexpected assertion failure: " + assertionId));
            }
            i = expectedErrors.iterator();
            while (i.hasNext()) {
                String assertionId = (String)i.next();
                if (actualErrors.contains(assertionId)) continue;
                CoreWSDLConformanceTest.fail((String)("Expected assertion failure: " + assertionId));
            }
            CoreWSDLConformanceTest.assertEquals((int)expectedErrors.size(), (int)errors.size());
        }
    }

    protected void setConfigurations(String filename, WSDLAnalyzer analyzer) {
        block10: {
            try {
                WSDLReaderImpl wsdlReader = new WSDLReaderImpl();
                wsdlReader.setFeature("javax.wsdl.verbose", false);
                wsdlReader.setFeature("javax.wsdl.importDocuments", true);
                Document document = XMLUtils.parseXMLDocument((String)filename);
                Definition definition = wsdlReader.readWSDL(filename, document);
                String namespace = definition.getTargetNamespace();
                Collection services = definition.getServices().values();
                Collection bindings = definition.getBindings().values();
                Collection portTypes = definition.getPortTypes().values();
                Collection messages = definition.getMessages().values();
                if (services == null || services.isEmpty()) break block10;
                Iterator serviceIterator = services.iterator();
                while (serviceIterator.hasNext()) {
                    Service service = (Service)serviceIterator.next();
                    String servicename = service.getQName().getLocalPart();
                    Collection ports = service.getPorts().values();
                    if (ports != null && !ports.isEmpty()) {
                        Iterator portIterator = ports.iterator();
                        while (portIterator.hasNext()) {
                            Port port = (Port)portIterator.next();
                            analyzer.addConfigurationToTest(servicename, namespace, port.getName(), "port");
                        }
                        continue;
                    }
                    if (bindings != null && !bindings.isEmpty()) {
                        Iterator bindingIterator = bindings.iterator();
                        while (bindingIterator.hasNext()) {
                            Binding binding = (Binding)bindingIterator.next();
                            String bindingname = binding.getQName().getLocalPart();
                            analyzer.addConfigurationToTest(null, namespace, bindingname, "binding");
                        }
                        continue;
                    }
                    if (portTypes != null && !portTypes.isEmpty()) {
                        Iterator portTypeIterator = portTypes.iterator();
                        while (portTypeIterator.hasNext()) {
                            PortType portType = (PortType)portTypeIterator.next();
                            String portTypename = portType.getQName().getLocalPart();
                            analyzer.addConfigurationToTest(null, namespace, portTypename, "portType");
                        }
                        continue;
                    }
                    if (messages == null || messages.isEmpty()) continue;
                    Iterator messageIterator = messages.iterator();
                    while (messageIterator.hasNext()) {
                        Message message = (Message)messageIterator.next();
                        String messagename = message.getQName().getLocalPart();
                        analyzer.addConfigurationToTest(null, namespace, messagename, "message");
                    }
                }
            }
            catch (Exception exception) {
                CoreWSDLConformanceTest.fail((String)"Unexpected problems setting configurations");
            }
        }
    }

    protected String getTADURI(String tid) {
        if (tid.equals(TAD_ID_AP)) {
            return "http://www.ws-i.org/Testing/Tools/2004/12/AP10_BP11_SSBP10_TAD.xml";
        }
        return "http://www.ws-i.org/Testing/Tools/2005/01/SSBP10_BP11_TAD_1-0.xml";
    }
}

