/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentCreationDataModelProvider;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.AbstractStartServer;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateEARProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.WebServiceStartServerRegistry;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class CreateWebProjectCommand
extends SimpleCommand {
    private static final String DESCRIPTION = "TASK_DESC_CREATE_WEB_PROJECT";
    private static final String LABEL = "TASK_LABEL_CREATE_WEB_PROJECT";
    private final String DEFAULT_EAR_NAME = "WebServiceEAR";
    private String projectName_ = null;
    private String earProjectName_ = null;
    private boolean proxyCodegenEnabled = true;
    private String serverFactoryId_;
    private String j2eeVersion_;
    private IServer existingServer_;
    private boolean needEAR_;
    private boolean weAddedProjectToServer_ = false;
    private MessageUtils msgUtils_;

    public CreateWebProjectCommand() {
        super(LABEL, DESCRIPTION);
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
    }

    public CreateWebProjectCommand(String serviceProjectName) {
        super(LABEL, DESCRIPTION);
        this.projectName_ = serviceProjectName;
    }

    public Status execute(Environment env) {
        if (this.projectName_ == null || this.projectName_.length() == 0) {
            env.getLog().log(4, 5044, (Object)this, "execute", (Object)"Web project name not set");
            SimpleStatus status = new SimpleStatus("org.eclipse.jst.ws.consumption", this.msgUtils_.getMessage("MSG_ERROR_WEB_PROJECT_CREATE"), 4, null);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        if (this.existingServer_ == null) {
            env.getLog().log(4, 5044, (Object)this, "execute", (Object)"Server is null");
            SimpleStatus status = new SimpleStatus("org.eclipse.jst.ws.consumption", this.msgUtils_.getMessage("MSG_ERROR_WEB_PROJECT_CREATE"), 4, null);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject webProject = root.getProject(this.projectName_);
        IProject earProject = null;
        if (this.earProjectName_ != null && this.earProjectName_.length() > 0) {
            earProject = root.getProject(this.earProjectName_);
        }
        boolean projectExists = webProject != null && webProject.exists();
        boolean addedToServer = false;
        if (projectExists) {
            addedToServer = ServerUtil.containsModule((IServer)this.existingServer_, (IModule)ResourceUtils.getModule((IProject)webProject), (IProgressMonitor)new NullProgressMonitor());
        }
        boolean earExists = earProject != null && earProject.exists();
        boolean earAddedToServer = true;
        if (earExists) {
            earAddedToServer = ServerUtil.containsModule((IServer)this.existingServer_, (IModule)ResourceUtils.getModule((IProject)earProject), (IProgressMonitor)new NullProgressMonitor());
        }
        boolean areAssociated = false;
        if (projectExists && earExists) {
            areAssociated = J2EEUtils.isEARAssociated((IProject)webProject, (IProject)earProject);
        }
        boolean serverRequiresEARRemoval = true;
        try {
            if (this.serverFactoryId_ != null) {
                WebServiceStartServerRegistry wssReg = WebServiceStartServerRegistry.getInstance();
                serverRequiresEARRemoval = wssReg.isRemoveEARRequired(this.serverFactoryId_);
            }
        }
        catch (CoreException ce) {
            env.getLog().log(4, 5046, (Object)this, "execute", (Throwable)ce);
            SimpleStatus status = new SimpleStatus("org.eclipse.jst.ws.consumption", this.msgUtils_.getMessage("MSG_ERROR_WEB_PROJECT_CREATE"), 4, (Throwable)ce);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        if (!this.needEAR_ && projectExists && addedToServer && !this.weAddedProjectToServer_) {
            return new SimpleStatus("");
        }
        if (this.needEAR_ && projectExists && earExists && earAddedToServer && areAssociated && !this.weAddedProjectToServer_) {
            return new SimpleStatus("");
        }
        Status stoppingStatus = this.stopServer(env);
        if (stoppingStatus.getSeverity() == 4) {
            return stoppingStatus;
        }
        if (!this.needEAR_ && projectExists && addedToServer) {
            return new SimpleStatus("");
        }
        if (!this.needEAR_ && projectExists && !addedToServer) {
            Status mmStatus = ServerUtils.getInstance().modifyModules(env, this.existingServer_, ResourceUtils.getModule((IProject)webProject), true, (IProgressMonitor)new NullProgressMonitor());
            if (mmStatus.getSeverity() == 4) {
                return mmStatus;
            }
        } else if (!this.needEAR_ && !projectExists) {
            Status status = this.createWebProject(env);
            if (status.getSeverity() == 4) {
                return status;
            }
            webProject = root.getProject(this.projectName_);
            Status mmStatus = ServerUtils.getInstance().modifyModules(env, this.existingServer_, ResourceUtils.getModule((IProject)webProject), true, (IProgressMonitor)new NullProgressMonitor());
            if (mmStatus.getSeverity() == 4) {
                return mmStatus;
            }
        } else {
            if (projectExists && earExists && areAssociated && addedToServer) {
                return new SimpleStatus("");
            }
            if (projectExists && earExists && areAssociated && !addedToServer) {
                Status mmStatus = ServerUtils.getInstance().modifyModules(env, this.existingServer_, ResourceUtils.getModule((IProject)webProject), true, (IProgressMonitor)new NullProgressMonitor());
                if (mmStatus.getSeverity() == 4) {
                    return mmStatus;
                }
            } else if (projectExists && !earExists) {
                Status status = this.createEARProject(env);
                if (status.getSeverity() == 4) {
                    return status;
                }
                earProject = root.getProject(this.earProjectName_);
                J2EEUtils.associateWebProject((IProject)webProject, (IProject)earProject);
                Status mmStatus = ServerUtils.getInstance().modifyModules(env, this.existingServer_, ResourceUtils.getModule((IProject)webProject), true, (IProgressMonitor)new NullProgressMonitor());
                if (mmStatus.getSeverity() == 4) {
                    return mmStatus;
                }
            } else if (!projectExists && !earExists) {
                Status status = this.createEARProject(env);
                if (status.getSeverity() == 4) {
                    return status;
                }
                earProject = root.getProject(this.earProjectName_);
                status = this.createWebProject(env);
                if (status.getSeverity() == 4) {
                    return status;
                }
                webProject = root.getProject(this.projectName_);
                Status mmStatus = ServerUtils.getInstance().modifyModules(env, this.existingServer_, ResourceUtils.getModule((IProject)webProject), true, (IProgressMonitor)new NullProgressMonitor());
                if (mmStatus.getSeverity() == 4) {
                    return mmStatus;
                }
            } else if (!projectExists && earExists) {
                Status mmStatus;
                Status status;
                if (earAddedToServer && serverRequiresEARRemoval) {
                    Status mmStatus2;
                    if (this.existingServer_.getServerState() != 4) {
                        this.existingServer_.synchronousStop(false);
                    }
                    if ((mmStatus2 = ServerUtils.getInstance().modifyModules(env, this.existingServer_, ResourceUtils.getModule((IProject)earProject), false, (IProgressMonitor)new NullProgressMonitor())).getSeverity() == 4) {
                        return mmStatus2;
                    }
                }
                if ((status = this.createWebProject(env)).getSeverity() == 4) {
                    return status;
                }
                webProject = root.getProject(this.projectName_);
                boolean earAddedToServerFinal = ServerUtil.containsModule((IServer)this.existingServer_, (IModule)ResourceUtils.getModule((IProject)earProject), (IProgressMonitor)new NullProgressMonitor());
                if (!earAddedToServerFinal && (mmStatus = ServerUtils.getInstance().modifyModules(env, this.existingServer_, ResourceUtils.getModule((IProject)webProject), true, (IProgressMonitor)new NullProgressMonitor())).getSeverity() == 4) {
                    return mmStatus;
                }
            } else if (projectExists && earExists && !areAssociated) {
                Status mmStatus;
                if (earAddedToServer && serverRequiresEARRemoval) {
                    Status mmStatus3;
                    if (this.existingServer_.getServerState() != 4) {
                        this.existingServer_.synchronousStop(false);
                    }
                    if ((mmStatus3 = ServerUtils.getInstance().modifyModules(env, this.existingServer_, ResourceUtils.getModule((IProject)earProject), false, (IProgressMonitor)new NullProgressMonitor())).getSeverity() == 4) {
                        return mmStatus3;
                    }
                }
                J2EEUtils.associateWebProject((IProject)webProject, (IProject)earProject);
                boolean earAddedToServerFinal = ServerUtil.containsModule((IServer)this.existingServer_, (IModule)ResourceUtils.getModule((IProject)earProject), (IProgressMonitor)new NullProgressMonitor());
                if (!earAddedToServerFinal && (mmStatus = ServerUtils.getInstance().modifyModules(env, this.existingServer_, ResourceUtils.getModule((IProject)webProject), true, (IProgressMonitor)new NullProgressMonitor())).getSeverity() == 4) {
                    return mmStatus;
                }
            }
        }
        return new SimpleStatus("");
    }

    private Status createWebProject(Environment env) {
        try {
            IDataModel projectInfo = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentCreationDataModelProvider());
            projectInfo.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)this.projectName_);
            if (this.j2eeVersion_ != null && this.j2eeVersion_.length() > 0) {
                projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(this.j2eeVersion_));
            } else if (this.earProjectName_ != null && this.earProjectName_.length() > 0) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject earProject = root.getProject(this.earProjectName_);
                if (earProject != null && earProject.exists()) {
                    EARNatureRuntime ear = EARNatureRuntime.getRuntime((IProject)earProject);
                    int earVersion = ear.getJ2EEVersion();
                    projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(earVersion));
                    String.valueOf(earVersion);
                } else {
                    projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(13));
                    String.valueOf(13);
                }
            } else {
                projectInfo.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(13));
                String.valueOf(13);
            }
            if (this.serverFactoryId_ != null) {
                this.serverFactoryId_.length();
            }
            if (this.earProjectName_ != null && this.earProjectName_.length() > 0) {
                projectInfo.setProperty("IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_NAME", (Object)this.earProjectName_);
                projectInfo.setProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", (Object)Boolean.TRUE);
            } else {
                projectInfo.setProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", (Object)Boolean.FALSE);
            }
            IDataModelOperation op = projectInfo.getDefaultOperation();
            op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            return new SimpleStatus("");
        }
        catch (Exception e) {
            env.getLog().log(4, 5046, (Object)this, "createWebProject", (Throwable)e);
            SimpleStatus status = new SimpleStatus("org.eclipse.jst.ws.consumption", this.msgUtils_.getMessage("MSG_ERROR_WEB_PROJECT_CREATE"), 4, (Throwable)e);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
    }

    private Status createEARProject(Environment env) {
        CreateEARProjectCommand t = new CreateEARProjectCommand();
        t.setEarProjectName(this.earProjectName_);
        t.setServerFactoryId(this.serverFactoryId_);
        t.setJ2EEVersion(this.j2eeVersion_);
        Status status = t.execute(env);
        return status;
    }

    private Status stopServer(Environment env) {
        try {
            WebServiceStartServerRegistry reg = WebServiceStartServerRegistry.getInstance();
            AbstractStartServer startServerCommand = (AbstractStartServer)reg.getServerStartByTypeId(this.existingServer_.getServerType().getId());
            startServerCommand.stopServer(this.existingServer_);
            return new SimpleStatus("");
        }
        catch (CoreException ce) {
            IStatus embeddedStatus = ce.getStatus();
            Status status = EnvironmentUtils.convertIStatusToStatus((IStatus)embeddedStatus);
            env.getStatusHandler().reportError(status);
            return status;
        }
    }

    private String getNewEARName() {
        String newEARName = "WebServiceEAR";
        ResourceUtils.getWorkspace().getRoot().getProject(newEARName);
        return newEARName;
    }

    private IProject getDefaultEARProject(IProject project) {
        try {
            EARNatureRuntime[] ears = null;
            EARNatureRuntime ear = null;
            ears = J2EEProjectUtilities.getReferencingEARProjects((IProject)project);
            if (ears[0] != null && ears.length >= 1) {
                return ears[0].getProject();
            }
            if (this.j2eeVersion_ != null && this.j2eeVersion_.length() > 0) {
                ear = J2EEUtils.getEAR((int)Integer.parseInt(this.j2eeVersion_));
            } else {
                ear = J2EEUtils.get12EAR();
                if (ear == null) {
                    ear = J2EEUtils.get13EAR();
                }
                if (ear == null) {
                    ear = J2EEUtils.getEAR((int)14);
                }
            }
            if (ear != null) {
                return ear.getProject();
            }
            String earName = this.getNewEARName();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            return root.getProject(earName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName_ = earProjectName;
    }

    public void setProjectName(String projectName) {
        this.projectName_ = projectName;
    }

    public void setExistingServer(IServer existingServer) {
        this.existingServer_ = existingServer;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId_ = serverFactoryId;
    }

    public void setJ2EEVersion(String j2eeVersion) {
        this.j2eeVersion_ = j2eeVersion;
    }

    public void setNeedEAR(boolean needEAR) {
        this.needEAR_ = needEAR;
    }

    public void setAddedProjectToServer(boolean addedProjectToServer) {
        this.weAddedProjectToServer_ = addedProjectToServer;
    }
}

