/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.AbstractStartServer;
import org.eclipse.jst.ws.internal.consumption.common.WebServiceStartServerRegistry;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class StartProjectCommand
extends SimpleCommand {
    private String DESCRIPTION = "Start Web Project";
    private String LABEL = "StartProjectCommand";
    private MessageUtils msgUtils_;
    private Boolean creationScenario_ = Boolean.TRUE;
    private boolean isWebProjectStartupRequested_;
    private IProject serviceProject_;
    private IProject sampleProject_;
    private String serviceServerTypeID_;
    private String sampleServerTypeID_;
    private IServer serviceExistingServer_;
    private IServer sampleExistingServer_;
    private String moduleName_;

    public StartProjectCommand(String moduleName) {
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setDescription(this.DESCRIPTION);
        this.setName(this.LABEL);
        this.moduleName_ = moduleName;
    }

    public StartProjectCommand(boolean creationScenario) {
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setDescription(this.DESCRIPTION);
        this.setName(this.LABEL);
        this.creationScenario_ = new Boolean(creationScenario);
    }

    public Status execute(Environment env) {
        IServer server;
        SimpleStatus status = new SimpleStatus("");
        env.getProgressMonitor().report(this.msgUtils_.getMessage("PROGRESS_INFO_START_WEB_PROJECT"));
        IProject project = this.creationScenario_ != false ? this.serviceProject_ : this.sampleProject_;
        String serverTypeID = this.creationScenario_ != false ? this.serviceServerTypeID_ : this.sampleServerTypeID_;
        IServer iServer = server = this.creationScenario_ != false ? this.serviceExistingServer_ : this.sampleExistingServer_;
        if (serverTypeID == null && server != null) {
            serverTypeID = server.getServerType().getId();
        }
        if (project == null) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_PROJECT_NOT_FOUND"), 4);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        IServer instance = ServerUtils.getServerForModule((IModule)ServerUtils.getModule((IProject)project, (String)this.moduleName_), (String)serverTypeID, (IServer)server, (boolean)true, (IProgressMonitor)EnvironmentUtils.getIProgressMonitor((Environment)env));
        if (instance == null) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_INSTANCE_NOT_FOUND"), 4);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        try {
            AbstractStartServer startServerCommand = null;
            WebServiceStartServerRegistry reg = WebServiceStartServerRegistry.getInstance();
            startServerCommand = (AbstractStartServer)reg.getServerStartByTypeId(instance.getServerType().getId());
            startServerCommand.StartServer(project, instance, EnvironmentUtils.getIProgressMonitor((Environment)env), this.isWebProjectStartupRequested_);
            return status;
        }
        catch (CoreException ce) {
            IStatus embeddedStatus = ce.getStatus();
            status = EnvironmentUtils.convertIStatusToStatus((IStatus)embeddedStatus);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        catch (Exception e) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_SERVER"), 4, (Throwable)e);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
    }

    public void setCreationScenario(Boolean creationScenario) {
        this.creationScenario_ = creationScenario;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject_ = serviceProject;
    }

    public void setSampleProject(IProject sampleProject) {
        this.sampleProject_ = sampleProject;
    }

    public void setServiceServerTypeID(String serviceServerTypeID) {
        this.serviceServerTypeID_ = serviceServerTypeID;
    }

    public void setSampleServerTypeID(String sampleServerTypeID) {
        this.sampleServerTypeID_ = sampleServerTypeID;
    }

    public void setServiceExistingServer(IServer serviceExistingServer) {
        this.serviceExistingServer_ = serviceExistingServer;
        if (this.serviceExistingServer_ != null) {
            this.setServiceServerTypeID(this.serviceExistingServer_.getServerType().getId());
        }
    }

    public void setSampleExistingServer(IServer sampleExistingServer) {
        this.sampleExistingServer_ = sampleExistingServer;
        if (this.sampleExistingServer_ != null) {
            this.setSampleServerTypeID(this.sampleExistingServer_.getServerType().getId());
        }
    }

    public void setIsWebProjectStartupRequested(boolean webProjectStartupRequested) {
        this.isWebProjectStartupRequested_ = webProjectStartupRequested;
    }
}

