/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.core.command;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.GeneratedFileInfo;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class WSDL2JavaCommand
extends SimpleCommand {
    private final String DEPLOY_TYPE = "deploy";
    private final String UNDEPLOY_TYPE = "undeploy";
    private JavaWSDLParameter javaWSDLParam;
    private String wsdlURI;
    private String httpBasicAuthUsername;
    private String httpBasicAuthPassword;
    private ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.jst.ws.axis.consumption.core.consumption");
    private String LABEL = "TASK_LABEL_WSDL_JAVA_COMMAND";
    private String DESCRIPTION = "TASK_DESC_WSDL_JAVA_COMMAND";

    public WSDL2JavaCommand() {
        this.setName(this.getMessage(this.LABEL));
        this.setDescription(this.getMessage(this.DESCRIPTION));
    }

    public Status execute(Environment environment) {
        if (this.javaWSDLParam == null) {
            SimpleStatus status = new SimpleStatus("WSDL2JavaCommand", this.getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"), 4);
            environment.getStatusHandler().reportError((Status)status);
            return status;
        }
        if (this.wsdlURI != null) {
            this.javaWSDLParam.setInputWsdlLocation(this.wsdlURI);
        }
        this.javaWSDLParam.setHTTPUsername(this.httpBasicAuthUsername);
        this.javaWSDLParam.setHTTPPassword(this.httpBasicAuthPassword);
        Emitter wsdl2Java = new Emitter();
        if (environment.getLog().isEnabled("emitter")) {
            wsdl2Java.setVerbose(true);
        } else {
            wsdl2Java.setVerbose(false);
        }
        boolean serverSide = this.javaWSDLParam.getServerSide() == 1;
        wsdl2Java.setServerSide(serverSide);
        if (serverSide) {
            wsdl2Java.setSkeletonWanted(this.javaWSDLParam.isSkeletonDeploy());
        }
        if (this.javaWSDLParam.isMetaInfOnly()) {
            wsdl2Java.setOutputDir(this.removeFileProtocol(this.javaWSDLParam.getOutput()));
            HashMap pck2nsMap = this.javaWSDLParam.getMappings();
            if (pck2nsMap != null) {
                HashMap<String, String> ns2pckMap = new HashMap<String, String>();
                Iterator keys = pck2nsMap.keySet().iterator();
                while (keys.hasNext()) {
                    String pakage = (String)keys.next();
                    String namespace = (String)pck2nsMap.get(pakage);
                    ns2pckMap.put(namespace, pakage);
                }
                wsdl2Java.setNamespaceMap(ns2pckMap);
            }
        } else {
            wsdl2Java.setOutputDir(this.removeFileProtocol(this.javaWSDLParam.getJavaOutput()));
            if (this.javaWSDLParam.getMappings() != null) {
                wsdl2Java.setNamespaceMap(this.javaWSDLParam.getMappings());
            }
        }
        environment.getLog().log(1, 5019, (Object)this, "execute", (Object)("Java output = " + this.javaWSDLParam.getJavaOutput()));
        if (this.javaWSDLParam.getHTTPPassword() != null) {
            wsdl2Java.setPassword(this.javaWSDLParam.getHTTPPassword());
            environment.getLog().log(1, 5081, (Object)this, "execute", (Object)("password: " + this.javaWSDLParam.getHTTPPassword()));
        }
        if (this.javaWSDLParam.getHTTPUsername() != null) {
            wsdl2Java.setUsername(this.javaWSDLParam.getHTTPUsername());
            environment.getLog().log(1, 5082, (Object)this, "execute", (Object)("username: " + this.javaWSDLParam.getHTTPUsername()));
        }
        environment.getLog().log(1, 5020, (Object)this, "execute", (Object)("WSDL Location = " + this.javaWSDLParam.getInputWsdlLocation()));
        environment.getProgressMonitor().report(this.getMessage("MSG_PARSING_WSDL", this.javaWSDLParam.getInputWsdlLocation()));
        try {
            wsdl2Java.run(this.javaWSDLParam.getInputWsdlLocation());
            if (serverSide) {
                List deploymentFiles1 = wsdl2Java.getGeneratedFileInfo().findType("deploy");
                List deploymentFiles2 = wsdl2Java.getGeneratedFileInfo().findType("undeploy");
                ArrayList<String> deplFiles = new ArrayList<String>();
                if (deploymentFiles1 != null && deploymentFiles2 != null) {
                    deploymentFiles1.addAll(deploymentFiles2);
                    int i = 0;
                    while (i < deploymentFiles1.size()) {
                        GeneratedFileInfo.Entry entry = (GeneratedFileInfo.Entry)deploymentFiles1.get(i);
                        deplFiles.add(entry.fileName);
                        ++i;
                    }
                    String[] deplFilesArray = new String[deplFiles.size()];
                    deplFiles.toArray(deplFilesArray);
                    this.javaWSDLParam.setDeploymentFiles(deplFilesArray);
                }
                List javaFiles = wsdl2Java.getGeneratedFileNames();
                javaFiles.removeAll(deplFiles);
                String[] javaFileNames = new String[javaFiles.size()];
                javaFiles.toArray(javaFileNames);
                this.javaWSDLParam.setJavaFiles(javaFileNames);
            }
        }
        catch (Exception e) {
            environment.getLog().log(4, 5021, (Object)this, "execute", (Throwable)e);
            SimpleStatus status = new SimpleStatus("Java2WSDLCommand", String.valueOf(this.getMessage("MSG_ERROR_WSDL_JAVA_GENERATE")) + " " + e.toString(), 4);
            environment.getStatusHandler().reportError((Status)status);
            return status;
        }
        return new SimpleStatus("");
    }

    private String removeFileProtocol(String s) {
        if (s.startsWith("file:")) {
            int k;
            String protocol;
            int j;
            int max;
            String newS = s.substring(5, s.length());
            int i = newS.indexOf(58);
            if (i != -1 && (max = Math.max(j = (protocol = newS.substring(0, i)).indexOf(47), k = protocol.indexOf(92))) != -1) {
                newS = newS.substring(max + 1, newS.length());
            }
            return newS;
        }
        return s;
    }

    public Status undo(Environment environment) {
        return null;
    }

    public Status redo(Environment environment) {
        return null;
    }

    private String getMessage(String messageId, String parm1) {
        String message = this.resource.getString(messageId);
        return MessageFormat.format(message, parm1);
    }

    public String getMessage(String key) {
        return this.resource.getString(key);
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setHttpBasicAuthPassword(String httpBasicAuthPassword) {
        this.httpBasicAuthPassword = httpBasicAuthPassword;
    }

    public void setHttpBasicAuthUsername(String httpBasicAuthUsername) {
        this.httpBasicAuthUsername = httpBasicAuthUsername;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }
}

