/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseLibrary;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseWARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.WarFileDynamicClassLoader;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.webapplication.WebapplicationPackage;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class WARFileImpl
extends ModuleFileImpl
implements WARFile {
    protected WebApp deploymentDescriptor = null;
    protected List sourceFiles;
    static /* synthetic */ Class class$0;

    protected EClass eStaticClass() {
        return CommonarchivePackage.eINSTANCE.getWARFile();
    }

    public File addCopyClass(File aFile) throws DuplicateObjectException {
        if (aFile.isReadOnlyDirectory()) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.getString("add_copy_class_dir_EXC_", new Object[]{aFile.getURI()}));
        }
        return this.addCopyFileAddingPrefix(aFile, "WEB-INF/classes/");
    }

    protected File addCopyFileAddingPrefix(File aFile, String uriPrefix) throws DuplicateObjectException {
        String swizzledUri = aFile.getURI();
        if (!swizzledUri.startsWith(uriPrefix)) {
            swizzledUri = ArchiveUtil.concatUri(uriPrefix, swizzledUri, '/');
        }
        this.checkAddValid(swizzledUri);
        File copy = this.copy(aFile);
        copy.setURI(swizzledUri);
        this.getFiles().add((Object)copy);
        return copy;
    }

    public File addCopyLib(File aFile) throws DuplicateObjectException {
        if (aFile.isReadOnlyDirectory()) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.getString("add_copy_lib_dir_EXC_", new Object[]{aFile.getURI()}));
        }
        return this.addCopyFileAddingPrefix(aFile, "WEB-INF/lib/");
    }

    protected RuntimeClasspathEntry createLibClasspathEntry(String libPath) {
        RuntimeClasspathEntry entry = this.createRuntimeClasspathEntry(libPath);
        entry.setWarFile(this);
        return entry;
    }

    protected List getAllFileEntriesRecursive(java.io.File aFile, List aList) {
        if (!aFile.exists()) {
            return aList;
        }
        String name = aFile.getName();
        if (name.regionMatches(true, name.length() - 4, ".jar", 0, 4)) {
            aList.add(aFile.getAbsolutePath());
        } else if (aFile.isDirectory()) {
            java.io.File[] children = aFile.listFiles();
            int i = 0;
            while (i < children.length) {
                this.getAllFileEntriesRecursive(children[i], aList);
                ++i;
            }
        }
        return aList;
    }

    public List getClasses() {
        return this.filterFilesByPrefix("WEB-INF/classes/");
    }

    public WebApp getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        WebApp dd = this.getDeploymentDescriptorGen();
        if (dd == null && this.canLazyInitialize()) {
            try {
                this.getImportStrategy().importMetaData();
            }
            catch (Exception e) {
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), e);
            }
        }
        return this.getDeploymentDescriptorGen();
    }

    public String getDeploymentDescriptorUri() {
        return "WEB-INF/web.xml";
    }

    public List getLibs() {
        return this.filterFilesByPrefix("WEB-INF/lib/");
    }

    public List getLibArchives() {
        return this.filterFiles("WEB-INF/lib/", new String[]{"jar", "zip"});
    }

    public List getResources() {
        String[] prefixes = new String[]{"META-INF", "WEB-INF"};
        return this.filterFilesWithoutPrefix(prefixes);
    }

    public RuntimeClasspathEntry[] getLocalRuntimeClassPath() {
        String absolutePath;
        try {
            absolutePath = this.getLoadStrategy().getBinariesPath();
        }
        catch (IOException iOException) {
            return new RuntimeClasspathEntry[0];
        }
        ArrayList<RuntimeClasspathEntry> entries = new ArrayList<RuntimeClasspathEntry>();
        if (this.getLoadStrategy().isDirectory()) {
            String classesPath = ArchiveUtil.getOSUri(absolutePath, "WEB-INF/classes/");
            entries.add(this.createRuntimeClasspathEntry(classesPath));
            this.addWebLibs(absolutePath, entries);
        }
        entries.add(this.createRuntimeClasspathEntry(absolutePath));
        return entries.toArray(new RuntimeClasspathEntry[entries.size()]);
    }

    protected RuntimeClasspathEntry[] getDependencyClassPathAtThisLevel() {
        String absolutePath = this.internalGetBinariesPath();
        if (absolutePath == null) {
            return this.emptyClasspath();
        }
        RuntimeClasspathEntry[] mfEntries = super.getDependencyClassPathAtThisLevel();
        ArrayList<RuntimeClasspathEntry> entries = new ArrayList<RuntimeClasspathEntry>();
        entries.addAll(Arrays.asList(mfEntries));
        return entries.toArray(new RuntimeClasspathEntry[entries.size()]);
    }

    protected void addWebLibs(String absolutePath, List entries) {
        java.io.File aFile = new java.io.File(ArchiveUtil.getOSUri(absolutePath, "WEB-INF/lib/"));
        List libs = this.getAllFileEntriesRecursive(aFile, new ArrayList());
        int i = 0;
        while (i < libs.size()) {
            String libPath = (String)libs.get(i);
            entries.add(this.createLibClasspathEntry(libPath));
            ++i;
        }
        this.addLooseLibsToRuntimeClasspath(entries);
    }

    protected void addLooseLibsToRuntimeClasspath(List entries) {
        LooseWARFile loose = (LooseWARFile)this.getLoadStrategy().getLooseArchive();
        if (loose == null) {
            return;
        }
        EList looseLibs = loose.getLooseLibs();
        int i = 0;
        while (i < looseLibs.size()) {
            LooseLibrary lib = (LooseLibrary)looseLibs.get(i);
            entries.add(this.createLibClasspathEntry(lib.getBinariesPath()));
            ++i;
        }
    }

    protected List calculateSourceCandidateFiles() {
        EList filesList = this.getFiles();
        Vector<File> retFiles = new Vector<File>();
        Iterator iter = filesList.iterator();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            String aUri = file.getURI();
            if (!aUri.startsWith("WEB-INF") || aUri.startsWith("WEB-INF/lib/")) continue;
            retFiles.add(file);
        }
        return retFiles;
    }

    protected List getSourceCandidateFiles() {
        if (this.sourceFiles == null) {
            this.sourceFiles = this.calculateSourceCandidateFiles();
        }
        return this.sourceFiles;
    }

    protected String makeRelative(String pathString, String relToPathString) {
        if (pathString.startsWith(relToPathString)) {
            return ArchiveUtil.truncateFromFrontIgnoreCase(pathString, relToPathString);
        }
        return pathString;
    }

    public File getSourceFile(File aClassFile) {
        String classURI;
        List sourceFilesList = this.getSourceCandidateFiles();
        String convertedClassURI = classURI = aClassFile.getURI();
        if (classURI.endsWith(".class")) {
            convertedClassURI = ArchiveUtil.classUriToJavaUri(aClassFile.getURI());
        }
        convertedClassURI = this.makeRelative(convertedClassURI, "WEB-INF/classes/");
        int bestLength = Short.MAX_VALUE;
        File bestMatch = null;
        File file = null;
        String aUri = null;
        Iterator iter = sourceFilesList.iterator();
        while (iter.hasNext()) {
            int excessLength;
            file = (File)iter.next();
            aUri = file.getURI();
            if (!aUri.endsWith(convertedClassURI) || aUri.equals(classURI) || (excessLength = aUri.length() - convertedClassURI.length()) >= bestLength) continue;
            bestMatch = file;
            bestLength = excessLength;
        }
        return bestMatch;
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor();
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isWARFile() {
        return true;
    }

    public EObject makeDeploymentDescriptor(XMLResource resource) {
        WebApp webApp = ((WebapplicationPackage)EPackage.Registry.INSTANCE.getEPackage("webapplication.xmi")).getWebapplicationFactory().createWebApp();
        resource.setID((EObject)webApp, "WebApp_ID");
        this.setDeploymentDescriptorGen(webApp);
        resource.getContents().add((Object)webApp);
        return webApp;
    }

    public void setDeploymentDescriptor(WebApp l) {
        this.setDeploymentDescriptorGen(l);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), (EObject)l);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return URI_EDEFAULT == null ? this.uri != null : !URI_EDEFAULT.equals(this.uri);
            }
            case 1: {
                return this.isSetLastModified();
            }
            case 2: {
                return this.isSetSize();
            }
            case 3: {
                return this.isSetDirectoryEntry();
            }
            case 4: {
                return ORIGINAL_URI_EDEFAULT == null ? this.originalURI != null : !ORIGINAL_URI_EDEFAULT.equals(this.originalURI);
            }
            case 5: {
                return this.loadingContainer != null;
            }
            case 6: {
                return this.getContainer() != null;
            }
            case 7: {
                return this.files != null && !this.files.isEmpty();
            }
            case 8: {
                return this.types != null && !this.types.isEmpty();
            }
            case 9: {
                return this.deploymentDescriptor != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setURI((String)newValue);
                return;
            }
            case 1: {
                this.setLastModified((Long)newValue);
                return;
            }
            case 2: {
                this.setSize((Long)newValue);
                return;
            }
            case 3: {
                this.setDirectoryEntry((Boolean)newValue);
                return;
            }
            case 4: {
                this.setOriginalURI((String)newValue);
                return;
            }
            case 5: {
                this.setLoadingContainer((Container)newValue);
                return;
            }
            case 6: {
                this.setContainer((Container)newValue);
                return;
            }
            case 7: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getTypes().clear();
                this.getTypes().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setDeploymentDescriptor((WebApp)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setURI(URI_EDEFAULT);
                return;
            }
            case 1: {
                this.unsetLastModified();
                return;
            }
            case 2: {
                this.unsetSize();
                return;
            }
            case 3: {
                this.unsetDirectoryEntry();
                return;
            }
            case 4: {
                this.setOriginalURI(ORIGINAL_URI_EDEFAULT);
                return;
            }
            case 5: {
                this.setLoadingContainer(null);
                return;
            }
            case 6: {
                this.setContainer(null);
                return;
            }
            case 7: {
                this.getFiles().clear();
                return;
            }
            case 8: {
                this.getTypes().clear();
                return;
            }
            case 9: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public WebApp getDeploymentDescriptorGen() {
        if (this.deploymentDescriptor != null && this.deploymentDescriptor.eIsProxy()) {
            WebApp oldDeploymentDescriptor = this.deploymentDescriptor;
            this.deploymentDescriptor = (WebApp)EcoreUtil.resolve((EObject)this.deploymentDescriptor, (EObject)this);
            if (this.deploymentDescriptor != oldDeploymentDescriptor && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 9, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
            }
        }
        return this.deploymentDescriptor;
    }

    public WebApp basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptorGen(WebApp newDeploymentDescriptor) {
        WebApp oldDeploymentDescriptor = this.deploymentDescriptor;
        this.deploymentDescriptor = newDeploymentDescriptor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 6, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicAdd((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    return this.eBasicSetContainer(null, 6, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (this.eContainerFeatureID < 0) break block6;
            switch (this.eContainerFeatureID) {
                case 6: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.Container");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove((InternalEObject)this, 7, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getURI();
            }
            case 1: {
                return new Long(this.getLastModified());
            }
            case 2: {
                return new Long(this.getSize());
            }
            case 3: {
                return this.isDirectoryEntry() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getOriginalURI();
            }
            case 5: {
                if (resolve) {
                    return this.getLoadingContainer();
                }
                return this.basicGetLoadingContainer();
            }
            case 6: {
                return this.getContainer();
            }
            case 7: {
                return this.getFiles();
            }
            case 8: {
                return this.getTypes();
            }
            case 9: {
                if (resolve) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public ClassLoader createDynamicClassLoader(ClassLoader parentCl, ClassLoader extraCl) {
        return new WarFileDynamicClassLoader(this, parentCl, extraCl);
    }
}

