/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.modelquery;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.jst.jsp.ui.tests.Logger;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IDocumentTypeHandler;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryProvider;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistry;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModelQueryTester
extends TestCase {
    private final boolean testShippedDTDLookup = false;
    protected IDOMModel fModel = null;
    protected ModelQuery fModelQuery = null;
    static /* synthetic */ Class class$0;

    public ModelQueryTester(String name) {
        super(name);
    }

    protected static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.ui.tests.modelquery.ModelQueryTester");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            ModelQueryTester.runAll();
        } else if (args.length == 1) {
            String methodToRun = args[0].trim();
            ModelQueryTester.runOne(methodToRun);
        }
    }

    protected static void runAll() {
        TestRunner.run((Test)ModelQueryTester.suite());
    }

    protected static void runOne(String methodName) {
        TestSuite testSuite = new TestSuite();
        ModelQueryTester test = new ModelQueryTester(methodName);
        testSuite.addTest((Test)test);
        TestRunner.run((Test)testSuite);
    }

    protected void setUpHTML() {
        this.fModel = (IDOMModel)ModelQueryTester.createModel(ContentTypeIdForHTML.ContentTypeID_HTML);
        this.initVars();
    }

    protected void setUpXML() {
        this.fModel = (IDOMModel)ModelQueryTester.createModel(ContentTypeIdForXML.ContentTypeID_XML);
        this.initVars();
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void initVars() {
        this.fModelQuery = ModelQueryUtil.getModelQuery((Document)this.fModel.getDocument());
    }

    public void testBodyElement() {
        this.setUpHTML();
        this.fModel.getStructuredDocument().set("<html><body bgcolor=\"#ffffff\"><form method=\"post\"></form></body></html>");
        Element bodyElement = (Element)this.fModel.getIndexedRegion(7);
        CMElementDeclaration bodyDecl = this.fModelQuery.getCMElementDeclaration(bodyElement);
        int contentType = bodyDecl.getContentType();
        ModelQueryTester.assertTrue((String)"CMElementDeclaration CONTENT TYPE INCORRECT FOR BODY", (contentType == 3 ? 1 : 0) != 0);
        CMNamedNodeMap map = bodyDecl.getAttributes();
        ModelQueryTester.assertTrue((String)"ATTRIBUTES FROM ELEMENT DECLARATION == NULL", (map != null ? 1 : 0) != 0);
        Vector<String> allowed = new Vector<String>();
        int i = 0;
        while (i < map.getLength()) {
            CMAttributeDeclaration node = (CMAttributeDeclaration)map.item(i);
            String name = node.getNodeName();
            allowed.add(name);
            if (name.equalsIgnoreCase("bgcolor")) {
                ModelQueryTester.assertTrue((String)"GOT INCORRECT ATTRIBUTE NODE TYPE", (node.getNodeType() == 2 ? 1 : 0) != 0);
                CMDataType attrType = node.getAttrType();
                ModelQueryTester.assertTrue((String)"COULD NOT GET ATTRIBUTE TYPE", (attrType != null ? 1 : 0) != 0);
                ModelQueryTester.assertTrue((String)"COULDN'T GET IMPLIED VALUE KIND", (attrType.getImpliedValueKind() == 1 ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testHtmlChildren() {
        this.setUpHTML();
        this.fModel.getStructuredDocument().set("<html></html>");
        Element htmlElement = this.fModel.getDocument().getDocumentElement();
        CMElementDeclaration htmlDecl = this.fModelQuery.getCMElementDeclaration(htmlElement);
        CMContent contents = htmlDecl.getContent();
        ModelQueryTester.assertTrue((String)"content type is not a group", (contents.getNodeType() == 7 ? 1 : 0) != 0);
        CMGroup group = (CMGroup)contents;
        int operator = group.getOperator();
        CMNodeList childList = group.getChildNodes();
        int max = contents.getMaxOccur();
        int min = contents.getMinOccur();
        ModelQueryTester.assertTrue((String)"occurrance of group", (min == 1 && max == 1 ? 1 : 0) != 0);
        ModelQueryTester.assertTrue((String)"relationship in group", (operator == 1 ? 1 : 0) != 0);
        ModelQueryTester.assertTrue((String)"content descriptor type, position 0", (contents.getNodeType() == 7 ? 1 : 0) != 0);
        ModelQueryTester.assertTrue((String)"child order (HEAD first)", (boolean)childList.item(0).getNodeName().equalsIgnoreCase("HEAD"));
        ModelQueryTester.assertTrue((String)"content descriptor type, position 1", (childList.item(1).getNodeType() == 7 ? 1 : 0) != 0);
        ModelQueryTester.assertTrue((String)"content descriptor type, position 1 - relationship of group", (((CMGroup)childList.item(1)).getOperator() == 2 ? 1 : 0) != 0);
    }

    public void testFormMethodAttr() {
        this.setUpHTML();
        this.fModel.getStructuredDocument().set("<html><body bgcolor=\"#ffffff\"><form method=\"post\"></form></body></html>");
        Element formElement = (Element)this.fModel.getIndexedRegion(31);
        Attr attrNode = formElement.getAttributeNode("method");
        CMAttributeDeclaration methodAttrDecl = this.fModelQuery.getCMAttributeDeclaration(attrNode);
        ModelQueryTester.assertTrue((String)"Content Model missing the attribute declaration for \"method\"", (methodAttrDecl != null ? 1 : 0) != 0);
        List values = this.getValidStrings(formElement, methodAttrDecl);
        ModelQueryTester.assertTrue((String)"wrong number of values for attribute \"method\"", (values.size() == 2 ? 1 : 0) != 0);
        ModelQueryTester.assertTrue((String)"default value for attribute \"method\" is wrong", (boolean)methodAttrDecl.getAttrType().getImpliedValue().equalsIgnoreCase("get"));
    }

    public void testDTDLoadFromSystemID_1() {
    }

    public void testDTDLoadFromSystemID_2() {
    }

    public void testDTDLoadFromPublicID() {
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static IStructuredModel createModel(String contentTypeID) {
        IStructuredModel model = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(contentTypeID);
        AdapterFactoryRegistry adapterRegistry = JSPUIPlugin.getDefault().getAdapterFactoryRegistry();
        Iterator adapterList = adapterRegistry.getAdapterFactories();
        while (adapterList.hasNext()) {
            try {
                AdapterFactoryProvider provider = (AdapterFactoryProvider)adapterList.next();
                if (!provider.isFor((IDocumentTypeHandler)model.getModelHandler())) continue;
                provider.addAdapterFactories(model);
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return model;
    }

    private List getValidStrings(Element element, CMAttributeDeclaration attrDecl) {
        CMDataType valuesHelper = attrDecl.getAttrType();
        Vector<String> values = new Vector<String>();
        if (valuesHelper.getImpliedValueKind() == 2 && valuesHelper.getImpliedValue() != null) {
            values.add(valuesHelper.getImpliedValue());
        } else {
            String[] valueStrings = null;
            valueStrings = this.fModelQuery.getPossibleDataTypeValues(element, (CMNode)attrDecl);
            if (valueStrings == null) {
                valueStrings = attrDecl.getAttrType().getEnumeratedValues();
            }
            if (valueStrings != null) {
                int i = 0;
                while (i < valueStrings.length) {
                    values.add(valueStrings[i]);
                    ++i;
                }
            }
        }
        if (valuesHelper.getImpliedValueKind() != 1 && valuesHelper.getImpliedValue() != null && !values.contains(valuesHelper.getImpliedValue())) {
            values.add(valuesHelper.getImpliedValue());
        }
        return values;
    }
}

