/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.other;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.wst.sse.core.internal.document.StructuredDocumentFactory;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.Debug;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.parser.XMLSourceParser;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class UnitTests
extends TestCase {
    protected IStructuredDocument fModel;
    protected IDOMModel tree;
    protected int eventCase = 1;
    protected boolean eventResult;
    public static final int GENERIC_NODES_REPLACED_EVENT_CASE = 1001;
    public static final int GENERIC_REGIONS_REPLACED_EVENT_CASE = 1002;
    public static final int GENERIC_REGION_CHANGED_EVENT_CASE = 1003;
    public static final int GENERIC_NEW_MODEL_EVENT_CASE = 1004;
    public static final int GENERIC_NO_CHANGE_EVENT_CASE = 1005;
    protected StructuredDocumentListenerProxy proxy = new StructuredDocumentListenerProxy();
    static /* synthetic */ Class class$0;

    public UnitTests(String name) {
        super(name);
    }

    protected void handleEvent(StructuredDocumentEvent structuredDocumentEvent) {
        this.eventResult = false;
        switch (this.eventCase) {
            case 1: {
                if (!(structuredDocumentEvent instanceof NoChangeEvent)) break;
                this.eventResult = true;
                break;
            }
            case 2: {
                if (!(structuredDocumentEvent instanceof NoChangeEvent)) break;
                this.eventResult = true;
                break;
            }
            case 3: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 4: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 5: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent) || 3 != ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getOldStructuredDocumentRegions().getLength() || 3 != ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getNewStructuredDocumentRegions().getLength()) break;
                this.eventResult = true;
                break;
            }
            case 6: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent) || ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getOldStructuredDocumentRegions().getLength() != 0 || 2 != ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getNewStructuredDocumentRegions().getLength() || !"<B>".equals(((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getNewStructuredDocumentRegions().item(0).getText()) || !"</B>".equals(((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getNewStructuredDocumentRegions().item(1).getText())) break;
                this.eventResult = true;
                break;
            }
            case 7: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent) || ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getOldStructuredDocumentRegions().getLength() != 0 || 1 != ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getNewStructuredDocumentRegions().getLength()) break;
                this.eventResult = true;
                break;
            }
            case 8: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent) || ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getOldStructuredDocumentRegions().getLength() != 0 || 2 != ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getNewStructuredDocumentRegions().getLength()) break;
                this.eventResult = true;
                break;
            }
            case 9: 
            case 10: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent) || 2 != ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getOldStructuredDocumentRegions().getLength() || ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getNewStructuredDocumentRegions().getLength() != 0 || !"<TD>".equals(((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getOldStructuredDocumentRegions().item(0).getText()) || !"</TD>".equals(((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getOldStructuredDocumentRegions().item(1).getText())) break;
                this.eventResult = true;
                break;
            }
            case 11: 
            case 12: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent) || 2 != ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getOldStructuredDocumentRegions().getLength() || ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getNewStructuredDocumentRegions().getLength() != 0 || !"<TD>".equals(((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getOldStructuredDocumentRegions().item(0).getText()) || !"</TD>".equals(((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getOldStructuredDocumentRegions().item(1).getText())) break;
                this.eventResult = true;
                break;
            }
            case 13: {
                if (!(structuredDocumentEvent instanceof RegionsReplacedEvent) || 3 != ((RegionsReplacedEvent)structuredDocumentEvent).getNewRegions().size() || 3 != ((RegionsReplacedEvent)structuredDocumentEvent).getOldRegions().size()) break;
                this.eventResult = true;
                break;
            }
            case 14: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent) || 3 != ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getOldStructuredDocumentRegions().getLength() || 1 != ((StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getNewStructuredDocumentRegions().getLength()) break;
                this.eventResult = true;
                break;
            }
            case 15: {
                if (!(structuredDocumentEvent instanceof RegionChangedEvent)) break;
                RegionChangedEvent regionChangedEvent = (RegionChangedEvent)structuredDocumentEvent;
                IStructuredDocumentRegion documentRegion = ((RegionChangedEvent)structuredDocumentEvent).getStructuredDocumentRegion();
                if (!"b ".equals(documentRegion.getFullText(regionChangedEvent.getRegion()))) break;
                this.eventResult = true;
                break;
            }
            case 16: {
                if (!(structuredDocumentEvent instanceof RegionsReplacedEvent) || ((RegionsReplacedEvent)structuredDocumentEvent).getOldRegions().size() != 0 || 1 != ((RegionsReplacedEvent)structuredDocumentEvent).getNewRegions().size()) break;
                this.eventResult = true;
                break;
            }
            case 17: {
                if (!(structuredDocumentEvent instanceof RegionsReplacedEvent) || 1 != ((RegionsReplacedEvent)structuredDocumentEvent).getOldRegions().size() || 3 != ((RegionsReplacedEvent)structuredDocumentEvent).getNewRegions().size()) break;
                this.eventResult = true;
                break;
            }
            case 18: {
                if (!(structuredDocumentEvent instanceof RegionsReplacedEvent) || 2 != ((RegionsReplacedEvent)structuredDocumentEvent).getOldRegions().size() || 2 != ((RegionsReplacedEvent)structuredDocumentEvent).getNewRegions().size()) break;
                this.eventResult = true;
                break;
            }
            case 19: {
                if (!(structuredDocumentEvent instanceof RegionChangedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 20: 
            case 21: {
                if (!(structuredDocumentEvent instanceof RegionChangedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 22: {
                if (!(structuredDocumentEvent instanceof RegionChangedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 23: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 24: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 25: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 26: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 27: {
                if (!(structuredDocumentEvent instanceof RegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 28: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 29: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 30: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 31: {
                if (!(structuredDocumentEvent instanceof RegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 32: {
                IStructuredDocumentRegion region;
                String text;
                StructuredDocumentRegionsReplacedEvent nodesReplacedEvent;
                IStructuredDocumentRegionList regions;
                if (structuredDocumentEvent instanceof RegionsReplacedEvent) {
                    RegionsReplacedEvent regionsReplacedEvent = (RegionsReplacedEvent)structuredDocumentEvent;
                    if (1 != regionsReplacedEvent.getOldRegions().size()) break;
                    ITextRegion region2 = regionsReplacedEvent.getOldRegions().get(0);
                    IStructuredDocumentRegion documentRegion = regionsReplacedEvent.getStructuredDocumentRegion();
                    String text2 = documentRegion.getText(region2);
                    if (!"<% aaa %>".equals(text2)) break;
                    this.eventResult = true;
                    break;
                }
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent) || 1 != (regions = (nodesReplacedEvent = (StructuredDocumentRegionsReplacedEvent)structuredDocumentEvent).getNewStructuredDocumentRegions()).getLength() || !"<c<% aaa ".equals(text = (region = regions.item(0)).getText())) break;
                this.eventResult = true;
                break;
            }
            case 33: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 34: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 35: {
                if (!(structuredDocumentEvent instanceof RegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 36: {
                if (!(structuredDocumentEvent instanceof RegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 37: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 38: {
                if (!(structuredDocumentEvent instanceof RegionChangedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 39: {
                if (!(structuredDocumentEvent instanceof RegionChangedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 40: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 1001: {
                if (!(structuredDocumentEvent instanceof StructuredDocumentRegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 1002: {
                if (!(structuredDocumentEvent instanceof RegionsReplacedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 1003: {
                if (!(structuredDocumentEvent instanceof RegionChangedEvent)) break;
                this.eventResult = true;
                break;
            }
            case 1004: {
                if (!(structuredDocumentEvent instanceof NewDocumentEvent)) break;
                this.eventResult = true;
                break;
            }
            case 1005: {
                if (!(structuredDocumentEvent instanceof NoChangeEvent)) break;
                this.eventResult = true;
                break;
            }
            default: {
                if (!(structuredDocumentEvent instanceof NewDocumentEvent)) break;
                this.eventResult = true;
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            UnitTests.runAll();
        } else if (args.length == 1) {
            String methodToRun = args[0].trim();
            UnitTests.runOne(methodToRun);
        }
    }

    protected static void runAll() {
        TestRunner.run((Test)UnitTests.suite());
    }

    public static void runOne(String methodName) {
        TestSuite testSuite = new TestSuite();
        UnitTests test = new UnitTests(methodName);
        testSuite.addTest((Test)test);
        TestRunner.run((Test)testSuite);
    }

    protected void setUpXML() {
        IModelManager mm = StructuredModelManager.getModelManager();
        try {
            this.fModel = mm.createStructuredDocumentFor("dummy.xml", null, null);
        }
        catch (IOException iOException) {}
        this.fModel.addDocumentChangedListener((IStructuredDocumentListener)this.proxy);
        this.tree = new DOMModelImpl();
        if (this.tree != null) {
            this.fModel.addDocumentChangingListener((IStructuredDocumentListener)this.tree);
            this.tree.setStructuredDocument(this.fModel);
        }
    }

    protected void setUpJSP() {
        IModelManager mm = StructuredModelManager.getModelManager();
        try {
            this.fModel = mm.createStructuredDocumentFor("dummy.jsp", null, null);
        }
        catch (IOException iOException) {}
        this.fModel = StructuredDocumentFactory.getNewStructuredDocumentInstance((RegionParser)new JSPSourceParser());
        this.fModel.addDocumentChangedListener((IStructuredDocumentListener)this.proxy);
        this.tree = new DOMModelImpl();
        if (this.tree != null) {
            this.fModel.addDocumentChangingListener((IStructuredDocumentListener)this.tree);
            this.tree.setStructuredDocument(this.fModel);
        }
    }

    public void simpleTest() {
        this.setUpJSP();
        this.eventCase = 99;
        String startString = "";
        String changes = "<a></a>";
        String expectedString = "<a></a>";
        int startOfChanges = 0;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void simpleTest2() {
        this.setUpXML();
        this.eventCase = 99;
        String startString = "";
        String changes = "<a></a>";
        String expectedString = "<a></a>";
        int startOfChanges = 0;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void simpleTest3() {
        this.setUpXML();
        this.eventCase = 99;
        String startString = "<a></a>";
        String changes = "";
        String expectedString = "<a></a>";
        int startOfChanges = 0;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    protected static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.ui.tests.other.UnitTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testDeleteBeginning() {
        this.setUpXML();
        this.eventCase = 4;
        String expectedString = "<GHI>";
        this.fModel.setText(null, "<ABC><DEF><GHI>");
        this.fModel.replaceText(null, 0, 10, "");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testDeleteEnd() {
        this.setUpXML();
        this.eventCase = 3;
        String expectedString = "<ABC><DEF>";
        this.fModel.setText(null, "<ABC><DEF><GHI>");
        this.fModel.replaceText(null, 10, 5, "");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testEmbedded() {
        this.setUpJSP();
        this.eventCase = 1004;
        String startString = "<p><img src=\"file.gif\"><p>";
        String changes = "<";
        String expectedString = "<p><img src=\"file<.gif\"><p>";
        int startOfChanges = 17;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.eventCase = 35;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 1: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 1: event type", (boolean)this.eventResult);
        this.eventCase = 36;
        startString = expectedString;
        changes = "%";
        expectedString = "<p><img src=\"file<%.gif\"><p>";
        startOfChanges = 18;
        lengthToReplace = 0;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        resultString = this.fModel.getText();
        result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 2: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 2: event type", (boolean)this.eventResult);
        this.eventCase = 37;
        startString = expectedString;
        changes = " ";
        expectedString = "<p><img src=\"file<% .gif\"><p>";
        startOfChanges = 19;
        lengthToReplace = 0;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        resultString = this.fModel.getText();
        result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 3: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 3: event type", (boolean)this.eventResult);
        this.eventCase = 38;
        startString = expectedString;
        changes = "ab ";
        expectedString = "<p><img src=\"file<% ab .gif\"><p>";
        startOfChanges = 20;
        lengthToReplace = 0;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        resultString = this.fModel.getText();
        result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 4: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 4: event type", (boolean)this.eventResult);
        this.eventCase = 39;
        startString = expectedString;
        changes = "%";
        expectedString = "<p><img src=\"file<% ab %.gif\"><p>";
        startOfChanges = 23;
        lengthToReplace = 0;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        resultString = this.fModel.getText();
        result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 5: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 5: event type", (boolean)this.eventResult);
        this.eventCase = 40;
        startString = expectedString;
        changes = ">";
        expectedString = "<p><img src=\"file<% ab %>.gif\"><p>";
        startOfChanges = 24;
        lengthToReplace = 0;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        resultString = this.fModel.getText();
        result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 6: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 6: event type", (boolean)this.eventResult);
    }

    public void testEmbeddedJSP2() {
        this.setUpJSP();
        this.eventCase = 1002;
        String startString = "<a >c</a>";
        String changes = "<%= b %>";
        String expectedString = "<a <%= b %>>c</a>";
        int startOfChanges = 3;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testDeepEmbeddedJSP() {
        this.setUpJSP();
        this.eventCase = 1002;
        String startString = "<script><a   >c</a></script>";
        String changes = "<%= b %>";
        String expectedString = "<script><a <%= b %>  >c</a></script>";
        int startOfChanges = 11;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
        IStructuredDocumentRegion testR = this.fModel.getRegionAtCharacterOffset(11);
        String testText = testR.getText();
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<a <%= b %>  >"));
        testText = testR.getFullText();
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<a <%= b %>  >"));
        ITextRegionList regionList = testR.getRegions();
        ITextRegion region = regionList.get(0);
        testText = testR.getText(region);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<"));
        region = regionList.get(1);
        testText = testR.getText(region);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("a"));
        testText = testR.getFullText(region);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("a "));
        region = regionList.get(2);
        testText = testR.getText(region);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<%= b %>"));
        testText = testR.getFullText(region);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<%= b %>  "));
        ITextRegionContainer cRegion = (ITextRegionContainer)region;
        ITextRegionList eRegions = cRegion.getRegions();
        ITextRegion eRegion = eRegions.get(0);
        testText = cRegion.getText(eRegion);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<%="));
        testText = cRegion.getFullText(eRegion);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<%="));
        eRegion = eRegions.get(1);
        testText = cRegion.getText(eRegion);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals(" b "));
        testText = cRegion.getFullText(eRegion);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals(" b "));
        eRegion = eRegions.get(2);
        testText = cRegion.getText(eRegion);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("%>"));
        testText = cRegion.getFullText(eRegion);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("%>"));
        eRegion = eRegions.get(3);
        testText = cRegion.getText(eRegion);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals(""));
        testText = cRegion.getFullText(eRegion);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("  "));
        region = regionList.get(3);
        testText = testR.getText(region);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals(">"));
        testText = testR.getFullText(region);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals(">"));
    }

    public void testDeepEmbeddedJSP2() {
        this.setUpJSP();
        this.eventCase = 1002;
        String startString = "<script><a   >c</a></script>";
        String changes = "<%= b %";
        String expectedString = "<script><a <%= b %  >c</a></script>";
        int startOfChanges = 11;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
        IStructuredDocumentRegion testR = this.fModel.getRegionAtCharacterOffset(11);
        String testText = testR.getText();
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<a <%= b %  >"));
        testText = testR.getFullText();
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<a <%= b %  >"));
        ITextRegionList regionList = testR.getRegions();
        ITextRegion region = regionList.get(0);
        testText = testR.getText(region);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<"));
        region = regionList.get(1);
        testText = testR.getText(region);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("a"));
        testText = testR.getFullText(region);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("a "));
        region = regionList.get(2);
        testText = testR.getText(region);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<%= b %  >"));
        testText = testR.getFullText(region);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<%= b %  >"));
        ITextRegionContainer cRegion = (ITextRegionContainer)region;
        ITextRegionList eRegions = cRegion.getRegions();
        ITextRegion eRegion = eRegions.get(0);
        testText = cRegion.getText(eRegion);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<%="));
        testText = cRegion.getFullText(eRegion);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals("<%="));
        eRegion = eRegions.get(1);
        testText = cRegion.getText(eRegion);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals(" b %  >"));
        testText = cRegion.getFullText(eRegion);
        UnitTests.assertTrue((String)"text retrieve", (boolean)testText.equals(" b %  >"));
    }

    public void testDeepEmbeddedJSP3() {
        this.setUpJSP();
        String startString = "<html><head><script> <%! String testvar = \"testvar\"; %> var test = <%= testvar %> </script></head></html>";
        String expectedText = "<%! String testvar = \"testvar\"; %>";
        ((XMLSourceParser)this.fModel.getParser()).addBlockMarker(new BlockMarker("script", null, "BLOCK_TEXT", false));
        this.fModel.setText(null, startString);
        this.fModel.getRegionList();
        IStructuredDocumentRegion scriptBlockRegion = this.fModel.getRegionAtCharacterOffset(21);
        ITextRegionList blockRegions = scriptBlockRegion.getRegions();
        ITextRegionContainer jspDecl = (ITextRegionContainer)blockRegions.get(1);
        String fullText = jspDecl.getFullText();
        UnitTests.assertEquals((String)"ContextRegionContainer.getFullText() value incorrect: ", (String)expectedText, (String)fullText);
    }

    public void testJSP1() {
        this.setUpJSP();
        this.eventCase = 23;
        String startString = "abcd<%= abc %>efgh";
        String expectedString = "abcd< %= abc %>efgh";
        String changes = " ";
        int startOfChanges = 5;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testJSP2() {
        this.setUpJSP();
        this.eventCase = 24;
        String startString = "abcd<% abc %>efgh";
        String expectedString = "abcd< % abc %>efgh";
        String changes = " ";
        int startOfChanges = 5;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testJSP3() {
        this.setUpJSP();
        this.eventCase = 25;
        String startString = "<%= abc %>";
        String expectedString = "< %= abc %>";
        String changes = " ";
        int startOfChanges = 1;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testJSP4() {
        this.setUpJSP();
        this.eventCase = 26;
        String startString = "<% abc %>";
        String expectedString = "< % abc %>";
        String changes = " ";
        int startOfChanges = 1;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testJSP5() {
        this.setUpJSP();
        this.eventCase = 1004;
        String startString = "<% aaa %><p>";
        String changes = "<";
        String expectedString = "<<% aaa %><p>";
        int startOfChanges = 0;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.eventCase = 27;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 1: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 1: event type", (boolean)this.eventResult);
        this.eventCase = 28;
        startString = expectedString;
        changes = "b";
        expectedString = "<b<% aaa %><p>";
        startOfChanges = 1;
        lengthToReplace = 0;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        resultString = this.fModel.getText();
        result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 2: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 2: event type", (boolean)this.eventResult);
        this.eventCase = 29;
        startString = expectedString;
        changes = "b";
        expectedString = "<bb<% aaa %><p>";
        startOfChanges = 2;
        lengthToReplace = 0;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        resultString = this.fModel.getText();
        result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 3: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 3: event type", (boolean)this.eventResult);
        this.eventCase = 30;
        startString = expectedString;
        changes = ">";
        expectedString = "<bb><% aaa %><p>";
        startOfChanges = 3;
        lengthToReplace = 0;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        resultString = this.fModel.getText();
        result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 4: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 4: event type", (boolean)this.eventResult);
    }

    public void testJSP6() {
        this.setUpJSP();
        this.eventCase = 1004;
        String startString = "<% aaa %><% bbb %>";
        String changes = "<";
        String expectedString = "<<% aaa %><% bbb %>";
        int startOfChanges = 0;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.eventCase = 31;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 1: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 1: event type", (boolean)this.eventResult);
        this.eventCase = 32;
        startString = expectedString;
        changes = "c";
        expectedString = "<c<% aaa %><% bbb %>";
        startOfChanges = 1;
        lengthToReplace = 0;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        resultString = this.fModel.getText();
        result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 2: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 2: event type", (boolean)this.eventResult);
        this.eventCase = 33;
        startString = expectedString;
        changes = "c";
        expectedString = "<cc<% aaa %><% bbb %>";
        startOfChanges = 2;
        lengthToReplace = 0;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        resultString = this.fModel.getText();
        result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 3: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 3: event type", (boolean)this.eventResult);
        this.eventCase = 34;
        startString = expectedString;
        changes = ">";
        expectedString = "<cc><% aaa %><% bbb %>";
        startOfChanges = 3;
        lengthToReplace = 0;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        resultString = this.fModel.getText();
        result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"part 4: text update", (boolean)result);
        UnitTests.assertTrue((String)"part 4: event type", (boolean)this.eventResult);
    }

    public void testJSPDirective() {
        this.setUpJSP();
        this.eventCase = 1001;
        String startString = "<%@include%>";
        String changes = "T";
        String expectedString = "<%@include%>T";
        int startOfChanges = 12;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethod10() {
        this.setUpXML();
        this.eventCase = 10;
        String expectedString = "<TD></TD>";
        this.fModel.setText(null, "<TD></TD><TD></TD>");
        this.fModel.replaceText(null, 9, 9, "");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethod11() {
        this.setUpXML();
        this.eventCase = 11;
        String expectedString = "<XXX><TD></TD><XXX>";
        this.fModel.setText(null, "<XXX><TD></TD><TD></TD><XXX>");
        this.fModel.replaceText(null, 5, 9, "");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethod12() {
        this.setUpXML();
        this.eventCase = 12;
        String expectedString = "<XXX><TD></TD><XXX>";
        this.fModel.setText(null, "<XXX><TD></TD><TD></TD><XXX>");
        this.fModel.replaceText(null, 14, 9, "");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethod13() {
        this.setUpXML();
        this.eventCase = 13;
        String expectedString = "<ABC><JKL><GHI>";
        this.fModel.setText(null, "<ABC><DEF><GHI>");
        this.fModel.replaceText(null, 5, 5, "<JKL>");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethod14() {
        this.setUpXML();
        this.eventCase = 14;
        String expectedString = "<a>\r\r  </a>";
        this.fModel.setText(null, "<a>\r<b>\r  </a>");
        this.fModel.replaceText(null, 4, 3, "");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethod15() {
        this.setUpXML();
        this.eventCase = 15;
        String expectedString = "<a><b ></b></a>";
        this.fModel.setText(null, "<a><b></b></a>");
        this.fModel.replaceText(null, 5, 0, " ");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethod16() {
        this.setUpXML();
        this.eventCase = 16;
        String expectedString = "<a><b z></b></a>";
        this.fModel.setText(null, "<a><b ></b></a>");
        this.fModel.replaceText(null, 6, 0, "z");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethod17() {
        this.setUpXML();
        this.eventCase = 17;
        String expectedString = "<a><b z=\"t\"></b></a>";
        this.fModel.setText(null, "<a><b z></b></a>");
        this.fModel.replaceText(null, 6, 1, "z=\"t\"");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethod18() {
        this.setUpXML();
        this.eventCase = 18;
        String expectedString = "<a><c z></b></a>";
        this.fModel.setText(null, "<a><b z></b></a>");
        this.fModel.replaceText(null, 4, 3, "c z");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethod19() {
        this.eventCase = 19;
        this.setUpJSP();
        this.fModel.setText(null, "<BODY>\r<IMG src=\"<%=\r</BODY>\r");
        String expectedString = "<BODY>\r<IMG src=\"<%=Q\r</BODY>\r";
        this.fModel.replaceText(null, 20, 0, "Q");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethod20() {
        this.setUpJSP();
        this.eventCase = 20;
        String expectedString = "<STYLE TYPE=\"text/css\">\r<!--\rBODY {\r\r}-->\r</STYLE>\r";
        this.fModel.setText(null, "<STYLE TYPE=\"text/css\">\r<!--\r-->\r</STYLE>\r");
        this.fModel.replaceText(null, 28, 1, "\rBODY {\r\r}");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethod21() {
        this.setUpJSP();
        this.eventCase = 21;
        String expectedString = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"\">\r<HTML>\r<HEAD>\r      <META content=\"text/html; charset=iso-8859-1\" http-equiv=\"Content-Type\">\r<META name=\"GENERATOR\" content=\"IBM WebSphere Page Designer V4.1.0 for Windows\">\r<META content=\"text/css\" http-equiv=\"Content-Style-Type\">\r<TITLE></TITLE>\r<STYLE TYPE=\"text/css\">\r<!--\rBODY {\r\r}-->\r</STYLE>\r";
        this.fModel.setText(null, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"\">\r<HTML>\r<HEAD>\r      <META content=\"text/html; charset=iso-8859-1\" http-equiv=\"Content-Type\">\r<META name=\"GENERATOR\" content=\"IBM WebSphere Page Designer V4.1.0 for Windows\">\r<META content=\"text/css\" http-equiv=\"Content-Style-Type\">\r<TITLE></TITLE>\r<STYLE TYPE=\"text/css\">\r<!--\r-->\r</STYLE>\r");
        this.fModel.replaceText(null, 343, 1, "\rBODY {\r\r}");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethod9() {
        this.setUpXML();
        this.eventCase = 9;
        String expectedString = "<TD></TD>";
        this.fModel.setText(null, "<TD></TD><TD></TD>");
        this.fModel.replaceText(null, 0, 9, "");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testMethodAttributeNameReplace1() {
        this.setUpXML();
        this.eventCase = 22;
        String startString = "<tagName abc=\"bsf\">";
        String expectedString = "<tagName abcde=\"bsf\">";
        String changes = "abcde";
        int startOfChanges = 9;
        int lengthToReplace = 3;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testModifyMiddle() {
        this.setUpXML();
        this.eventCase = 5;
        String expectedString = "<ABC><JKL><GHI>";
        this.fModel.setText(null, "<ABC><DEF><GHI>");
        this.fModel.replaceText(null, 0, 15, "<ABC><JKL><GHI>");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testNoChange1() {
        this.setUpXML();
        this.eventCase = 1;
        String expectedString = "<ABC><DEF><GHI>";
        this.fModel.setText(null, "<ABC><DEF><GHI>");
        this.fModel.replaceText(null, 10, 0, "");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testNoChange2() {
        this.setUpXML();
        this.eventCase = 2;
        String expectedString = "<ABC><DEF><GHI>";
        this.fModel.setText(null, "<ABC><DEF><GHI>");
        this.fModel.replaceText(null, 0, 15, "<ABC><DEF><GHI>");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testSimilarStart() {
        this.setUpXML();
        this.eventCase = 6;
        String expectedString = "<P><B></B><B></B></P>";
        this.fModel.setText(null, "<P><B></B></P>");
        this.fModel.replaceText(null, 3, 0, "<B></B>");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testSimilarStartEnd() {
        this.setUpXML();
        this.eventCase = 8;
        String expectedString = "<P><B><B></B></B></P>";
        this.fModel.setText(null, "<P><B></B></P>");
        this.fModel.replaceText(null, 6, 0, "<B></B>");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testSimiliarEnd() {
        this.setUpXML();
        this.eventCase = 7;
        String expectedString = "<P><B></B><P><P>";
        this.fModel.setText(null, "<P><B></B><P>");
        this.fModel.replaceText(null, 10, 0, "<P>");
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testTagReDetection() {
        this.setUpJSP();
        this.eventCase = 1001;
        String startString = "<p>test<<SCRIPT>";
        String changes = "S";
        String expectedString = "<p>test<S<SCRIPT>";
        int startOfChanges = 8;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testTagReDetection2() {
        this.setUpJSP();
        this.eventCase = 1003;
        String startString = "<p>test<<SCRIPT>";
        String changes = "S";
        String expectedString = "<p>test<<SCRIPTS>";
        int startOfChanges = 15;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    public void testTagReDetection3() {
        this.setUpJSP();
        this.eventCase = 1001;
        String startString = "<p>test<test>";
        String changes = "%";
        String expectedString = "<p>test<%test>";
        int startOfChanges = 8;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        UnitTests.assertTrue((String)"event type", (boolean)this.eventResult);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.fModel != null) {
            this.fModel.removeDocumentChangedListener((IStructuredDocumentListener)this.proxy);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testPageDirective() {
        IStructuredDocument document;
        boolean verbose = false;
        this.setUpJSP();
        this.eventCase = 999;
        String startString = "<%@page lang=\"java\" <SCRIPT>var <% test %> String</SCRIPT>";
        String changes = "s";
        String expectedString = "<%@page lang=\"javas\" <SCRIPT>var <% test %> String</SCRIPT>";
        int startOfChanges = 18;
        int lengthToReplace = 0;
        this.fModel.setText(null, startString);
        if (verbose) {
            Debug.dump((IStructuredDocument)this.fModel, (boolean)true);
        }
        StructuredDocumentEvent structuredDocumentEvent = this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        String resultString = this.fModel.getText();
        boolean result = expectedString.equals(resultString);
        UnitTests.assertTrue((String)"text update", (boolean)result);
        if (verbose) {
            System.out.println();
            System.out.println("structured document:");
            document = structuredDocumentEvent.getStructuredDocument();
            Debug.dump((IStructuredDocument)document, (boolean)true);
        }
        changes = "";
        expectedString = "<%@page lang=\"javas\" <SCRIPT>var <% test %> String</SCRIPT>";
        startOfChanges = 19;
        lengthToReplace = 1;
        this.fModel.replaceText(null, startOfChanges, lengthToReplace, changes);
        resultString = this.fModel.getText();
        UnitTests.assertTrue((String)"text update", (boolean)result);
        if (verbose) {
            System.out.println();
            System.out.println("structured document:");
            document = structuredDocumentEvent.getStructuredDocument();
            Debug.dump((IStructuredDocument)document, (boolean)true);
        }
    }

    protected class StructuredDocumentListenerProxy
    implements IStructuredDocumentListener {
        protected StructuredDocumentListenerProxy() {
        }

        public void newModel(NewDocumentEvent structuredDocumentEvent) {
            UnitTests.this.handleEvent((StructuredDocumentEvent)structuredDocumentEvent);
        }

        public void noChange(NoChangeEvent structuredDocumentEvent) {
            UnitTests.this.handleEvent((StructuredDocumentEvent)structuredDocumentEvent);
        }

        public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
            UnitTests.this.handleEvent((StructuredDocumentEvent)structuredDocumentEvent);
        }

        public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
            UnitTests.this.handleEvent((StructuredDocumentEvent)structuredDocumentEvent);
        }

        public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
            UnitTests.this.handleEvent((StructuredDocumentEvent)structuredDocumentEvent);
        }
    }
}

