/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.partitioning;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.text.DecimalFormat;
import junit.framework.TestCase;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.StringUtils;

public class TestStructuredPartitionerJSP
extends TestCase {
    private boolean DEBUG_PRINT_RESULT = false;
    protected ITypedRegion[] partitions = null;
    private boolean useFormatter = true;
    protected DecimalFormat formatter;

    public TestStructuredPartitionerJSP(String name) {
        super(name);
        if (this.DEBUG_PRINT_RESULT && this.useFormatter) {
            this.formatter = new DecimalFormat();
        }
    }

    public void testJSP1() throws IOException, BadLocationException {
        int expectedPartitions = 8;
        int nPartitions = this.doComputePartitioningTest("testfiles/jsp/example01.jsp");
        TestStructuredPartitionerJSP.assertTrue((String)"wrong number of partitions", (nPartitions == expectedPartitions ? 1 : 0) != 0);
        this.checkSeams();
        this.verifyPartitionTypes(this.partitions, new String[]{"org.eclipse.jst.jsp.JSP_DIRECTIVE", "org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.jst.jsp.JSP_DIRECTIVE", "org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.jst.jsp.SCRIPT.JAVA", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.wst.html.HTML_DEFAULT"});
    }

    public void testJSP2() throws IOException, BadLocationException {
        int expectedPartitions = 11;
        int nPartitions = this.doComputePartitioningTest("testfiles/jsp/example02.jsp");
        TestStructuredPartitionerJSP.assertTrue((String)"wrong number of partitions", (nPartitions == expectedPartitions ? 1 : 0) != 0);
        this.checkSeams();
        this.verifyPartitionTypes(this.partitions, new String[]{"org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.jst.jsp.SCRIPT.JAVA", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.wst.html.HTML_COMMENT", "org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.jst.jsp.SCRIPT.JAVA", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.wst.html.HTML_DEFAULT"});
    }

    public void testJSP3() throws IOException, BadLocationException {
        int expectedPartitions = 5;
        int nPartitions = this.doComputePartitioningTest("testfiles/jsp/example03.jsp");
        TestStructuredPartitionerJSP.assertTrue((String)"wrong number of partitions", (nPartitions == expectedPartitions ? 1 : 0) != 0);
        this.checkSeams();
        this.verifyPartitionTypes(this.partitions, new String[]{"org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.wst.html.SCRIPT", "org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.wst.css.STYLE", "org.eclipse.wst.html.HTML_DEFAULT"});
    }

    public void testJSP4() throws IOException, BadLocationException {
        int expectedPartitions = 8;
        int nPartitions = this.doComputePartitioningTest("testfiles/jsp/example04.jsp");
        TestStructuredPartitionerJSP.assertTrue((String)"wrong number of partitions", (nPartitions == expectedPartitions ? 1 : 0) != 0);
        this.checkSeams();
        this.verifyPartitionTypes(this.partitions, new String[]{"org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.jst.jsp.SCRIPT.JAVA", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.wst.html.SCRIPT.language.MYLANGUAGE", "org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.jst.jsp.JSP_COMMENT", "org.eclipse.wst.html.HTML_DEFAULT"});
    }

    public void testJSP5() throws IOException, BadLocationException {
        int expectedPartitions = 17;
        int nPartitions = this.doComputePartitioningTest("testfiles/jsp/example05.jsp");
        TestStructuredPartitionerJSP.assertTrue((String)"wrong number of partitions", (nPartitions == expectedPartitions ? 1 : 0) != 0);
        this.checkSeams();
        this.verifyPartitionTypes(this.partitions, new String[]{"org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.wst.html.SCRIPT", "org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.jst.jsp.SCRIPT.JAVA", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.jst.jsp.JSP_COMMENT", "org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.jst.jsp.SCRIPT.JAVA", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.wst.html.HTML_DEFAULT", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.jst.jsp.SCRIPT.JAVA", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.wst.html.HTML_DEFAULT"});
    }

    public void testJSP6() throws IOException, BadLocationException {
        int expectedPartitions = 1;
        int nPartitions = this.doComputePartitioningTest("testfiles/jsp/example06.jsp");
        TestStructuredPartitionerJSP.assertTrue((String)"wrong number of partitions", (nPartitions == expectedPartitions ? 1 : 0) != 0);
        this.checkSeams();
        this.verifyPartitionTypes(this.partitions, new String[]{"org.eclipse.jst.jsp.JSP_DIRECTIVE"});
    }

    public void testPerfJSP() throws IOException, BadLocationException {
        this.doTimedComputePartitioningTest("testfiles/jsp/company300k.jsp");
    }

    public void testEmpty() throws IOException, BadLocationException {
        int expectedPartitions = 1;
        int nPartitions = this.doComputePartitioningTest("testfiles/xml/empty.xml");
        TestStructuredPartitionerJSP.assertTrue((String)"wrong number of partitions", (nPartitions == expectedPartitions ? 1 : 0) != 0);
        this.checkSeams();
        this.verifyPartitionTypes(this.partitions, new String[]{"org.eclipse.wst.xml.XML_DEFAULT"});
    }

    protected void checkSeams() {
        if (this.partitions == null) {
            return;
        }
        int offset = 0;
        int i = 0;
        while (i < this.partitions.length) {
            TestStructuredPartitionerJSP.assertEquals((String)"partitions are not contiguous!", (int)this.partitions[i].getOffset(), (int)offset);
            offset = this.partitions[i].getOffset() + this.partitions[i].getLength();
            ++i;
        }
    }

    protected int doComputePartitioningTest(String filename) throws IOException, BadLocationException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        if (inStream == null) {
            inStream = new StringBufferInputStream("");
        }
        IStructuredModel model = modelManager.getModelForEdit(filename, inStream, null);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (this.DEBUG_PRINT_RESULT && this.useFormatter) {
            double baseTen = Math.log(10.0);
            this.formatter.setMinimumIntegerDigits((int)(Math.log(structuredDocument.getLength()) / baseTen) + 1);
            this.formatter.setGroupingUsed(false);
        }
        this.partitions = structuredDocument.computePartitioning(0, structuredDocument.getLength());
        if (this.DEBUG_PRINT_RESULT) {
            String contents = null;
            System.out.println("\nfilename: " + filename);
            int i = 0;
            while (i < this.partitions.length) {
                try {
                    contents = structuredDocument.get(this.partitions[i].getOffset(), this.partitions[i].getLength());
                }
                catch (BadLocationException badLocationException) {
                    contents = "*error*";
                }
                if (this.useFormatter) {
                    System.out.println(String.valueOf(this.formatter.format(this.partitions[i].getOffset())) + ":" + this.formatter.format(this.partitions[i].getLength()) + " - " + this.partitions[i].getType() + " [" + StringUtils.escape((String)contents) + "]");
                } else {
                    System.out.println(this.partitions[i] + " [" + StringUtils.escape((String)contents) + "]");
                }
                ++i;
            }
        }
        this.checkSeams();
        model.releaseFromEdit();
        inStream.close();
        if (this.partitions == null) {
            return -1;
        }
        return this.partitions.length;
    }

    protected int doTimedComputePartitioningTest(String filename) throws IOException, BadLocationException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        if (inStream == null) {
            inStream = new StringBufferInputStream("");
        }
        IStructuredModel model = modelManager.getModelForEdit(filename, inStream, null);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (this.DEBUG_PRINT_RESULT && this.useFormatter) {
            double baseTen = Math.log(10.0);
            this.formatter.setMinimumIntegerDigits((int)(Math.log(structuredDocument.getLength()) / baseTen) + 1);
            this.formatter.setGroupingUsed(false);
        }
        long startTime = System.currentTimeMillis();
        this.partitions = structuredDocument.computePartitioning(0, structuredDocument.getLength());
        long endTime = System.currentTimeMillis();
        if (this.DEBUG_PRINT_RESULT) {
            String contents = null;
            System.out.println("\nfilename: " + filename);
            System.out.println("Time to compute " + this.partitions.length + ": " + (endTime - startTime) + " (msecs)");
            int i = 0;
            while (i < this.partitions.length) {
                try {
                    contents = structuredDocument.get(this.partitions[i].getOffset(), this.partitions[i].getLength());
                }
                catch (BadLocationException badLocationException) {
                    contents = "*error*";
                }
                if (this.useFormatter) {
                    System.out.println(String.valueOf(this.formatter.format(this.partitions[i].getOffset())) + ":" + this.formatter.format(this.partitions[i].getLength()) + " - " + this.partitions[i].getType() + " [" + StringUtils.escape((String)contents) + "]");
                } else {
                    System.out.println(this.partitions[i] + " [" + StringUtils.escape((String)contents) + "]");
                }
                ++i;
            }
        }
        this.checkSeams();
        model.releaseFromEdit();
        inStream.close();
        if (this.partitions == null) {
            return -1;
        }
        return this.partitions.length;
    }

    protected ITypedRegion getPartitionTest(String filename, int offset) throws IOException, BadLocationException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        IStructuredModel model = modelManager.getModelForEdit(filename, inStream, null);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        this.partitions = null;
        ITypedRegion partition = structuredDocument.getPartition(offset);
        if (this.DEBUG_PRINT_RESULT) {
            String contents = null;
            System.out.println("\nfilename: " + filename);
            try {
                contents = structuredDocument.get(partition.getOffset(), partition.getLength());
            }
            catch (BadLocationException badLocationException) {
                contents = "*error*";
            }
            System.out.println(partition + " [" + StringUtils.escape((String)contents) + "]");
        }
        model.releaseFromEdit();
        inStream.close();
        return partition;
    }

    protected void verifyPartitionTypes(ITypedRegion[] actualTypedRegions, String[] expectedTypes) {
        int i = 0;
        while (i < expectedTypes.length) {
            TestStructuredPartitionerJSP.assertEquals((String)"partition type mismatched", (String)expectedTypes[i], (String)actualTypedRegions[i].getType());
            ++i;
        }
    }

    protected void verifyPartitionRegions(ITypedRegion[] typedRegions, int[] offsets) {
        int i = 0;
        while (i < offsets.length) {
            TestStructuredPartitionerJSP.assertEquals((String)"offset mismatched", (int)typedRegions[i].getOffset(), (int)offsets[i]);
            if (i > 0) {
                TestStructuredPartitionerJSP.assertEquals((String)"lengths misaligned", (int)typedRegions[i].getOffset(), (int)(typedRegions[i - 1].getOffset() + typedRegions[i - 1].getLength()));
            }
            ++i;
        }
    }
}

