/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.viewer;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.ui.internal.provisional.StructuredTextViewerConfigurationJSP;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentoutline.StructuredTextEditorContentOutlinePage;
import org.eclipse.wst.sse.ui.internal.provisional.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.w3c.dom.Attr;

public class ViewerTestJSP
extends ViewPart {
    private final String SSE_EDITOR_FONT = "org.eclipse.wst.sse.ui.textfont";
    private final String DEFAULT_VIEWER_CONTENTS = "<%@ page contentType=\"text/html; charset=ISO-8859-1\" %>\n";
    private StructuredTextViewer fSourceViewer = null;
    private StructuredTextViewerConfiguration fConfig = null;
    private IContentOutlinePage fContentOutlinePage = null;
    private INodeSelectionListener fHighlightRangeListener = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void addActions(IContributionManager mgr) {
        if (mgr != null) {
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "New JSP";
                }

                public void run() {
                    super.run();
                    BusyIndicator.showWhile((Display)ViewerTestJSP.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ViewerTestJSP.access$1(1.access$0(this.this$1));
                            ViewerTestJSP.access$0(1.access$0(this.this$1)).setEditable(true);
                        }
                    });
                }

                static /* synthetic */ ViewerTestJSP access$0(1 var0) {
                    return var0.ViewerTestJSP.this;
                }
            });
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Change Visibility";
                }

                public void run() {
                    super.run();
                    NumberInputDialog dlg = new NumberInputDialog(ViewerTestJSP.this.fSourceViewer.getControl().getShell());
                    int proceed = dlg.open();
                    if (proceed == 1) {
                        return;
                    }
                    ViewerTestJSP.this.fSourceViewer.resetVisibleRegion();
                    ViewerTestJSP.this.fSourceViewer.setVisibleRegion(dlg.startValue, dlg.lengthValue);
                }
            });
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Show All";
                }

                public void run() {
                    super.run();
                    ViewerTestJSP.this.fSourceViewer.resetVisibleRegion();
                }
            });
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Take Input from Active Editor";
                }

                public void run() {
                    super.run();
                    ITextEditor textEditor = ViewerTestJSP.this.getActiveEditor();
                    if (textEditor != null) {
                        ViewerTestJSP.this.setupViewerForEditor(textEditor);
                        ViewerTestJSP.this.fSourceViewer.setEditable(true);
                    }
                }
            });
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Take Input and Follow Selection";
                }

                public void run() {
                    super.run();
                    ViewerTestJSP.this.followSelection();
                    ViewerTestJSP.this.fSourceViewer.setEditable(true);
                }
            });
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Take Input and Follow Selection As ReadOnly";
                }

                public void run() {
                    super.run();
                    ViewerTestJSP.this.followSelection();
                    ViewerTestJSP.this.fSourceViewer.setEditable(false);
                }
            });
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Stop Following Selection";
                }

                public void run() {
                    super.run();
                    ViewerTestJSP.this.stopFollowSelection();
                }
            });
        }
    }

    public void createPartControl(Composite parent) {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        this.addActions((IContributionManager)mgr);
        this.fSourceViewer = new StructuredTextViewer(parent, null, null, false, 0);
        this.fConfig = new StructuredTextViewerConfigurationJSP();
        this.setupViewerForNew();
        this.setupViewerPreferences();
    }

    public void dispose() {
        this.stopFollowSelection();
        this.fSourceViewer.unconfigure();
    }

    public void setFocus() {
        if (this.fSourceViewer.getControl() != null && !this.fSourceViewer.getControl().isDisposed()) {
            this.fSourceViewer.getControl().setFocus();
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    private void setupViewerPreferences() {
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
    }

    private void setupViewerForNew() {
        this.stopFollowSelection();
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredDocument doc = modelManager.createStructuredDocumentFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        doc.set("<%@ page contentType=\"text/html; charset=ISO-8859-1\" %>\n");
        this.fSourceViewer.setDocument((IDocument)doc);
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fConfig);
    }

    private ITextEditor getActiveEditor() {
        ITextEditor editor = null;
        IEditorPart editorPart = this.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof ITextEditor) {
            editor = (ITextEditor)editorPart;
        }
        if (editor == null && editorPart != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            editor = (ITextEditor)editorPart.getAdapter((Class)clazz);
        }
        return editor;
    }

    private void setupViewerForEditor(ITextEditor editor) {
        this.stopFollowSelection();
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        this.fSourceViewer.setDocument(doc);
        this.fSourceViewer.configure((SourceViewerConfiguration)new StructuredTextViewerConfigurationJSP());
    }

    private void followSelection() {
        ITextEditor editor = this.getActiveEditor();
        if (editor != null) {
            Class<?> clazz;
            this.setupViewerForEditor(editor);
            if (this.fHighlightRangeListener == null) {
                this.fHighlightRangeListener = new NodeRangeSelectionListener();
            }
            if ((clazz = class$1) == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fContentOutlinePage = (IContentOutlinePage)editor.getAdapter((Class)clazz);
            if (this.fContentOutlinePage != null && this.fContentOutlinePage instanceof StructuredTextEditorContentOutlinePage) {
                ((StructuredTextEditorContentOutlinePage)this.fContentOutlinePage).getViewerSelectionManager().addNodeSelectionListener(this.fHighlightRangeListener);
                if (!this.fContentOutlinePage.getSelection().isEmpty() && this.fContentOutlinePage.getSelection() instanceof IStructuredSelection) {
                    this.fSourceViewer.resetVisibleRegion();
                    Object[] nodes = ((IStructuredSelection)this.fContentOutlinePage.getSelection()).toArray();
                    IndexedRegion startNode = (IndexedRegion)nodes[0];
                    IndexedRegion endNode = (IndexedRegion)nodes[nodes.length - 1];
                    if (startNode instanceof Attr) {
                        startNode = (IndexedRegion)((Attr)startNode).getOwnerElement();
                    }
                    if (endNode instanceof Attr) {
                        endNode = (IndexedRegion)((Attr)endNode).getOwnerElement();
                    }
                    int start = startNode.getStartOffset();
                    int end = endNode.getEndOffset();
                    this.fSourceViewer.setVisibleRegion(start, end - start);
                    this.fSourceViewer.setSelectedRange(start, 0);
                }
            }
        }
    }

    private void stopFollowSelection() {
        if (this.fContentOutlinePage != null && this.fContentOutlinePage instanceof StructuredTextEditorContentOutlinePage) {
            ((StructuredTextEditorContentOutlinePage)this.fContentOutlinePage).getViewerSelectionManager().removeNodeSelectionListener(this.fHighlightRangeListener);
            this.fSourceViewer.resetVisibleRegion();
            this.fContentOutlinePage = null;
        }
    }

    static /* synthetic */ void access$1(ViewerTestJSP viewerTestJSP) {
        viewerTestJSP.setupViewerForNew();
    }

    protected class NodeRangeSelectionListener
    implements INodeSelectionListener {
        protected NodeRangeSelectionListener() {
        }

        public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
            if (!event.getSelectedNodes().isEmpty()) {
                IndexedRegion startNode = (IndexedRegion)event.getSelectedNodes().get(0);
                IndexedRegion endNode = (IndexedRegion)event.getSelectedNodes().get(event.getSelectedNodes().size() - 1);
                if (startNode instanceof Attr) {
                    startNode = (IndexedRegion)((Attr)startNode).getOwnerElement();
                }
                if (endNode instanceof Attr) {
                    endNode = (IndexedRegion)((Attr)endNode).getOwnerElement();
                }
                int start = startNode.getStartOffset();
                int end = endNode.getEndOffset();
                ViewerTestJSP.this.fSourceViewer.resetVisibleRegion();
                ViewerTestJSP.this.fSourceViewer.setVisibleRegion(start, end - start);
                ViewerTestJSP.this.fSourceViewer.setSelectedRange(start, 0);
            } else {
                ViewerTestJSP.this.fSourceViewer.resetVisibleRegion();
            }
        }
    }

    protected class NumberInputDialog
    extends Dialog {
        public Text start;
        int startValue;
        public Text length;
        int lengthValue;

        public NumberInputDialog(Shell shell) {
            super(shell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(composite, 0);
            container.setLayoutData((Object)new GridData(1808));
            container.setLayout((Layout)new GridLayout(2, true));
            this.setShellStyle(this.getShell().getStyle() | 0x10);
            Label label = new Label(container, 0);
            label.setText("Start");
            label.setLayoutData((Object)new GridData(1808));
            label = new Label(container, 0);
            label.setText("Length");
            label.setLayoutData((Object)new GridData(1808));
            this.start = new Text(container, 2048);
            this.startValue = ViewerTestJSP.this.fSourceViewer.getVisibleRegion().getOffset();
            this.start.setText("" + this.startValue);
            this.start.setLayoutData((Object)new GridData(1808));
            this.length = new Text(container, 2048);
            this.lengthValue = ViewerTestJSP.this.fSourceViewer.getVisibleRegion().getLength();
            this.length.setText("" + this.lengthValue);
            this.length.setLayoutData((Object)new GridData(1808));
            return composite;
        }

        protected void okPressed() {
            try {
                this.startValue = Integer.decode(this.start.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.startValue = 0;
            }
            try {
                this.lengthValue = Integer.decode(this.length.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.lengthValue = 0;
            }
            super.okPressed();
        }
    }
}

