/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.validation.tests.internal;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationReport;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.ui.internal.validation.XMLValidator;
import org.eclipse.wst.xml.validation.tests.internal.XMLValidatorTestsPlugin;

public class BaseTestCase
extends TestCase {
    protected String FILE_PROTOCOL = "file:///";
    protected String PLUGIN_ABSOLUTE_PATH;
    protected String SAMPLES_DIR = "testresources/samples/";
    protected XMLValidator validator = XMLValidator.getInstance();

    protected void setUp() {
        this.PLUGIN_ABSOLUTE_PATH = String.valueOf(XMLValidatorTestsPlugin.getPluginLocation().toString()) + "/";
    }

    public void runTest(String testfile, List keys, int numErrors, int numWarnings) {
        XMLValidationReport valreport = this.validator.validate(testfile);
        ValidationMessage[] valmessages = valreport.getValidationMessages();
        int nummessages = valmessages.length;
        int errorCount = 0;
        int warningCount = 0;
        int i = 0;
        while (i < nummessages) {
            ValidationMessage valmes = valmessages[i];
            String key = valmes.getKey();
            BaseTestCase.assertTrue((String)("The message key " + key + " is not correct."), (boolean)keys.contains(key));
            if (valmes.getSeverity() == ValidationMessage.SEV_LOW) {
                ++warningCount;
            } else {
                ++errorCount;
            }
            ++i;
        }
        BaseTestCase.assertEquals((String)(String.valueOf(errorCount) + " errors were reported but " + numErrors + " errors were expected."), (int)numErrors, (int)errorCount);
        BaseTestCase.assertEquals((String)(String.valueOf(warningCount) + " warnings were reported but " + numWarnings + " warnings were expected."), (int)numWarnings, (int)warningCount);
    }
}

